/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import trofers.util.JsonHelper;

public record EffectInfo(@Nullable SoundInfo sound, RewardInfo rewards) {
    public static final EffectInfo NONE = new EffectInfo(null, RewardInfo.NONE);

    public void toNetwork(class_2540 buffer) {
        buffer.writeBoolean(this.sound() != null);
        if (this.sound() != null) {
            this.sound().toNetwork(buffer);
        }
        this.rewards().toNetwork(buffer);
    }

    public static EffectInfo fromNetwork(class_2540 buffer) {
        SoundInfo sound = null;
        if (buffer.readBoolean()) {
            sound = SoundInfo.fromNetwork(buffer);
        }
        RewardInfo rewards = RewardInfo.fromNetwork(buffer);
        return new EffectInfo(sound, rewards);
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        if (this.sound() != null) {
            object.add("sound", (JsonElement)this.sound().toJson());
        }
        if (!this.rewards().equals(RewardInfo.NONE)) {
            object.add("rewards", (JsonElement)this.rewards().toJson());
        }
        return object;
    }

    public static EffectInfo fromJson(JsonObject object) {
        SoundInfo sound = null;
        if (object.has("sound")) {
            sound = SoundInfo.fromJson(class_3518.method_15296((JsonObject)object, (String)"sound"));
        }
        RewardInfo rewards = RewardInfo.NONE;
        if (object.has("rewards")) {
            rewards = RewardInfo.fromJson(class_3518.method_15296((JsonObject)object, (String)"rewards"));
        }
        return new EffectInfo(sound, rewards);
    }

    public record SoundInfo(class_2960 soundEvent, float volume, float pitch) {
        private void toNetwork(class_2540 buffer) {
            buffer.method_10812(this.soundEvent());
            buffer.writeFloat(this.volume());
            buffer.writeFloat(this.pitch());
        }

        private static SoundInfo fromNetwork(class_2540 buffer) {
            return new SoundInfo(buffer.method_10810(), buffer.readFloat(), buffer.readFloat());
        }

        private JsonObject toJson() {
            JsonObject result = new JsonObject();
            result.addProperty("soundEvent", this.soundEvent().toString());
            if (this.volume() != 1.0f) {
                result.addProperty("volume", (Number)Float.valueOf(this.volume()));
            }
            if (this.pitch() != 1.0f) {
                result.addProperty("pitch", (Number)Float.valueOf(this.pitch()));
            }
            return result;
        }

        private static SoundInfo fromJson(JsonObject object) {
            class_2960 soundEvent = new class_2960(class_3518.method_15265((JsonObject)object, (String)"soundEvent"));
            float volume = JsonHelper.readOptionalFloat(object, "volume", 1);
            float pitch = JsonHelper.readOptionalFloat(object, "pitch", 1);
            return new SoundInfo(soundEvent, volume, pitch);
        }
    }

    public record RewardInfo(@Nullable class_2960 lootTable, class_2487 statusEffect, int cooldown) {
        public static RewardInfo NONE = new RewardInfo(null, new class_2487(), 0);

        @Nullable
        public class_1293 createStatusEffect() {
            if (!this.statusEffect().method_33133()) {
                return class_1293.method_5583((class_2487)this.statusEffect());
            }
            return null;
        }

        private void toNetwork(class_2540 buffer) {
            buffer.writeBoolean(this.lootTable() != null);
            if (this.lootTable() != null) {
                buffer.method_10812(this.lootTable());
            }
            buffer.method_10794(this.statusEffect());
            buffer.writeInt(this.cooldown());
        }

        private static RewardInfo fromNetwork(class_2540 buffer) {
            class_2960 lootTable = null;
            if (buffer.readBoolean()) {
                lootTable = buffer.method_10810();
            }
            class_2487 statusEffect = buffer.method_10798();
            int cooldown = buffer.readInt();
            return new RewardInfo(lootTable, statusEffect, cooldown);
        }

        private JsonObject toJson() {
            class_1293 effect;
            JsonObject result = new JsonObject();
            if (this.lootTable() != null) {
                result.addProperty("lootTable", this.lootTable().toString());
            }
            if (!this.statusEffect().method_33133() && (effect = class_1293.method_5583((class_2487)this.statusEffect())) != null) {
                JsonObject statusEffect = new JsonObject();
                result.add("statusEffect", (JsonElement)statusEffect);
                statusEffect.addProperty("effect", class_7923.field_41174.method_10221((Object)effect.method_5579()).toString());
                statusEffect.addProperty("duration", (Number)effect.method_5584());
                if (effect.method_5578() != 0) {
                    statusEffect.addProperty("amplifier", (Number)effect.method_5578());
                }
            }
            if (this.cooldown() != 0) {
                result.addProperty("cooldown", (Number)this.cooldown());
            }
            return result;
        }

        private static RewardInfo fromJson(JsonObject object) {
            class_2960 lootTable = null;
            if (object.has("lootTable")) {
                lootTable = new class_2960(class_3518.method_15265((JsonObject)object, (String)"lootTable"));
            }
            class_2487 statusEffect = new class_2487();
            if (object.has("statusEffect")) {
                JsonObject effectObject = class_3518.method_15296((JsonObject)object, (String)"statusEffect");
                class_2960 effectID = new class_2960(class_3518.method_15265((JsonObject)effectObject, (String)"effect"));
                if (!class_7923.field_41174.method_10250(effectID)) {
                    throw new JsonParseException(String.format("Unknown effect: %s", effectID));
                }
                class_1291 effect = (class_1291)class_7923.field_41174.method_10223(effectID);
                int duration = class_3518.method_15260((JsonObject)effectObject, (String)"duration");
                int amplifier = 0;
                if (effectObject.has("amplifier")) {
                    amplifier = class_3518.method_15260((JsonObject)effectObject, (String)"amplifier");
                }
                statusEffect = new class_1293(effect, duration, amplifier).method_5582(new class_2487());
            }
            int cooldown = 0;
            if (object.has("cooldown")) {
                cooldown = class_3518.method_15260((JsonObject)object, (String)"cooldown");
            }
            return new RewardInfo(lootTable, statusEffect, cooldown);
        }
    }
}

