/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import trofers.util.JsonHelper;

public record Animation(Type type, float speed) {
    public static final Animation STATIC = new Animation(Type.FIXED, 1.0f);

    public void toNetwork(class_2540 buffer) {
        buffer.writeByte(this.type.ordinal());
        buffer.writeFloat(this.speed);
    }

    public static Animation fromNetwork(class_2540 buffer) {
        Type type = Type.values()[buffer.readByte()];
        float speed = buffer.readFloat();
        if (type == Type.FIXED) {
            return STATIC;
        }
        return new Animation(type, speed);
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        result.addProperty("type", this.type().name());
        if (this.speed() != 1.0f) {
            result.addProperty("speed", (Number)Float.valueOf(this.speed()));
        }
        return result;
    }

    public static Animation fromJson(JsonObject object) {
        Type type = Type.fromJson(object.get("type"));
        float speed = JsonHelper.readOptionalFloat(object, "speed", 1);
        return new Animation(type, speed);
    }

    public static enum Type {
        FIXED("fixed"),
        SPINNING("spinning"),
        TUMBLING("tumbling");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type fromJson(JsonElement element) {
            String name = class_3518.method_15287((JsonElement)element, (String)"animation");
            for (Type animation : Type.values()) {
                if (!animation.name.equals(name)) continue;
                return animation;
            }
            throw new JsonParseException(String.format("Invalid trophy animation type: %s", name));
        }
    }
}

