/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;
import trofers.trophy.Trophy;
import trofers.trophy.components.Animation;
import trofers.trophy.components.ColorInfo;
import trofers.trophy.components.DisplayInfo;
import trofers.trophy.components.EffectInfo;
import trofers.trophy.components.EntityInfo;
import trofers.util.JsonHelper;

public abstract class TrophyBuilder<T extends TrophyBuilder<T>> {
    private Optional<class_2561> name = Optional.empty();
    private final List<class_2561> tooltipLines = new ArrayList<class_2561>();
    private DisplayInfo displayInfo = DisplayInfo.NONE;
    private Animation animation = Animation.STATIC;
    private ColorInfo colorInfo = ColorInfo.NONE;
    private EffectInfo effectInfo = EffectInfo.NONE;
    private boolean isHidden = false;
    private final Set<String> requiredMods = new HashSet<String>();

    public Trophy build(class_2960 id) {
        return new Trophy(id, this.name, this.tooltipLines, this.displayInfo, this.animation, this.getDisplayItem(), this.getEntityInfo(), this.colorInfo, this.effectInfo, this.isHidden);
    }

    protected abstract class_1799 getDisplayItem();

    protected abstract void displayItemToJson(JsonObject var1);

    protected abstract Optional<EntityInfo> getEntityInfo();

    protected abstract void entityInfoToJson(JsonObject var1);

    public T requiresMod(String modId) {
        if (!modId.equals("trofers") && !modId.equals("minecraft")) {
            this.requiredMods.add(modId);
        }
        return (T)this;
    }

    public T name(@Nullable class_2561 name) {
        this.name = Optional.ofNullable(name);
        return (T)this;
    }

    public T addTooltipLine(class_2561 component) {
        this.tooltipLines.add(component);
        return (T)this;
    }

    public T offset(double xOffset, double yOffset, double zOffset) {
        this.displayInfo = new DisplayInfo((float)xOffset, (float)yOffset, (float)zOffset, this.displayInfo.xRotation(), this.displayInfo.yRotation(), this.displayInfo.zRotation(), this.displayInfo.scale());
        return (T)this;
    }

    public T rotate(double xRotation, double yRotation, double zRotation) {
        this.displayInfo = new DisplayInfo(this.displayInfo.xOffset(), this.displayInfo.yOffset(), this.displayInfo.zOffset(), (float)xRotation, (float)yRotation, (float)zRotation, this.displayInfo.scale());
        return (T)this;
    }

    public T scale(double scale) {
        this.displayInfo = new DisplayInfo(this.displayInfo.xOffset(), this.displayInfo.yOffset(), this.displayInfo.zOffset(), this.displayInfo.xRotation(), this.displayInfo.yRotation(), this.displayInfo.zRotation(), (float)scale);
        return (T)this;
    }

    public T animation(Animation.Type type, float speed) {
        this.animation = new Animation(type, speed);
        return (T)this;
    }

    public T animation(Animation.Type type) {
        return this.animation(type, 1.0f);
    }

    public T color(int baseColor, int accentColor) {
        this.colorInfo = new ColorInfo(baseColor, accentColor);
        return (T)this;
    }

    public T baseColor(int color) {
        return this.color(color, this.colorInfo.accent());
    }

    public T accentColor(int color) {
        return this.color(this.colorInfo.base(), color);
    }

    private T effectInfo(@Nullable EffectInfo.SoundInfo soundInfo, EffectInfo.RewardInfo rewardInfo) {
        this.effectInfo = new EffectInfo(soundInfo, rewardInfo);
        return (T)this;
    }

    public T sound(class_2960 sound, float volume, float pitch) {
        return this.effectInfo(new EffectInfo.SoundInfo(sound, volume, pitch), this.effectInfo.rewards());
    }

    public T sound(class_2960 sound) {
        return this.sound(sound, 1.0f, 1.0f);
    }

    public T sound(class_3414 sound, float volume, float pitch) {
        return this.sound(sound.method_14833(), volume, pitch);
    }

    public T sound(class_3414 soundEvent) {
        return this.sound(soundEvent, 1.0f, 1.0f);
    }

    private T rewardInfo(@Nullable class_2960 lootTable, class_2487 statusEffect, int cooldown) {
        return this.effectInfo(this.effectInfo.sound(), new EffectInfo.RewardInfo(lootTable, statusEffect, cooldown));
    }

    public T lootTable(@Nullable class_2960 lootTable) {
        return this.rewardInfo(lootTable, this.effectInfo.rewards().statusEffect(), this.effectInfo.rewards().cooldown());
    }

    public T mobEffect(class_2487 mobEffect) {
        return this.rewardInfo(this.effectInfo.rewards().lootTable(), mobEffect, this.effectInfo.rewards().cooldown());
    }

    public T mobEffect(class_1291 effect, int timeSeconds, int amplifier) {
        return this.mobEffect(new class_1293(effect, timeSeconds * 20, amplifier).method_5582(new class_2487()));
    }

    public T mobEffect(class_1291 effect, int timeSeconds) {
        return this.mobEffect(effect, timeSeconds, 0);
    }

    public T cooldown(int timeSeconds) {
        return this.rewardInfo(this.effectInfo.rewards().lootTable(), this.effectInfo.rewards().statusEffect(), timeSeconds * 20);
    }

    public T setHidden(boolean isHidden) {
        this.isHidden = isHidden;
        return (T)this;
    }

    public T setHidden() {
        return this.setHidden(true);
    }

    public JsonObject toJson() {
        return this.toJson(new JsonObject());
    }

    public JsonObject toJson(JsonObject result) {
        JsonHelper.addModLoadedConditions(result, (String[])this.requiredMods.toArray(String[]::new));
        this.name.ifPresent(component -> result.add("name", class_2561.class_2562.method_10868((class_2561)component)));
        if (!this.tooltipLines.isEmpty()) {
            JsonArray tooltip = new JsonArray();
            result.add("tooltip", (JsonElement)tooltip);
            for (class_2561 line : this.tooltipLines) {
                tooltip.add(class_2561.class_2562.method_10868((class_2561)line));
            }
        }
        if (!this.displayInfo.equals(DisplayInfo.NONE)) {
            result.add("display", (JsonElement)this.displayInfo.toJson());
        }
        if (!this.animation.type().equals((Object)Animation.Type.FIXED)) {
            result.add("animation", (JsonElement)this.animation.toJson());
        }
        this.displayItemToJson(result);
        this.entityInfoToJson(result);
        if (!this.colorInfo.equals(ColorInfo.NONE)) {
            result.add("colors", (JsonElement)this.colorInfo.toJson());
        }
        if (!this.effectInfo.equals(EffectInfo.NONE)) {
            result.add("effects", (JsonElement)this.effectInfo.toJson());
        }
        if (this.isHidden) {
            result.addProperty("isHidden", Boolean.valueOf(true));
        }
        return result;
    }
}

