/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import trofers.Trofers;
import trofers.network.NetworkHandler;
import trofers.network.TrophySyncPacket;
import trofers.platform.PlatformServices;
import trofers.trophy.Trophy;

public class TrophyManager
extends class_4309 {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Map<class_2960, Trophy> trophies = Map.of();

    public TrophyManager() {
        super(GSON, "trofers");
    }

    public static Trophy get(class_2960 id) {
        return trophies.getOrDefault(id, null);
    }

    public static Collection<Trophy> values() {
        return trophies.values();
    }

    public static void setTrophies(Map<class_2960, Trophy> trophies) {
        TrophyManager.trophies = trophies;
        Trofers.LOGGER.info("Loaded {} trophies", (Object)trophies.size());
    }

    protected void apply(Map<class_2960, JsonElement> resources, class_3300 resourceManager, class_3695 profilerFiller) {
        HashMap<class_2960, Trophy> trophies = new HashMap<class_2960, Trophy>();
        int amountSkipped = 0;
        for (Map.Entry<class_2960, JsonElement> entry : resources.entrySet()) {
            class_2960 id = entry.getKey();
            JsonElement element = entry.getValue();
            try {
                if (element.isJsonObject() && element.getAsJsonObject().has("conditions") && !PlatformServices.platformHelper.matchesConditions(element.getAsJsonObject())) {
                    ++amountSkipped;
                    continue;
                }
                trophies.put(id, Trophy.fromJson(element, id));
            }
            catch (Exception exception) {
                Trofers.LOGGER.error("Couldn't parse trophy {}", (Object)id, (Object)exception);
            }
        }
        if (amountSkipped > 0) {
            Trofers.LOGGER.info("Skipping loading {} trophies as their conditions were not met", (Object)amountSkipped);
        }
        TrophyManager.setTrophies(trophies);
    }

    public static void sync(class_3222 player) {
        NetworkHandler.CHANNEL.sendToPlayer(player, (Object)new TrophySyncPacket(trophies));
    }
}

