/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import trofers.trophy.TrophyManager;
import trofers.trophy.components.Animation;
import trofers.trophy.components.ColorInfo;
import trofers.trophy.components.DisplayInfo;
import trofers.trophy.components.EffectInfo;
import trofers.trophy.components.EntityInfo;
import trofers.util.JsonHelper;

public record Trophy(class_2960 id, Optional<class_2561> name, List<class_2561> tooltip, DisplayInfo display, Animation animation, class_1799 item, Optional<EntityInfo> entity, ColorInfo colors, EffectInfo effects, boolean isHidden) {
    @Nullable
    public static Trophy getTrophy(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return null;
        }
        class_2487 blockEntityTag = tag.method_10562("BlockEntityTag");
        if (!blockEntityTag.method_10573("Trophy", 8)) {
            return null;
        }
        try {
            return TrophyManager.get(new class_2960(blockEntityTag.method_10558("Trophy")));
        }
        catch (class_151 class_1512) {
            return null;
        }
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_10812(this.id);
        buffer.writeBoolean(this.name.isPresent());
        this.name.ifPresent(arg_0 -> ((class_2540)buffer).method_10805(arg_0));
        this.display.toNetwork(buffer);
        this.animation.toNetwork(buffer);
        buffer.method_10793(this.item);
        buffer.writeBoolean(this.entity.isPresent());
        this.entity.ifPresent(entityInfo -> entityInfo.toNetwork(buffer));
        this.colors.toNetwork(buffer);
        this.effects.toNetwork(buffer);
        for (class_2561 line : this.tooltip) {
            buffer.writeBoolean(true);
            buffer.method_10805(line);
        }
        buffer.writeBoolean(false);
        buffer.writeBoolean(this.isHidden);
    }

    public static Trophy fromNetwork(class_2540 buffer) {
        class_2960 id = buffer.method_10810();
        class_2561 name = null;
        if (buffer.readBoolean()) {
            name = buffer.method_10808();
        }
        DisplayInfo display = DisplayInfo.fromNetwork(buffer);
        Animation animation = Animation.fromNetwork(buffer);
        class_1799 item = buffer.method_10819();
        EntityInfo entity = null;
        if (buffer.readBoolean()) {
            entity = EntityInfo.fromNetwork(buffer);
        }
        ColorInfo colors = ColorInfo.fromNetwork(buffer);
        EffectInfo effects = EffectInfo.fromNetwork(buffer);
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        while (buffer.readBoolean()) {
            tooltip.add(buffer.method_10808());
        }
        boolean isHidden = buffer.readBoolean();
        return new Trophy(id, Optional.ofNullable(name), tooltip, display, animation, item, Optional.ofNullable(entity), colors, effects, isHidden);
    }

    public static Trophy fromJson(JsonElement element, class_2960 id) {
        JsonObject object = class_3518.method_15295((JsonElement)element, (String)"trophy");
        EntityInfo entity = null;
        if (object.has("entity")) {
            entity = EntityInfo.fromJson(class_3518.method_15296((JsonObject)object, (String)"entity"));
        }
        class_1799 item = class_1799.field_8037;
        if (object.has("item")) {
            item = JsonHelper.deserializeItem(object, "item");
        }
        Animation animation = Animation.STATIC;
        if (object.has("animation")) {
            animation = Animation.fromJson(class_3518.method_15296((JsonObject)object, (String)"animation"));
        }
        DisplayInfo display = DisplayInfo.NONE;
        if (object.has("display")) {
            display = DisplayInfo.fromJson(class_3518.method_15296((JsonObject)object, (String)"display"));
        }
        ColorInfo colors = ColorInfo.NONE;
        if (object.has("colors")) {
            colors = ColorInfo.fromJson(class_3518.method_15296((JsonObject)object, (String)"colors"));
        }
        class_5250 name = null;
        if (object.has("name")) {
            name = class_2561.class_2562.method_10872((JsonElement)object.get("name"));
        }
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        if (object.has("tooltip")) {
            JsonElement tooltipElement = object.get("tooltip");
            if (!tooltipElement.isJsonArray()) {
                tooltip.add((class_2561)class_2561.class_2562.method_10872((JsonElement)tooltipElement));
            } else {
                JsonArray lines = class_3518.method_15261((JsonObject)object, (String)"tooltip");
                for (JsonElement line : lines) {
                    tooltip.add((class_2561)class_2561.class_2562.method_10872((JsonElement)line));
                }
            }
        }
        EffectInfo effects = EffectInfo.NONE;
        if (object.has("effects")) {
            effects = EffectInfo.fromJson(class_3518.method_15296((JsonObject)object, (String)"effects"));
        }
        boolean isHidden = false;
        if (object.has("isHidden")) {
            isHidden = class_3518.method_15270((JsonObject)object, (String)"isHidden");
        }
        return new Trophy(id, Optional.ofNullable(name), tooltip, display, animation, item, Optional.ofNullable(entity), colors, effects, isHidden);
    }
}

