/*
 * Decompiled with CFR 0.152.
 */
package trofers.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_7923;
import trofers.Trofers;
import trofers.loot.AbstractLootModifier;
import trofers.trophy.TrophyManager;

public class AddEntityTrophy
extends AbstractLootModifier {
    public static final Supplier<Codec<AddEntityTrophy>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> AddEntityTrophy.codecStart(instance).and((App)class_7923.field_41178.method_39673().fieldOf("trophyBase").forGetter(m -> m.trophyBase)).and((App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)class_2960.field_25139).fieldOf("trophies").forGetter(m -> m.trophies)).apply((Applicative)instance, AddEntityTrophy::create)));
    private final class_1792 trophyBase;
    private final Map<class_2960, class_2960> trophies;
    private final Set<class_1299<?>> entities;

    private AddEntityTrophy(class_5341[] conditions, class_1792 trophyBase, Map<class_2960, class_2960> trophies, Set<class_1299<?>> entities) {
        super(conditions);
        this.trophyBase = trophyBase;
        this.trophies = trophies;
        this.entities = entities;
    }

    public static AddEntityTrophy create(class_5341[] conditions, class_1935 trophyBase, Map<class_2960, class_2960> trophies, boolean logMissingEntities) {
        HashSet entities = new HashSet();
        for (class_2960 entityTypeId : trophies.keySet()) {
            if (class_7923.field_41177.method_10250(entityTypeId)) {
                entities.add((class_1299)class_7923.field_41177.method_10223(entityTypeId));
                continue;
            }
            if (!logMissingEntities) continue;
            Trofers.LOGGER.debug("Skipping trophy loot modifier entry for missing entity type " + entityTypeId);
        }
        return new AddEntityTrophy(conditions, trophyBase.method_8389(), trophies, entities);
    }

    public static AddEntityTrophy create(class_5341[] conditions, class_1935 trophyBase, Map<class_2960, class_2960> trophies) {
        return AddEntityTrophy.create(conditions, trophyBase, trophies, true);
    }

    @Override
    public Codec<? extends AbstractLootModifier> codec() {
        return CODEC.get();
    }

    @Override
    public ObjectArrayList<class_1799> doApply(ObjectArrayList<class_1799> generatedLoot, class_47 context) {
        class_2960 trophyId;
        class_1299 entityTypeId;
        if (context.method_300(class_181.field_1226) && this.entities.contains(entityTypeId = ((class_1297)context.method_35508(class_181.field_1226)).method_5864()) && (trophyId = this.trophies.get(class_7923.field_41177.method_10221((Object)entityTypeId))) != null) {
            if (TrophyManager.get(trophyId) == null) {
                Trofers.LOGGER.error("Failed to find trophy with invalid id '{}'", (Object)trophyId);
            } else {
                class_1799 stack = new class_1799((class_1935)this.trophyBase);
                stack.method_7911("BlockEntityTag").method_10582("Trophy", trophyId.toString());
                generatedLoot.add((Object)stack);
            }
        }
        return generatedLoot;
    }
}

