/*
 * Decompiled with CFR 0.152.
 */
package trofers.block.entity;

import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import trofers.block.entity.TrophyBlockEntity;
import trofers.trophy.Trophy;
import trofers.trophy.components.Animation;
import trofers.trophy.components.EntityInfo;

public class TrophyBlockEntityRenderer
implements class_827<TrophyBlockEntity> {
    public TrophyBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public boolean shouldRenderOffScreen(TrophyBlockEntity blockEntity) {
        return true;
    }

    public void render(TrophyBlockEntity blockEntity, float partialTicks, class_4587 poseStack, class_4597 multiBufferSource, int light, int overlay) {
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.0, 0.5);
        class_2350 direction = ((class_2350)blockEntity.method_11010().method_11654((class_2769)class_2741.field_12481)).method_10153();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-direction.method_10144()));
        Trophy trophy = blockEntity.getTrophy();
        if (trophy != null && class_310.method_1551().field_1724 != null) {
            float ticks = (float)class_310.method_1551().field_1724.field_6012 + partialTicks + blockEntity.getAnimationOffset();
            TrophyBlockEntityRenderer.render(trophy, ticks, blockEntity.getTrophyHeight(), poseStack, multiBufferSource, light, overlay);
        }
        poseStack.method_22909();
    }

    public static void render(Trophy trophy, float ticks, int trophyHeight, class_4587 poseStack, class_4597 multiBufferSource, int light, int overlay) {
        TrophyBlockEntityRenderer.renderItem(trophy, ticks, trophyHeight, poseStack, multiBufferSource, light, overlay);
        TrophyBlockEntityRenderer.renderEntity(trophy, ticks, trophyHeight, poseStack, multiBufferSource, light);
    }

    private static void renderItem(Trophy trophy, float ticks, int trophyHeight, class_4587 poseStack, class_4597 multiBufferSource, int light, int overlay) {
        poseStack.method_22903();
        class_918 renderer = class_310.method_1551().method_1480();
        class_1087 model = renderer.method_4019(trophy.item(), (class_1937)class_310.method_1551().field_1687, null, 0);
        float yOffset = 0.25f;
        TrophyBlockEntityRenderer.translateRotate(poseStack, trophy, trophyHeight, yOffset, ticks);
        poseStack.method_22904(0.0, 0.25, 0.0);
        if (!model.method_4712()) {
            poseStack.method_22905(0.5f, 0.5f, 0.5f);
        }
        class_310.method_1551().method_1480().method_23178(trophy.item(), class_811.field_4319, light, overlay, poseStack, multiBufferSource, (class_1937)class_310.method_1551().field_1687, 0);
        poseStack.method_22909();
    }

    private static void renderEntity(Trophy trophy, float ticks, int trophyHeight, class_4587 poseStack, class_4597 multiBufferSource, int light) {
        if (class_310.method_1551().field_1687 == null || trophy.entity().isEmpty()) {
            return;
        }
        EntityInfo entityInfo = trophy.entity().get();
        class_1297 entity = entityInfo.getOrCreateEntity((class_1937)class_310.method_1551().field_1687);
        if (entity == null) {
            return;
        }
        poseStack.method_22903();
        float entityHeight = entity.method_17682();
        TrophyBlockEntityRenderer.translateRotate(poseStack, trophy, trophyHeight, entityHeight / 2.0f, ticks);
        if (!entityInfo.isAnimated()) {
            ticks = 0.0f;
        }
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        class_310.method_1551().method_1561().method_3954(entity, 0.0, 0.0, 0.0, 0.0f, ticks, poseStack, multiBufferSource, light);
        poseStack.method_22909();
    }

    private static void translateRotate(class_4587 poseStack, Trophy trophy, int trophyHeight, float yRotationOffset, float ticks) {
        float animationProgress = 6.0f * ticks * trophy.animation().speed();
        poseStack.method_22904(0.0, (double)((float)trophyHeight + trophy.display().yOffset()) / 16.0, 0.0);
        poseStack.method_46416(0.0f, yRotationOffset *= trophy.display().scale(), 0.0f);
        if (trophy.animation().type() == Animation.Type.SPINNING) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(animationProgress));
        } else if (trophy.animation().type() == Animation.Type.TUMBLING) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(animationProgress));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(animationProgress * 0.8f));
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(animationProgress * 0.6f));
        }
        poseStack.method_46416(0.0f, -yRotationOffset, 0.0f);
        poseStack.method_22904((double)trophy.display().xOffset() / 16.0, 0.0, 0.0);
        poseStack.method_22904(0.0, 0.0, (double)trophy.display().zOffset() / 16.0);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(trophy.display().xRotation()));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(trophy.display().yRotation()));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(trophy.display().zRotation()));
        float scale = trophy.display().scale();
        poseStack.method_22905(scale, scale, scale);
    }
}

