/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_fabric.processing;

import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.treeharvester_common_fabric.data.Variables;
import com.natamus.treeharvester_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public class LeafProcessing {
    public static void breakTreeLeaves(class_1937 level, List<class_2338> logsToBreak, class_2338 lowestCenterLogPos, class_2338 highestLogPos) {
        class_2338 highestLeafPos;
        class_2248 highestLeafBlock;
        if (level.field_9236) {
            return;
        }
        int highestX = Integer.MIN_VALUE;
        int highestZ = Integer.MIN_VALUE;
        int lowestX = Integer.MAX_VALUE;
        int lowestZ = Integer.MAX_VALUE;
        for (class_2338 brokenLogPos : logsToBreak) {
            int x = brokenLogPos.method_10263();
            int z = brokenLogPos.method_10260();
            if (x > highestX) {
                highestX = x;
            }
            if (x < lowestX) {
                lowestX = x;
            }
            if (z > highestZ) {
                highestZ = z;
            }
            if (z >= lowestZ) continue;
            lowestZ = z;
        }
        if (!Variables.processBreakLeaves.containsKey(level)) {
            Variables.processBreakLeaves.put(level, new CopyOnWriteArrayList());
        }
        if (!Util.isTreeLeaf(highestLeafBlock = level.method_8320(highestLeafPos = highestLogPos.method_10084().method_10062()).method_26204())) {
            for (class_2338 aroundPos : BlockPosFunctions.getBlocksAround((class_2338)highestLeafPos, (boolean)false)) {
                class_2248 aroundBlock = level.method_8320(aroundPos).method_26204();
                if (!Util.isTreeLeaf(aroundBlock)) continue;
                highestLeafBlock = aroundBlock;
                break;
            }
        }
        boolean highestLeafIsMushroom = Util.isGiantMushroomLeafBlock(highestLeafBlock);
        int distance = 3;
        if (Util.isNetherTreeLeaf(highestLeafBlock)) {
            distance = 5;
        }
        ArrayList<class_2338> treeBlocks = new ArrayList<class_2338>();
        for (class_2338 iPos : class_2338.method_10094((int)(lowestX - distance), (int)(lowestCenterLogPos.method_10264() - 1), (int)(lowestZ - distance), (int)(highestX + distance), (int)(highestLogPos.method_10264() + 5), (int)(highestZ + distance))) {
            treeBlocks.add(iPos.method_10062());
        }
        Collections.shuffle(treeBlocks);
        for (class_2338 treeBlockPos : treeBlocks) {
            class_2248 treeBlock;
            if (!level.method_8477(treeBlockPos) || !Util.isTreeLeaf(treeBlock = level.method_8320(treeBlockPos).method_26204()) || !highestLeafBlock.equals(treeBlock) && !Util.isNetherTreeLeaf(highestLeafBlock) || !Util.isGiantMushroomLeafBlock(treeBlock) && !highestLeafIsMushroom && LeafProcessing.hasLogsWithinDistance(level, treeBlockPos, 2) || Variables.processBreakLeaves.get(level).contains(treeBlockPos)) continue;
            Variables.processBreakLeaves.get(level).add(treeBlockPos);
        }
    }

    private static boolean hasLogsWithinDistance(class_1937 level, class_2338 checkPos, int distance) {
        for (class_2338 treePos : class_2338.method_10094((int)(checkPos.method_10263() - distance), (int)(checkPos.method_10264() - distance), (int)(checkPos.method_10260() - distance), (int)(checkPos.method_10263() + distance), (int)(checkPos.method_10264() + distance), (int)(checkPos.method_10260() + distance))) {
            if (!Util.isTreeLog(level.method_8320(treePos).method_26204())) continue;
            return true;
        }
        return false;
    }
}

