/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import java.util.LinkedList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class TitleRenderer<T> {
    public final LinkedList<T> recentEntries = new LinkedList();
    public class_2561 displayedTitle = null;
    public class_2561 displayedSubTitle = null;
    public int titleTimer = 0;
    public int cooldownTimer = 0;
    public int maxRecentListSize;
    public boolean enabled;
    public int titleFadeInTicks;
    public int titleDisplayTime;
    public int titleFadeOutTicks;
    public int titleTextcolor;
    public String titleDefaultTextColor;
    public boolean showTextShadow;
    public float titleTextSize;
    public int titleXOffset;
    public int titleYOffset;
    public boolean isTextCentered;

    public TitleRenderer(int maxRecentListSize, boolean enabled, int fadeInTicks, int displayTicks, int fadeOutTicks, String textColor, boolean showTextShadow, double textSize, int xOffset, int yOffset, boolean centerText) {
        this.maxRecentListSize = maxRecentListSize;
        this.enabled = enabled;
        this.titleFadeInTicks = fadeInTicks;
        this.titleDisplayTime = displayTicks;
        this.titleFadeOutTicks = fadeOutTicks;
        this.setColor(textColor);
        this.titleDefaultTextColor = textColor;
        this.showTextShadow = showTextShadow;
        this.titleTextSize = (float)textSize;
        this.titleXOffset = xOffset;
        this.titleYOffset = yOffset;
        this.isTextCentered = centerText;
    }

    public void renderText(float partialTicks, class_332 guiGraphics) {
        if (this.displayedTitle != null && this.titleTimer > 0) {
            float age = (float)this.titleTimer - partialTicks;
            int opacity = 255;
            if (this.titleTimer > this.titleFadeOutTicks + this.titleDisplayTime) {
                float r = (float)(this.titleFadeInTicks + this.titleDisplayTime + this.titleFadeOutTicks) - age;
                opacity = (int)(r * 255.0f / (float)this.titleFadeInTicks);
            }
            if (this.titleTimer <= this.titleFadeOutTicks) {
                opacity = (int)(age * 255.0f / (float)this.titleFadeOutTicks);
            }
            if ((opacity = class_3532.method_15340((int)opacity, (int)0, (int)255)) > 8) {
                guiGraphics.method_51448().method_22903();
                if (this.isTextCentered) {
                    guiGraphics.method_51448().method_22904((double)class_310.method_1551().method_22683().method_4486() / 2.0, (double)class_310.method_1551().method_22683().method_4502() / 2.0, 0.0);
                }
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_22905(this.titleTextSize, this.titleTextSize, this.titleTextSize);
                int alpha = opacity << 24 & 0xFF000000;
                class_327 fontRenderer = class_310.method_1551().field_1772;
                int titleWidth = fontRenderer.method_27525((class_5348)this.displayedTitle);
                this.drawBackdrop(guiGraphics, -10, titleWidth, this.titleTextcolor | alpha);
                int xOffset = this.isTextCentered ? this.titleXOffset + -titleWidth / 2 : this.titleXOffset;
                guiGraphics.method_51439(fontRenderer, this.displayedTitle, xOffset, this.titleYOffset, this.titleTextcolor | alpha, this.showTextShadow);
                guiGraphics.method_51448().method_22909();
                if (this.displayedSubTitle != null) {
                    guiGraphics.method_51448().method_22903();
                    guiGraphics.method_51448().method_22905(1.3f, 1.3f, 1.3f);
                    int subtitleWidth = fontRenderer.method_27525((class_5348)this.displayedSubTitle);
                    this.drawBackdrop(guiGraphics, 5, subtitleWidth, 0xFFFFFF | alpha);
                    guiGraphics.method_51439(fontRenderer, this.displayedSubTitle, -subtitleWidth / 2, -35, 0xFFFFFF | alpha, this.showTextShadow);
                    guiGraphics.method_51448().method_22909();
                }
                RenderSystem.disableBlend();
                guiGraphics.method_51448().method_22909();
            }
        }
    }

    public void tick() {
        if (this.titleTimer > 0) {
            --this.titleTimer;
            if (this.titleTimer <= 0) {
                this.clearTimer();
            }
        }
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
        }
    }

    public void displayTitle(class_2561 titleText, @Nullable class_2561 subtitleText) {
        this.displayedTitle = titleText;
        this.titleTimer = this.titleFadeInTicks + this.titleDisplayTime + this.titleFadeOutTicks;
        if (subtitleText != null) {
            this.displayedSubTitle = subtitleText;
        }
    }

    public void clearTimer() {
        this.titleTimer = 0;
    }

    public void setColor(String textColor) {
        try {
            this.titleTextcolor = (int)Long.parseLong(textColor, 16);
        }
        catch (Exception e) {
            TravelersTitlesCommon.LOGGER.error("Text color {} is not a valid RGB color. Defaulting to white...", (Object)textColor);
            TravelersTitlesCommon.LOGGER.error(e.toString());
            this.titleTextcolor = 0xFFFFFF;
        }
    }

    public void addRecentEntry(T entry) {
        if (this.recentEntries.size() >= this.maxRecentListSize && this.recentEntries.size() > 0) {
            this.recentEntries.removeFirst();
        }
        if (this.maxRecentListSize > 0) {
            this.recentEntries.addLast(entry);
        }
    }

    public boolean matchesAnyRecentEntry(Predicate<T> entryMatchPredicate) {
        return this.recentEntries.stream().anyMatch(entryMatchPredicate);
    }

    protected void drawBackdrop(class_332 guiGraphics, int yOffset, int width, int color) {
        int textBackgroundColor = class_310.method_1551().field_1690.method_19345(0.0f);
        if (textBackgroundColor != 0) {
            int xOffset = -width / 2;
            guiGraphics.method_25294(xOffset - 2, yOffset - 2, xOffset + width + 2, yOffset + 9 + 2, class_5253.class_5254.method_27763((int)textBackgroundColor, (int)color));
        }
    }
}

