/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.TrashSlotConfig;
import net.blay09.mods.trashslot.TrashSlotSaveState;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.client.ContainerSettings;
import net.blay09.mods.trashslot.client.LayoutManager;
import net.blay09.mods.trashslot.client.ModKeyBindings;
import net.blay09.mods.trashslot.client.SlotTrash;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.blay09.mods.trashslot.client.gui.GuiHelper;
import net.blay09.mods.trashslot.client.gui.GuiTrashSlot;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TrashSlotGuiHandler {
    private final SlotTrash slotTrash = new SlotTrash();
    private GuiTrashSlot guiTrashSlot;
    private ContainerSettings currentContainerSettings = ContainerSettings.NONE;
    private boolean ignoreMouseUp;
    private boolean sentMissingMessage;
    private long missingMessageTime;
    private boolean isLeftMouseDown;

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof CreativeScreen) {
            this.currentContainerSettings = ContainerSettings.NONE;
            this.guiTrashSlot = null;
            return;
        }
        if (event.getGui() instanceof ContainerScreen) {
            ContainerScreen gui = (ContainerScreen)event.getGui();
            if (!TrashSlot.isServerSideInstalled && !this.sentMissingMessage) {
                this.missingMessageTime = System.currentTimeMillis();
                this.sentMissingMessage = true;
                return;
            }
            if (gui instanceof InventoryScreen && Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
                return;
            }
            IGuiContainerLayout layout = LayoutManager.getLayout(gui);
            this.currentContainerSettings = TrashSlotSaveState.getSettings(gui, layout);
            this.guiTrashSlot = this.currentContainerSettings != ContainerSettings.NONE ? new GuiTrashSlot(this, gui, layout, this.currentContainerSettings, this.slotTrash) : null;
        } else {
            this.currentContainerSettings = ContainerSettings.NONE;
            this.guiTrashSlot = null;
        }
    }

    @SubscribeEvent
    public void onGuiMouseReleased(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        if (event.getButton() == 0) {
            this.isLeftMouseDown = false;
        }
        if (this.ignoreMouseUp) {
            event.setCanceled(true);
            this.ignoreMouseUp = false;
        }
    }

    @SubscribeEvent
    public void onGuiMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre event) {
        DeletionProvider deletionProvider;
        if (event.getButton() == 0) {
            this.isLeftMouseDown = true;
        }
        if ((deletionProvider = TrashSlotConfig.getDeletionProvider()) == null || !this.currentContainerSettings.isEnabled()) {
            return;
        }
        int mouseButton = event.getButton();
        InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(mouseButton);
        if (this.runKeyBindings(event.getGui(), input)) {
            event.setCanceled(true);
            return;
        }
        if (event.getGui() instanceof ContainerScreen) {
            double mouseY;
            double mouseX;
            ContainerScreen gui = (ContainerScreen)event.getGui();
            if (gui.func_195362_a((Slot)this.slotTrash, mouseX = event.getMouseX(), mouseY = event.getMouseY())) {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player != null) {
                    boolean isRightClick;
                    ItemStack mouseItem = player.field_71071_by.func_70445_o();
                    boolean bl = isRightClick = mouseButton == 1;
                    if (mouseItem.func_190926_b()) {
                        deletionProvider.undeleteLast((PlayerEntity)player, this.slotTrash, isRightClick);
                    } else {
                        deletionProvider.deleteMouseItem((PlayerEntity)player, mouseItem, this.slotTrash, isRightClick);
                    }
                    event.setCanceled(true);
                    this.ignoreMouseUp = true;
                }
            } else if (this.guiTrashSlot.isInside((int)mouseX, (int)mouseY)) {
                event.setCanceled(true);
                this.ignoreMouseUp = true;
            }
        }
    }

    @SubscribeEvent
    public void onGuiKeyboard(GuiScreenEvent.KeyboardKeyPressedEvent.Post event) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return;
        }
        int keyCode = event.getKeyCode();
        int scanCode = event.getScanCode();
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (this.runKeyBindings(event.getGui(), input)) {
            event.setCanceled(true);
        }
    }

    private boolean runKeyBindings(Screen screen, InputMappings.Input input) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return false;
        }
        if (this.currentContainerSettings.isEnabled()) {
            ClientPlayerEntity entityPlayer;
            boolean isDelete = ModKeyBindings.keyBindDelete.isActiveAndMatches(input);
            boolean isDeleteAll = ModKeyBindings.keyBindDeleteAll.isActiveAndMatches(input);
            if ((isDelete || isDeleteAll) && (entityPlayer = Minecraft.func_71410_x().field_71439_g) != null && screen instanceof ContainerScreen) {
                ContainerScreen gui = (ContainerScreen)screen;
                Slot mouseSlot = gui.getSlotUnderMouse();
                if (mouseSlot != null && mouseSlot.func_75216_d()) {
                    deletionProvider.deleteContainerItem(gui.func_212873_a_(), mouseSlot.field_75222_d, isDeleteAll, this.slotTrash);
                } else {
                    double mouseY;
                    MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
                    double rawMouseX = Minecraft.func_71410_x().field_71417_B.func_198024_e();
                    double rawMouseY = Minecraft.func_71410_x().field_71417_B.func_198026_f();
                    double mouseX = rawMouseX * (double)mainWindow.func_198107_o() / (double)mainWindow.func_198105_m();
                    if (gui.func_195362_a((Slot)this.slotTrash, mouseX, mouseY = rawMouseY * (double)mainWindow.func_198087_p() / (double)mainWindow.func_198083_n())) {
                        deletionProvider.emptyTrashSlot(this.slotTrash);
                    }
                }
                return true;
            }
        }
        if (screen instanceof ContainerScreen && this.currentContainerSettings != ContainerSettings.NONE && ModKeyBindings.keyBindToggleSlot.isActiveAndMatches(input)) {
            this.currentContainerSettings.setEnabled(!this.currentContainerSettings.isEnabled());
            TrashSlotSaveState.save();
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(GuiContainerEvent.DrawBackground event) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null || !this.currentContainerSettings.isEnabled()) {
            return;
        }
        ContainerScreen gui = event.getGuiContainer();
        if (this.guiTrashSlot != null) {
            this.guiTrashSlot.update(event.getMouseX(), event.getMouseY());
            this.guiTrashSlot.drawBackground(event.getMatrixStack());
            if (gui.func_195362_a((Slot)this.slotTrash, (double)event.getMouseX(), (double)event.getMouseY())) {
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                int j1 = gui.getGuiLeft() + this.slotTrash.field_75223_e;
                int k1 = gui.getGuiTop() + this.slotTrash.field_75221_f;
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                GuiHelper.drawGradientRect(event.getMatrixStack(), j1, k1, j1 + 16, k1 + 16, -600, -2130706433, -2130706433);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                RenderSystem.enableDepthTest();
            }
            if (this.missingMessageTime != 0L && System.currentTimeMillis() - this.missingMessageTime < 3000L) {
                TranslationTextComponent noHabloEspanol = new TranslationTextComponent("trashslot.serverNotInstalled");
                noHabloEspanol.func_240699_a_(TextFormatting.RED);
                gui.func_243308_b(event.getMatrixStack(), (List)Lists.newArrayList((Object[])new ITextComponent[]{noHabloEspanol}), gui.getGuiLeft() + gui.getXSize() / 2 - gui.getMinecraft().field_71466_p.func_238414_a_((ITextProperties)noHabloEspanol) / 2, 25);
            }
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)gui.getGuiLeft(), (float)gui.getGuiTop(), (float)0.0f);
            RenderHelper.func_227780_a_();
            gui.func_238746_a_(event.getMatrixStack(), (Slot)this.slotTrash);
            RenderHelper.func_74518_a();
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof ContainerScreen) {
            ContainerScreen gui = (ContainerScreen)event.getGui();
            DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
            if (deletionProvider == null || !this.currentContainerSettings.isEnabled()) {
                return;
            }
            boolean isMouseSlot = gui.func_195362_a((Slot)this.slotTrash, (double)event.getMouseX(), (double)event.getMouseY());
            PlayerInventory inventoryPlayer = Minecraft.func_71410_x().field_71439_g.field_71071_by;
            if (isMouseSlot && inventoryPlayer.func_70445_o().func_190926_b() && this.slotTrash.func_75216_d()) {
                GuiHelper.renderTooltip(event.getMatrixStack(), (Screen)gui, this.slotTrash.func_75211_c(), event.getMouseX(), event.getMouseY());
            }
        }
    }

    public GuiTrashSlot getGuiTrashSlot() {
        return this.guiTrashSlot;
    }

    public SlotTrash getTrashSlot() {
        return this.slotTrash;
    }

    public boolean isLeftMouseDown() {
        return this.isLeftMouseDown;
    }
}

