/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.client;

import io.github.drmanganese.topaddons.addons.forge.ForgeAddon;
import io.github.drmanganese.topaddons.client.FluidColorExtraction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;

public class FluidColors {
    private static final Map<TextureAtlasSprite, Integer> AVERAGE_COLORS = FluidColors.hashMapWithDefault(FluidColorExtraction::extractAvgColorFromTexture);
    private static final Map<TextureAtlasSprite, Integer> TOP_LEFT_COLORS = FluidColors.hashMapWithDefault(FluidColorExtraction::extractTopLeftColorFromTexture);
    private static final Map<String, Integer> OVERRIDE_COLORS = new HashMap<String, Integer>();

    public static void resetMaps() {
        AVERAGE_COLORS.clear();
        TOP_LEFT_COLORS.clear();
    }

    public static int getForFluid(Fluid fluid, ForgeAddon.FluidColorAlgorithm algorithm) {
        TextureAtlasSprite texture = FluidColorExtraction.getStillFluidTextureSafe(fluid);
        if (texture == null) {
            return -16776995;
        }
        switch (algorithm) {
            case AVERAGE_COLOR: {
                return AVERAGE_COLORS.get(texture);
            }
            case TOP_LEFT_COLOR: {
                return TOP_LEFT_COLORS.get(texture);
            }
        }
        throw new IllegalArgumentException("Illegal Fluid Color Algorithm");
    }

    public static Optional<Integer> getForgeColor(Fluid fluid) {
        return Optional.of(fluid.getAttributes().getColor()).filter(i -> i != -1);
    }

    public static Optional<Integer> getOverrideColor(Fluid fluid) {
        return Optional.ofNullable(OVERRIDE_COLORS.get(fluid.getRegistryName().toString()));
    }

    private static Map<TextureAtlasSprite, Integer> hashMapWithDefault(final Function<TextureAtlasSprite, Integer> defaultFunction) {
        return new HashMap<TextureAtlasSprite, Integer>(){

            @Override
            public Integer get(Object key) {
                if (!this.containsKey(key)) {
                    this.put((TextureAtlasSprite)key, defaultFunction.apply((TextureAtlasSprite)key));
                }
                return (Integer)super.get(key);
            }
        };
    }
}

