/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class ClientCfgCapability {
    private final Map<String, String> valueMap = new HashMap<String, String>();

    public Map<String, String> getAll() {
        return this.valueMap;
    }

    public void copy(ClientCfgCapability capability) {
        this.fromMap(capability.getAll());
    }

    public void fromMap(Map<String, String> map) {
        this.valueMap.clear();
        this.valueMap.putAll(map);
    }

    public Optional<String> getString(@Nonnull String key) {
        return Optional.of(key).filter(this.valueMap::containsKey).map(this.valueMap::get);
    }

    public Optional<Integer> getInt(@Nonnull String key) {
        return this.getString(key).map(Integer::parseInt);
    }

    public Optional<Boolean> getBool(@Nonnull String key) {
        return this.getString(key).map(ClientCfgCapability::stringToBoolean);
    }

    public <E extends Enum<E>> Optional<E> getEnum(@Nonnull String key, Class<E> enumClass) {
        return this.getString(key).map(v -> Enum.valueOf(enumClass, v));
    }

    private static Boolean stringToBoolean(String s) {
        return s.equals("true");
    }
}

