/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons;

import io.github.drmanganese.topaddons.TopAddons;
import io.github.drmanganese.topaddons.addons.TopAddon;
import io.github.drmanganese.topaddons.api.IAddonConfig;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.ArrayUtils;

public final class AddonRegistry {
    private static final List<TopAddon> ADDONS = new LinkedList<TopAddon>();

    public static void registerAddon(Supplier<TopAddon> addonFactory, String[] dependencies, String[] rejectors) {
        if (AddonRegistry.verifyDependencies(dependencies, rejectors)) {
            TopAddon addon = addonFactory.get();
            ADDONS.add(addon);
            TopAddons.LOGGER.info("Registered addon {}", (Object)addon.getFancyName());
        }
    }

    public static void registerAddon(Supplier<TopAddon> addonFactory) {
        AddonRegistry.registerAddon(addonFactory, new String[0], new String[0]);
    }

    public static void registerAddon(Supplier<TopAddon> addonCreator, String dependency) {
        AddonRegistry.registerAddon(addonCreator, (String[])ArrayUtils.toArray((Object[])new String[]{dependency}), new String[0]);
    }

    public static Stream<TopAddon> getAddonStream() {
        return ADDONS.stream();
    }

    public static Stream<IAddonConfig> getAddonConfigStream() {
        return AddonRegistry.getAddonStream().filter(IAddonConfig.class::isInstance).map(IAddonConfig.class::cast);
    }

    private static boolean verifyDependencies(String[] dependencies, String[] rejectors) {
        ModList modList = ModList.get();
        boolean allDepsFound = Arrays.stream(dependencies).allMatch(arg_0 -> ((ModList)modList).isLoaded(arg_0));
        boolean noRejectorsFound = Arrays.stream(rejectors).noneMatch(arg_0 -> ((ModList)modList).isLoaded(arg_0));
        return allDepsFound && noRejectorsFound;
    }
}

