/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.worldgen;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.OreBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tmechworks.common.MechworksContent;
import slimeknights.tmechworks.common.config.MechworksConfig;

public class MechworksWorld {
    private static MechworksWorld INSTANCE;
    private static final Logger log;
    private static final List<OreProperties> OVERWORLD_ORES;

    public MechworksWorld() {
        INSTANCE = this;
    }

    public static MechworksWorld getInstance() {
        return INSTANCE;
    }

    public void setupWorldGeneration() {
        Registry registry = WorldGenRegistries.field_243653_e;
        for (OreProperties ore : OVERWORLD_ORES) {
            ore.preconfigureFeature();
            Registry.func_218322_a((Registry)registry, (ResourceLocation)Objects.requireNonNull(((BlockState)ore.state.get()).func_177230_c().getRegistryName()), (Object)ore.preconfiguredFeature);
        }
    }

    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent ev) {
        if (!((Boolean)MechworksConfig.COMMON_CONFIG.worldGen.enabled.get()).booleanValue()) {
            return;
        }
        OVERWORLD_ORES.forEach(ore -> ((OreProperties)ore).addToBiome(ev.getName().toString(), ev.getGeneration()));
    }

    static {
        log = LogManager.getLogger((String)"tmechworks.world");
        OVERWORLD_ORES = ImmutableList.of((Object)new OreProperties(() -> ((OreBlock)MechworksContent.Blocks.copper_ore.get()).func_176223_P(), 8, ore -> (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ore.func_242733_d(64)).func_242728_a()).func_242731_b(20), MechworksConfig.COMMON_CONFIG.worldGen.copper), (Object)new OreProperties(() -> ((OreBlock)MechworksContent.Blocks.aluminum_ore.get()).func_176223_P(), 8, ore -> (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)ore.func_242733_d(64)).func_242728_a()).func_242731_b(20), MechworksConfig.COMMON_CONFIG.worldGen.aluminum));
    }

    private static class OreProperties {
        private final Supplier<BlockState> state;
        private final Function<ConfiguredFeature<?, ?>, ConfiguredFeature<?, ?>> processor;
        private final int frequency;
        private final MechworksConfig.Common.WorldGeneration.Ore config;
        private ConfiguredFeature<?, ?> preconfiguredFeature;

        OreProperties(Supplier<BlockState> state, int frequency, Function<ConfiguredFeature<?, ?>, ConfiguredFeature<?, ?>> processor, MechworksConfig.Common.WorldGeneration.Ore config) {
            this.state = state;
            this.frequency = frequency;
            this.processor = processor;
            this.config = config;
        }

        private void preconfigureFeature() {
            this.preconfiguredFeature = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, this.state.get(), this.frequency));
            this.preconfiguredFeature = this.processor.apply(this.preconfiguredFeature);
        }

        private void addToBiome(String biome, BiomeGenerationSettingsBuilder generation) {
            if (!((Boolean)this.config.enabled.get()).booleanValue()) {
                return;
            }
            if (this.preconfiguredFeature == null) {
                log.error("Preconfigured feature for " + this.state.get().func_177230_c().getRegistryName() + " is null, skipping...");
                return;
            }
            boolean isWhitelist = (Boolean)this.config.isWhitelist.get();
            List filter = (List)this.config.filter.get();
            boolean matches = filter.stream().anyMatch(biome::equals);
            if (isWhitelist && !matches || !isWhitelist && matches) {
                return;
            }
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, this.preconfiguredFeature);
        }
    }
}

