/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.network.packet;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import slimeknights.tmechworks.TMechworks;
import slimeknights.tmechworks.common.blocks.tileentity.IPlaceDirection;
import slimeknights.tmechworks.common.network.PacketHandler;

public class UpdatePlaceDirectionPacket {
    private BlockPos pos;
    private int direction;

    public UpdatePlaceDirectionPacket(BlockPos pos, int direction) {
        this.pos = pos;
        this.direction = direction;
    }

    public static void encode(UpdatePlaceDirectionPacket msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.writeInt(msg.direction);
    }

    public static UpdatePlaceDirectionPacket decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        int direction = buf.readInt();
        return new UpdatePlaceDirectionPacket(pos, direction);
    }

    public static class Handler {
        public static void handle(UpdatePlaceDirectionPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayerEntity player;
            NetworkEvent.Context context = ctx.get();
            if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
                player = context.getSender();
                PacketHandler.send(PacketDistributor.DIMENSION.with(() -> Handler.lambda$handle$0((PlayerEntity)player)), msg);
            } else {
                player = TMechworks.proxy.getPlayer();
            }
            context.enqueueWork(() -> Handler.lambda$handle$1((PlayerEntity)player, msg));
            context.setPacketHandled(true);
        }

        private static /* synthetic */ void lambda$handle$1(PlayerEntity player, UpdatePlaceDirectionPacket msg) {
            TileEntity te = player.func_130014_f_().func_175625_s(msg.pos);
            if (te instanceof IPlaceDirection) {
                ((IPlaceDirection)te).setPlaceDirection(msg.direction);
            }
        }

        private static /* synthetic */ RegistryKey lambda$handle$0(PlayerEntity player) {
            return player.field_70170_p.func_234923_W_();
        }
    }
}

