/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.tmechworks.common.blocks.IBlockItemConstruct;
import slimeknights.tmechworks.common.blocks.RedstoneMachineBlock;
import slimeknights.tmechworks.common.blocks.tileentity.FirestarterTileEntity;
import slimeknights.tmechworks.common.items.MechworksBlockItem;
import slimeknights.tmechworks.library.Util;

public class FirestarterBlock
extends RedstoneMachineBlock
implements IBlockItemConstruct {
    public static final BooleanProperty EXTINGUISH = BooleanProperty.func_177716_a((String)"extinguish");

    public FirestarterBlock() {
        super(Material.field_151573_f);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)EXTINGUISH, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{EXTINGUISH});
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        ItemStack extinguishStack = new ItemStack((IItemProvider)this, 1);
        ItemStack keepLitStack = new ItemStack((IItemProvider)this, 1);
        CompoundNBT extinguish = extinguishStack.func_196082_o();
        extinguish.func_74757_a("extinguish", true);
        CompoundNBT keepLit = keepLitStack.func_196082_o();
        keepLit.func_74757_a("extinguish", false);
        items.add((Object)extinguishStack);
        items.add((Object)keepLitStack);
    }

    @Override
    public void writeAdditionalItemData(BlockState state, World worldIn, BlockPos pos, ItemStack stack) {
        super.writeAdditionalItemData(state, worldIn, pos, stack);
        CompoundNBT tags = stack.func_196082_o();
        tags.func_74757_a("extinguish", ((Boolean)state.func_177229_b((Property)EXTINGUISH)).booleanValue());
    }

    @Override
    @Nonnull
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FirestarterTileEntity();
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean shouldExtinguish = true;
        ItemStack stack = context.func_195996_i();
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("extinguish", 1)) {
            shouldExtinguish = stack.func_77978_p().func_74767_n("extinguish");
        }
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)EXTINGUISH, (Comparable)Boolean.valueOf(shouldExtinguish));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_213453_ef()) {
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        state = (BlockState)state.func_235896_a_((Property)EXTINGUISH);
        worldIn.func_175656_a(pos, state);
        worldIn.func_184133_a(player, pos, SoundEvents.field_187556_aj, SoundCategory.BLOCKS, 0.3f, 0.55f);
        return ActionResultType.SUCCESS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        boolean shouldExtinguish = true;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("extinguish", 1)) {
            shouldExtinguish = stack.func_77978_p().func_74767_n("extinguish");
        }
        tooltip.add((ITextComponent)new TranslationTextComponent(Util.prefix("tooltip.behaviour"), new Object[]{I18n.func_135052_a((String)Util.prefix("tooltip.behaviour.firestarter." + (shouldExtinguish ? "extinguish" : "keep")), (Object[])new Object[0])}).func_240699_a_(TextFormatting.GRAY));
    }

    @Override
    public void setDefaultNBT(CompoundNBT nbt, CompoundNBT blockState) {
        if (!nbt.func_74764_b("extinguish")) {
            nbt.func_74757_a("extinguish", true);
        }
    }

    @Override
    public void onBlockItemConstruct(MechworksBlockItem item) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation("extinguish"), (stack, world, entity) -> {
            boolean shouldExtinguish = true;
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("extinguish", 1)) {
                shouldExtinguish = stack.func_77978_p().func_74767_n("extinguish");
            }
            return shouldExtinguish ? 1.0f : 0.0f;
        });
    }
}

