/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network.locator.instance;

import com.hrznstudio.titanium.itemstack.ItemStackHarnessRegistry;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.LocatorTypes;
import com.hrznstudio.titanium.network.locator.PlayerInventoryFinder;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;

public class InventoryStackLocatorInstance
extends LocatorInstance {
    private int inventorySlot;
    private String finder;

    public InventoryStackLocatorInstance() {
        this("empty", 0);
    }

    public InventoryStackLocatorInstance(String finder, int inventorySlot) {
        super(LocatorTypes.INVENTORY_LOCATOR);
        this.inventorySlot = inventorySlot;
        this.finder = finder;
    }

    @Override
    public Optional<?> locale(PlayerEntity playerEntity) {
        return PlayerInventoryFinder.get(this.finder).map(playerInventoryFinder -> playerInventoryFinder.getStackGetter().apply(playerEntity, this.inventorySlot)).map(ItemStackHarnessRegistry::createItemStackHarness).orElseGet(null);
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }
}

