/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.material;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.material.IResourceType;
import com.hrznstudio.titanium.material.ResourceMaterial;
import com.hrznstudio.titanium.material.ResourceTypeBlock;
import com.hrznstudio.titanium.material.ResourceTypeItem;
import com.hrznstudio.titanium.material.ResourceTypeProperties;
import com.hrznstudio.titanium.material.advancedtype.BlockAdvancedResourceType;
import com.hrznstudio.titanium.material.advancedtype.ItemAdvancedResourceType;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.registries.ForgeRegistryEntry;

public enum ResourceType implements IResourceType,
IStringSerializable
{
    INGOT("ingots"),
    DUST("dusts"),
    NUGGET("nuggets"),
    CHUNK("chunks"),
    CLUMP("clumps"),
    CRUSHED,
    PURIFIED,
    STONE("stones"),
    PEBBLES,
    FLAKES,
    GRINDINGS,
    GEM("gems"),
    SMALL_DUST("small_dusts"),
    PLATE("plates"),
    DENSE_PLATE("plates_dense"),
    CASING("casings"),
    REINFORCED_PLATE("plates_reinforced"),
    ROD("rods"),
    DENSE_ROD("rods_dense"),
    GEAR("gears"),
    METAL_BLOCK("storage_blocks"){

        @Override
        public IFactory<ForgeRegistryEntry> getInstanceFactory(ResourceMaterial material, @Nullable ResourceTypeProperties properties) {
            return () -> new ResourceTypeBlock(material, this, BlockAdvancedResourceType.METAL_BLOCK, properties);
        }
    }
    ,
    ORE{

        @Override
        public IFactory<ForgeRegistryEntry> getInstanceFactory(ResourceMaterial material, @Nullable ResourceTypeProperties properties) {
            return () -> new ResourceTypeBlock(material, this, BlockAdvancedResourceType.ORE, properties);
        }
    }
    ,
    NETHER_ORE("ores/nether"){

        @Override
        public IFactory<ForgeRegistryEntry> getInstanceFactory(ResourceMaterial material, @Nullable ResourceTypeProperties properties) {
            return () -> new ResourceTypeBlock(material, this, BlockAdvancedResourceType.NETHER_ORE, properties);
        }
    }
    ,
    GEM_BLOCK("storage_blocks"){

        @Override
        public IFactory<ForgeRegistryEntry> getInstanceFactory(ResourceMaterial material, @Nullable ResourceTypeProperties properties) {
            return () -> new ResourceTypeBlock(material, this, BlockAdvancedResourceType.GEM_BLOCK, properties);
        }
    };

    private final String tag;

    private ResourceType(String tag) {
        this.tag = tag;
    }

    private ResourceType() {
        this.tag = this.func_176610_l();
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public IFactory<ForgeRegistryEntry> getInstanceFactory(ResourceMaterial material, @Nullable ResourceTypeProperties properties) {
        return () -> new ResourceTypeItem(material, this, ItemAdvancedResourceType.SIMPLE, properties);
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }
}

