/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.gui;

import com.dannyandson.tinyredstone.blocks.ChopperBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ChopperItemHandler
implements IItemHandler {
    private ChopperBlockEntity innerHandler;

    public ChopperItemHandler(ChopperBlockEntity innerHandler) {
        this.innerHandler = innerHandler;
    }

    public int getSlots() {
        return 2;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.innerHandler.func_70301_a(slot) : this.innerHandler.getResultContainer().func_70301_a(0);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (slot > 0 || !this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack existing = this.getStackInSlot(slot);
        int limit = stack.func_77976_d();
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.innerHandler.func_70299_a(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.innerHandler.func_70296_d();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || slot != 1) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.func_190926_b() || amount < existing.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            this.innerHandler.getResultContainer().func_70299_a(0, ItemStack.field_190927_a);
            this.innerHandler.func_70301_a(0).func_190920_e(this.innerHandler.func_70301_a(0).func_190916_E() - 1);
            this.innerHandler.func_70296_d();
            return existing;
        }
        return existing.func_77946_l();
    }

    public int getSlotLimit(int slot) {
        return this.getStackInSlot(slot).func_77976_d();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }
}

