/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.TinyBlock;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class RedstoneLamp
extends TinyBlock
implements IPanelCell {
    private boolean lit = false;
    public static ResourceLocation TEXTURE_REDSTONE_LAMP = new ResourceLocation("minecraft", "block/redstone_lamp");
    public static ResourceLocation TEXTURE_REDSTONE_LAMP_ON = new ResourceLocation("minecraft", "block/redstone_lamp_on");

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, float alpha) {
        IVertexBuilder builder = buffer.getBuffer((double)alpha == 1.0 ? RenderType.func_228639_c_() : RenderType.func_228645_f_());
        TextureAtlasSprite sprite = this.lit ? RenderHelper.getSprite(TEXTURE_REDSTONE_LAMP_ON) : RenderHelper.getSprite(TEXTURE_REDSTONE_LAMP);
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.0, -1.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor frontNeighbor = cellPos.getNeighbor(Side.FRONT);
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        PanelCellNeighbor bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM);
        boolean change = super.neighborChanged(cellPos);
        if (this.weakSignalStrength + this.strongSignalStrength > 0 || (frontNeighbor != null ? frontNeighbor.getWeakRsOutput() : 0) + (rightNeighbor != null ? rightNeighbor.getWeakRsOutput() : 0) + (backNeighbor != null ? backNeighbor.getWeakRsOutput() : 0) + (leftNeighbor != null ? leftNeighbor.getWeakRsOutput() : 0) + (topNeighbor != null ? topNeighbor.getWeakRsOutput() : 0) + (bottomNeighbor != null ? bottomNeighbor.getWeakRsOutput() : 0) > 0) {
            if (!this.lit) {
                this.lit = true;
                return true;
            }
        } else if (this.lit) {
            this.lit = false;
            return true;
        }
        return change;
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = super.writeNBT();
        nbt.func_74757_a("lit", this.lit);
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT compoundNBT) {
        super.readNBT(compoundNBT);
        this.lit = compoundNBT.func_74767_n("lit");
    }

    @Override
    public int lightOutput() {
        return this.lit ? 1 : 0;
    }
}

