/*
 * Decompiled with CFR 0.152.
 */
package pyre.tinkerslevellingaddon.setup;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import pyre.tinkerslevellingaddon.ImprovableModifier;
import pyre.tinkerslevellingaddon.config.Config;
import pyre.tinkerslevellingaddon.setup.Registration;
import pyre.tinkerslevellingaddon.util.SlotAndStatUtil;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mod.EventBusSubscriber(modid="tinkerslevellingaddon", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static final net.minecraft.util.text.Color IMPROVABLE_MODIFIER_COLOR = net.minecraft.util.text.Color.func_240743_a_((int)9337340);
    private static final String TOOLTIP_LEVEL_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.level";
    private static final String TOOLTIP_LEVEL_NAME_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.level.";
    private static final String TOOLTIP_XP_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.xp";
    private static final String TOOLTIP_HOLD_ALT_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.holdAlt";
    private static final String TOOLTIP_ALT_KEY_KEY = "key.tinkerslevellingaddon.alt";
    private static final String TOOLTIP_MODIFIERS_GAINED_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.info.modifiers";
    private static final String TOOLTIP_MODIFIERS_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.info.modifiers.";
    private static final String TOOLTIP_STATS_GAINED_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.info.stats";
    private static final String TOOLTIP_STATS_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.info.stats.";
    private static final String TOOLTIP_NEXT_LEVEL_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.info.nextLevel";
    private static final String TOOLTIP_NEXT_MODIFIER_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.info.nextLevel.modifier";
    private static final String TOOLTIP_NEXT_STAT_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.info.nextLevel.stat";
    private static final String TOOLTIP_MODIFIER_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.info.modifier.";
    private static final String TOOLTIP_STAT_KEY = "tooltip.tinkerslevellingaddon.improvable.tooltip.info.stat.";
    private static final ITextComponent TOOLTIP_HOLD_ALT = new TranslationTextComponent("tooltip.tinkerslevellingaddon.improvable.tooltip.holdAlt", new Object[]{new TranslationTextComponent("key.tinkerslevellingaddon.alt").func_240700_a_(s -> s.func_240722_b_(Boolean.valueOf(true)).func_240718_a_(IMPROVABLE_MODIFIER_COLOR))});
    private static final ITextComponent TOOLTIP_MODIFIERS_GAINED = new TranslationTextComponent("tooltip.tinkerslevellingaddon.improvable.tooltip.info.modifiers").func_240700_a_(s -> s.func_244282_c(Boolean.valueOf(true)).func_240718_a_(IMPROVABLE_MODIFIER_COLOR));
    private static final ITextComponent TOOLTIP_STATS_GAINED = new TranslationTextComponent("tooltip.tinkerslevellingaddon.improvable.tooltip.info.stats").func_240700_a_(s -> s.func_244282_c(Boolean.valueOf(true)).func_240718_a_(IMPROVABLE_MODIFIER_COLOR));
    private static final ITextComponent TOOLTIP_NEXT_LEVEL = new TranslationTextComponent("tooltip.tinkerslevellingaddon.improvable.tooltip.info.nextLevel").func_240700_a_(s -> s.func_244282_c(Boolean.valueOf(true)).func_240718_a_(IMPROVABLE_MODIFIER_COLOR));

    @SubscribeEvent
    static void onTooltipEvent(ItemTooltipEvent event) {
        KeyModifier activeModifierKey = KeyModifier.getActiveModifier();
        if (event.getPlayer() == null || activeModifierKey == KeyModifier.CONTROL || activeModifierKey == KeyModifier.SHIFT) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (ModifierUtil.getModifierLevel((ItemStack)stack, (Modifier)((Modifier)Registration.IMPROVABLE.get())) <= 0) {
            return;
        }
        for (int i = event.getToolTip().size() - 1; i >= 0; --i) {
            if (event.getToolTip().get(i) != TooltipUtil.TOOLTIP_HOLD_SHIFT && event.getToolTip().get(i) != TooltipUtil.TOOLTIP_HOLD_CTRL) continue;
            event.getToolTip().add(i + 1, TOOLTIP_HOLD_ALT);
            break;
        }
        List<Object> infoEntries = new ArrayList();
        ToolStack tool = ToolStack.from((ItemStack)stack);
        ModDataNBT data = tool.getPersistentData();
        if (activeModifierKey == KeyModifier.ALT) {
            infoEntries.add(event.getToolTip().get(0));
            infoEntries.addAll(ClientEventHandler.prepareLevelInfo(tool, data));
            event.getToolTip().clear();
            event.getToolTip().addAll(infoEntries);
        } else {
            infoEntries = ClientEventHandler.prepareGeneralInfo(tool, data);
            for (int i = 2; i < infoEntries.size() + 2; ++i) {
                event.getToolTip().add(i, infoEntries.get(i - 2));
            }
        }
    }

    private static List<ITextComponent> prepareGeneralInfo(ToolStack tool, ModDataNBT data) {
        ArrayList<ITextComponent> infoEntries = new ArrayList<ITextComponent>();
        int level = data.getInt(ImprovableModifier.LEVEL_KEY);
        IFormattableTextComponent levelTooltip = new TranslationTextComponent(TOOLTIP_LEVEL_KEY, new Object[]{new StringTextComponent(ClientEventHandler.getLevelName(level)).func_240700_a_(s -> s.func_240718_a_(ClientEventHandler.getLevelColor(level)))}).func_230529_a_((ITextComponent)new StringTextComponent(" [" + level + "]").func_240699_a_(TextFormatting.GRAY));
        infoEntries.add((ITextComponent)levelTooltip);
        if (ImprovableModifier.canLevelUp(level)) {
            IFormattableTextComponent xp = new StringTextComponent("" + data.getInt(ImprovableModifier.EXPERIENCE_KEY)).func_240699_a_(TextFormatting.GOLD);
            IFormattableTextComponent xpNeeded = new StringTextComponent("" + ImprovableModifier.getXpNeededForLevel(level + 1, ImprovableModifier.isBroadTool((IModifierToolStack)tool))).func_240699_a_(TextFormatting.GOLD);
            TranslationTextComponent xpTooltip = new TranslationTextComponent(TOOLTIP_XP_KEY, new Object[]{xp, xpNeeded});
            infoEntries.add((ITextComponent)xpTooltip);
        }
        return infoEntries;
    }

    private static List<ITextComponent> prepareLevelInfo(ToolStack tool, ModDataNBT data) {
        String statHistory;
        ArrayList<ITextComponent> infoEntries = new ArrayList<ITextComponent>();
        boolean isArmor = tool.hasTag((ITag)TinkerTags.Items.ARMOR);
        String modifierHistory = data.getString(ImprovableModifier.MODIFIER_HISTORY_KEY);
        if (!modifierHistory.isEmpty()) {
            Map gainedModifiers = Arrays.stream(modifierHistory.split(";")).sorted(Comparator.reverseOrder()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            infoEntries.add(TOOLTIP_MODIFIERS_GAINED);
            for (Map.Entry entry : gainedModifiers.entrySet()) {
                TranslationTextComponent modifierEntry = new TranslationTextComponent(TOOLTIP_MODIFIERS_KEY + (String)entry.getKey(), new Object[]{new StringTextComponent("" + entry.getValue()).func_240700_a_(s -> s.func_240718_a_(SlotAndStatUtil.getModifierColor((String)entry.getKey())))});
                infoEntries.add((ITextComponent)modifierEntry);
            }
        }
        if (!(statHistory = data.getString(ImprovableModifier.STAT_HISTORY_KEY)).isEmpty()) {
            if (!infoEntries.isEmpty()) {
                infoEntries.add(StringTextComponent.field_240750_d_);
            }
            Map gainedStats = Arrays.stream(statHistory.split(";")).sorted().collect(Collectors.groupingBy(Function.identity(), LinkedHashMap::new, Collectors.summingDouble(s -> isArmor ? Config.getArmorStatValue(SlotAndStatUtil.getStatForName(s)) : Config.getToolStatValue(SlotAndStatUtil.getStatForName(s)))));
            gainedStats.computeIfPresent("knockbackResistance", (k, v) -> v * 10.0);
            infoEntries.add(TOOLTIP_STATS_GAINED);
            for (Map.Entry entry : gainedStats.entrySet()) {
                TranslationTextComponent statEntry = new TranslationTextComponent(TOOLTIP_STATS_KEY + (String)entry.getKey(), new Object[]{new StringTextComponent("" + ItemStack.field_111284_a.format(entry.getValue())).func_240700_a_(s -> s.func_240718_a_(SlotAndStatUtil.getStatColor((String)entry.getKey())))});
                infoEntries.add((ITextComponent)statEntry);
            }
        }
        List<ITextComponent> nextLevelInfo = ClientEventHandler.prepareNextLevelInfo(data, isArmor);
        if (!infoEntries.isEmpty() && !nextLevelInfo.isEmpty()) {
            infoEntries.add(StringTextComponent.field_240750_d_);
        }
        infoEntries.addAll(nextLevelInfo);
        return infoEntries;
    }

    private static List<ITextComponent> prepareNextLevelInfo(ModDataNBT data, boolean isArmor) {
        boolean isRandomStat;
        ArrayList<ITextComponent> infoEntries = new ArrayList<ITextComponent>();
        int level = data.getInt(ImprovableModifier.LEVEL_KEY);
        boolean canLevelUp = ImprovableModifier.canLevelUp(level);
        boolean isRandomModifier = isArmor ? ((Boolean)Config.armorModifierTypeRandomOrder.get()).booleanValue() : ((Boolean)Config.toolsModifierTypeRandomOrder.get()).booleanValue();
        boolean bl = isRandomStat = isArmor ? ((Boolean)Config.armorStatTypeRandomOrder.get()).booleanValue() : ((Boolean)Config.toolsStatTypeRandomOrder.get()).booleanValue();
        if (!(!canLevelUp || !((Boolean)Config.enableModifierSlots.get()).booleanValue() && !((Boolean)Config.enableStats.get()).booleanValue() || isRandomModifier && isRandomStat)) {
            infoEntries.add(TOOLTIP_NEXT_LEVEL);
            if (((Boolean)Config.enableModifierSlots.get()).booleanValue() && !isRandomModifier) {
                String nextSlot = isArmor ? SlotAndStatUtil.getArmorSlotForLevel(level + 1) : SlotAndStatUtil.getToolSlotForLevel(level + 1);
                infoEntries.add((ITextComponent)new TranslationTextComponent(TOOLTIP_NEXT_MODIFIER_KEY, new Object[]{new TranslationTextComponent(TOOLTIP_MODIFIER_KEY + nextSlot).func_240700_a_(s -> s.func_240718_a_(SlotAndStatUtil.getModifierColor(nextSlot)))}));
            }
            if (((Boolean)Config.enableStats.get()).booleanValue() && !isRandomStat) {
                double statValue;
                String nextStat = isArmor ? SlotAndStatUtil.getArmorStatForLevel(level + 1) : SlotAndStatUtil.getToolStatForLevel(level + 1);
                double d = statValue = isArmor ? Config.getArmorStatValue(SlotAndStatUtil.getStatForName(nextStat)) : Config.getToolStatValue(SlotAndStatUtil.getStatForName(nextStat));
                if (nextStat.equals("knockbackResistance")) {
                    statValue *= 10.0;
                }
                infoEntries.add((ITextComponent)new TranslationTextComponent(TOOLTIP_NEXT_STAT_KEY, new Object[]{new StringTextComponent(ItemStack.field_111284_a.format(statValue)).func_240700_a_(s -> s.func_240718_a_(SlotAndStatUtil.getStatColor(nextStat))), new TranslationTextComponent(TOOLTIP_STAT_KEY + nextStat)}));
            }
        }
        return infoEntries;
    }

    private static String getLevelName(int level) {
        if (I18n.func_188566_a((String)(TOOLTIP_LEVEL_NAME_KEY + level))) {
            return I18n.func_135052_a((String)(TOOLTIP_LEVEL_NAME_KEY + level), (Object[])new Object[0]);
        }
        int i = 1;
        while (I18n.func_188566_a((String)(TOOLTIP_LEVEL_NAME_KEY + i))) {
            ++i;
        }
        StringBuilder plusSigns = new StringBuilder();
        for (int j = 0; j < level / i; ++j) {
            plusSigns.append("+");
        }
        return I18n.func_135052_a((String)(TOOLTIP_LEVEL_NAME_KEY + level % i), (Object[])new Object[0]) + plusSigns;
    }

    private static net.minecraft.util.text.Color getLevelColor(int level) {
        float hue = 0.277777f * (float)level;
        hue -= (float)((int)hue);
        return net.minecraft.util.text.Color.func_240743_a_((int)Color.HSBtoRGB(hue, 0.75f, 0.8f));
    }
}

