/*
 * Decompiled with CFR 0.152.
 */
package pyre.tinkerslevellingaddon.network;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import pyre.tinkerslevellingaddon.network.ClientPacketHandler;

public class LevelUpPacket {
    private final int level;
    private final ITextComponent toolName;

    public LevelUpPacket(int level, ITextComponent toolName) {
        this.level = level;
        this.toolName = toolName;
    }

    public LevelUpPacket(PacketBuffer buf) {
        this.level = buf.readInt();
        this.toolName = buf.func_179258_d();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.level);
        buf.func_179256_a(this.toolName);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleLevelUpMessage(this.level, this.toolName)));
        return true;
    }
}

