/*
 * Decompiled with CFR 0.152.
 */
package pyre.tinkerslevellingaddon;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import pyre.tinkerslevellingaddon.config.Config;
import pyre.tinkerslevellingaddon.network.LevelUpPacket;
import pyre.tinkerslevellingaddon.network.Messages;
import pyre.tinkerslevellingaddon.util.SlotAndStatUtil;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IHarvestModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IShearModifier;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.ToolDefinitions;

public class ImprovableModifier
extends SingleUseModifier
implements IHarvestModifier,
IShearModifier {
    public static final ResourceLocation EXPERIENCE_KEY = new ResourceLocation("tinkerslevellingaddon", "experience");
    public static final ResourceLocation LEVEL_KEY = new ResourceLocation("tinkerslevellingaddon", "level");
    public static final ResourceLocation MODIFIER_HISTORY_KEY = new ResourceLocation("tinkerslevellingaddon", "modifier_history");
    public static final ResourceLocation STAT_HISTORY_KEY = new ResourceLocation("tinkerslevellingaddon", "stat_history");
    private static final Set<ToolDefinition> BROAD_TOOLS = new HashSet<ToolDefinition>(Arrays.asList(ToolDefinitions.SLEDGE_HAMMER, ToolDefinitions.VEIN_HAMMER, ToolDefinitions.EXCAVATOR, ToolDefinitions.BROAD_AXE, ToolDefinitions.SCYTHE, ToolDefinitions.CLEAVER));

    public ImprovableModifier() {
        super(9337340);
    }

    public void beforeRemoved(IModifierToolStack tool, RestrictedCompoundTag tag) {
        tool.getPersistentData().remove(EXPERIENCE_KEY);
        tool.getPersistentData().remove(LEVEL_KEY);
        tool.getPersistentData().remove(MODIFIER_HISTORY_KEY);
        tool.getPersistentData().remove(STAT_HISTORY_KEY);
    }

    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        if (((Boolean)Config.enableModifierSlots.get()).booleanValue()) {
            List<SlotType> slots = SlotAndStatUtil.parseSlotsHistory(context.getPersistentData().getString(MODIFIER_HISTORY_KEY));
            for (SlotType slot : slots) {
                volatileData.addSlots(slot, 1);
            }
        }
    }

    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
        if (((Boolean)Config.enableStats.get()).booleanValue()) {
            List<FloatToolStat> stats = SlotAndStatUtil.parseStatsHistory(context.getPersistentData().getString(STAT_HISTORY_KEY));
            boolean isArmor = context.hasTag((ITag)TinkerTags.Items.ARMOR);
            for (FloatToolStat stat : stats) {
                stat.add(builder, isArmor ? Config.getArmorStatValue(stat) : Config.getToolStatValue(stat));
            }
        }
    }

    public void afterBlockBreak(IModifierToolStack tool, int level, ToolHarvestContext context) {
        ServerPlayerEntity player = context.getPlayer();
        if (!((Boolean)Config.enableMiningXp.get()).booleanValue() || !context.isEffective() || player == null) {
            return;
        }
        ToolStack toolStack = ImprovableModifier.getHeldTool((LivingEntity)player, (Hand)Hand.MAIN_HAND);
        if (!this.isEqualTinkersItem(tool, (IModifierToolStack)toolStack)) {
            toolStack = ImprovableModifier.getHeldTool((LivingEntity)player, (Hand)Hand.OFF_HAND);
        }
        this.addExperience(toolStack, 1 + (Integer)Config.bonusMiningXp.get(), player);
    }

    public void afterHarvest(IModifierToolStack tool, int level, ItemUseContext context, ServerWorld world, BlockState state, BlockPos pos) {
        if (!((Boolean)Config.enableHarvestingXp.get()).booleanValue() || !(context.func_195999_j() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)context.func_195999_j();
        ToolStack toolStack = ImprovableModifier.getHeldTool((LivingEntity)player, (Hand)context.func_221531_n());
        this.addExperience(toolStack, 1 + (Integer)Config.bonusHarvestingXp.get(), player);
    }

    public void afterShearEntity(IModifierToolStack tool, int level, PlayerEntity player, Entity entity, boolean isTarget) {
        if (!((Boolean)Config.enableShearingXp.get()).booleanValue() || !(player instanceof ServerPlayerEntity)) {
            return;
        }
        ToolStack toolStack = ImprovableModifier.getHeldTool((LivingEntity)player, (Hand)Hand.MAIN_HAND);
        if (!this.isEqualTinkersItem(tool, (IModifierToolStack)toolStack)) {
            toolStack = ImprovableModifier.getHeldTool((LivingEntity)player, (Hand)Hand.OFF_HAND);
        }
        this.addExperience(toolStack, 1 + (Integer)Config.bonusShearingXp.get(), (ServerPlayerEntity)player);
    }

    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        if (!((Boolean)Config.enableAttackingXp.get()).booleanValue() || !(context.getPlayerAttacker() instanceof ServerPlayerEntity) || !((Boolean)Config.enablePvp.get()).booleanValue() && context.getLivingTarget() instanceof PlayerEntity || context.getLivingTarget() == null) {
            return 0;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)context.getPlayerAttacker();
        int xp = ((Boolean)Config.damageDealt.get() != false ? Math.round(damageDealt) : 1) + (Integer)Config.bonusAttackingXp.get();
        ToolStack toolStack = ImprovableModifier.getHeldTool((LivingEntity)context.getPlayerAttacker(), (EquipmentSlotType)context.getSlotType());
        this.addExperience(toolStack, xp, player);
        return 0;
    }

    public void onAttacked(IModifierToolStack tool, int level, EquipmentContext context, EquipmentSlotType slotType, DamageSource source, float amount, boolean isDirectDamage) {
        if (!(((Boolean)Config.enableTakingDamageXp.get()).booleanValue() && slotType.func_188453_a() == EquipmentSlotType.Group.ARMOR && isDirectDamage && context.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)context.getEntity();
        if (player.field_70172_ad > 10 || !this.isValidDamageSource(source, (PlayerEntity)player)) {
            return;
        }
        int xp = ((Boolean)Config.damageTaken.get() != false ? Math.round(amount) : 1) + (Integer)Config.bonusTakingDamageXp.get() + this.getThornsBonus(tool);
        this.addExperience(ImprovableModifier.getHeldTool((LivingEntity)player, (EquipmentSlotType)slotType), xp, player);
    }

    @Nullable
    public <T> T getModule(Class<T> type) {
        if (type == IHarvestModifier.class || type == IShearModifier.class) {
            return (T)((Object)this);
        }
        return null;
    }

    private void addExperience(ToolStack tool, int amount, ServerPlayerEntity player) {
        if (tool == null) {
            return;
        }
        ModDataNBT data = tool.getPersistentData();
        int currentLevel = data.getInt(LEVEL_KEY);
        int currentExperience = data.getInt(EXPERIENCE_KEY) + amount;
        boolean isBroadTool = ImprovableModifier.isBroadTool((IModifierToolStack)tool);
        int experienceNeeded = ImprovableModifier.getXpNeededForLevel(currentLevel + 1, isBroadTool);
        while (currentExperience >= experienceNeeded) {
            if (!ImprovableModifier.canLevelUp(currentLevel)) {
                return;
            }
            data.putInt(LEVEL_KEY, ++currentLevel);
            currentExperience -= experienceNeeded;
            experienceNeeded = ImprovableModifier.getXpNeededForLevel(currentLevel + 1, isBroadTool);
            boolean isArmor = tool.hasTag((ITag)TinkerTags.Items.ARMOR);
            if (((Boolean)Config.enableModifierSlots.get()).booleanValue()) {
                String slotName = this.getSlotName(currentLevel, isArmor);
                this.appendHistory(MODIFIER_HISTORY_KEY, slotName, data);
            }
            if (((Boolean)Config.enableStats.get()).booleanValue()) {
                String statName = this.getStatName(currentLevel, isArmor);
                this.appendHistory(STAT_HISTORY_KEY, statName, data);
            }
            data.putInt(EXPERIENCE_KEY, 0);
            tool.rebuildStats();
            ITextComponent toolName = tool.createStack().func_151000_E();
            Messages.sendToPlayer(new LevelUpPacket(currentLevel, toolName), player);
        }
        data.putInt(EXPERIENCE_KEY, currentExperience);
    }

    private String getSlotName(int level, boolean isArmor) {
        if (!isArmor && !((Boolean)Config.toolsModifierTypeRandomOrder.get()).booleanValue()) {
            return SlotAndStatUtil.getToolSlotForLevel(level);
        }
        if (!isArmor && ((Boolean)Config.toolsModifierTypeRandomOrder.get()).booleanValue()) {
            return SlotAndStatUtil.getRandomToolSlot();
        }
        if (isArmor && !((Boolean)Config.armorModifierTypeRandomOrder.get()).booleanValue()) {
            return SlotAndStatUtil.getArmorSlotForLevel(level);
        }
        return SlotAndStatUtil.getRandomArmorSlot();
    }

    private String getStatName(int level, boolean isArmor) {
        if (!isArmor && !((Boolean)Config.toolsStatTypeRandomOrder.get()).booleanValue()) {
            return SlotAndStatUtil.getToolStatForLevel(level);
        }
        if (!isArmor && ((Boolean)Config.toolsStatTypeRandomOrder.get()).booleanValue()) {
            return SlotAndStatUtil.getRandomToolStat();
        }
        if (isArmor && !((Boolean)Config.armorStatTypeRandomOrder.get()).booleanValue()) {
            return SlotAndStatUtil.getArmorStatForLevel(level);
        }
        return SlotAndStatUtil.getRandomArmorStat();
    }

    private void appendHistory(ResourceLocation historyKey, String value, ModDataNBT data) {
        String modifierHistory = data.getString(historyKey);
        modifierHistory = modifierHistory + value + ";";
        data.putString(historyKey, modifierHistory);
    }

    private boolean isEqualTinkersItem(IModifierToolStack item1, IModifierToolStack item2) {
        if (item1 == null || item2 == null || item1.getItem() != item2.getItem()) {
            return false;
        }
        return item1.getModifiers().equals((Object)item2.getModifiers()) && item1.getMaterials().equals((Object)item2.getMaterials());
    }

    private boolean isValidDamageSource(DamageSource source, PlayerEntity player) {
        if (!source.func_76363_c() && source.func_76346_g() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)source.func_76346_g();
            return !attacker.equals((Object)player) && ((Boolean)Config.enablePvp.get() != false || !(attacker instanceof PlayerEntity));
        }
        return false;
    }

    private int getThornsBonus(IModifierToolStack tool) {
        int thornsLevel = tool.getModifierLevel((Modifier)TinkerModifiers.thorns.get());
        if (!((Boolean)Config.enableThornsXp.get()).booleanValue() || thornsLevel == 0) {
            return 0;
        }
        return RANDOM.nextFloat() < (float)thornsLevel * 0.15f ? 1 + RANDOM.nextInt((Integer)Config.bonusThornsXp.get() + 1) : 0;
    }

    public static int getXpNeededForLevel(int level, boolean isBroadTool) {
        int experienceNeeded = (Integer)Config.baseExperience.get();
        if (level > 1) {
            experienceNeeded = (int)((double)ImprovableModifier.getXpNeededForLevel(level - 1, false) * (Double)Config.requiredXpMultiplier.get());
        }
        if (isBroadTool) {
            experienceNeeded = (int)((double)experienceNeeded * (Double)Config.broadToolRequiredXpMultiplier.get());
        }
        return experienceNeeded;
    }

    public static boolean canLevelUp(int level) {
        return (Integer)Config.maxLevel.get() == 0 || (Integer)Config.maxLevel.get() > level;
    }

    public static boolean isBroadTool(IModifierToolStack tool) {
        return BROAD_TOOLS.contains(tool.getDefinition());
    }
}

