/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.v2;

import de.javagl.jgltf.impl.v2.Accessor;
import de.javagl.jgltf.impl.v2.AccessorSparse;
import de.javagl.jgltf.impl.v2.AccessorSparseIndices;
import de.javagl.jgltf.impl.v2.AccessorSparseValues;
import de.javagl.jgltf.impl.v2.Animation;
import de.javagl.jgltf.impl.v2.AnimationChannel;
import de.javagl.jgltf.impl.v2.AnimationChannelTarget;
import de.javagl.jgltf.impl.v2.AnimationSampler;
import de.javagl.jgltf.impl.v2.Buffer;
import de.javagl.jgltf.impl.v2.BufferView;
import de.javagl.jgltf.impl.v2.Camera;
import de.javagl.jgltf.impl.v2.GlTF;
import de.javagl.jgltf.impl.v2.Image;
import de.javagl.jgltf.impl.v2.Material;
import de.javagl.jgltf.impl.v2.Mesh;
import de.javagl.jgltf.impl.v2.MeshPrimitive;
import de.javagl.jgltf.impl.v2.Node;
import de.javagl.jgltf.impl.v2.Sampler;
import de.javagl.jgltf.impl.v2.Scene;
import de.javagl.jgltf.impl.v2.Skin;
import de.javagl.jgltf.impl.v2.Texture;
import de.javagl.jgltf.model.AccessorData;
import de.javagl.jgltf.model.AccessorDatas;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.AnimationModel;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.CameraModel;
import de.javagl.jgltf.model.ElementType;
import de.javagl.jgltf.model.GltfModel;
import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.MathUtils;
import de.javagl.jgltf.model.MeshModel;
import de.javagl.jgltf.model.MeshPrimitiveModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.SceneModel;
import de.javagl.jgltf.model.SkinModel;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.Utils;
import de.javagl.jgltf.model.impl.DefaultAccessorModel;
import de.javagl.jgltf.model.impl.DefaultAnimationModel;
import de.javagl.jgltf.model.impl.DefaultBufferModel;
import de.javagl.jgltf.model.impl.DefaultBufferViewModel;
import de.javagl.jgltf.model.impl.DefaultCameraModel;
import de.javagl.jgltf.model.impl.DefaultImageModel;
import de.javagl.jgltf.model.impl.DefaultMaterialModel;
import de.javagl.jgltf.model.impl.DefaultMeshModel;
import de.javagl.jgltf.model.impl.DefaultMeshPrimitiveModel;
import de.javagl.jgltf.model.impl.DefaultNodeModel;
import de.javagl.jgltf.model.impl.DefaultSceneModel;
import de.javagl.jgltf.model.impl.DefaultSkinModel;
import de.javagl.jgltf.model.impl.DefaultTextureModel;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.io.v2.GltfAssetV2;
import de.javagl.jgltf.model.v2.AccessorSparseUtils;
import de.javagl.jgltf.model.v2.CamerasV2;
import de.javagl.jgltf.model.v2.MaterialModelHandler;
import de.javagl.jgltf.model.v2.gl.Materials;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;

public final class GltfModelV2
implements GltfModel {
    private static final Logger logger = Logger.getLogger(GltfModelV2.class.getName());
    private final GltfAssetV2 gltfAsset;
    private final GlTF gltf;
    private final ByteBuffer binaryData;
    private final List<DefaultAccessorModel> accessorModels;
    private final List<DefaultAnimationModel> animationModels;
    private final List<DefaultBufferModel> bufferModels;
    private final List<DefaultBufferViewModel> bufferViewModels;
    private final List<DefaultCameraModel> cameraModels;
    private final List<DefaultImageModel> imageModels;
    private final List<DefaultMaterialModel> materialModels;
    private final List<DefaultMeshModel> meshModels;
    private final List<DefaultNodeModel> nodeModels;
    private final List<DefaultSceneModel> sceneModels;
    private final List<DefaultSkinModel> skinModels;
    private final List<DefaultTextureModel> textureModels;
    private final MaterialModelHandler materialModelHandler;

    public GltfModelV2(GltfAssetV2 gltfAsset) {
        this.gltfAsset = Objects.requireNonNull(gltfAsset, "The gltfAsset may not be null");
        this.gltf = gltfAsset.getGltf();
        ByteBuffer binaryData = gltfAsset.getBinaryData();
        this.binaryData = binaryData != null && binaryData.capacity() > 0 ? binaryData : null;
        this.accessorModels = new ArrayList<DefaultAccessorModel>();
        this.animationModels = new ArrayList<DefaultAnimationModel>();
        this.bufferModels = new ArrayList<DefaultBufferModel>();
        this.bufferViewModels = new ArrayList<DefaultBufferViewModel>();
        this.cameraModels = new ArrayList<DefaultCameraModel>();
        this.imageModels = new ArrayList<DefaultImageModel>();
        this.materialModels = new ArrayList<DefaultMaterialModel>();
        this.meshModels = new ArrayList<DefaultMeshModel>();
        this.nodeModels = new ArrayList<DefaultNodeModel>();
        this.sceneModels = new ArrayList<DefaultSceneModel>();
        this.skinModels = new ArrayList<DefaultSkinModel>();
        this.textureModels = new ArrayList<DefaultTextureModel>();
        this.materialModelHandler = new MaterialModelHandler();
        this.createAccessorModels();
        this.createAnimationModels();
        this.createBufferModels();
        this.createBufferViewModels();
        this.createImageModels();
        this.createMeshModels();
        this.createNodeModels();
        this.createSceneModels();
        this.createSkinModels();
        this.createTextureModels();
        this.initBufferModels();
        this.initBufferViewModels();
        this.initAccessorModels();
        this.initAnimationModels();
        this.initImageModels();
        this.initMeshModels();
        this.initNodeModels();
        this.initSceneModels();
        this.initSkinModels();
        this.initTextureModels();
        this.instantiateCameraModels();
    }

    private void createAccessorModels() {
        List<Accessor> accessors = Optionals.of(this.gltf.getAccessors());
        for (int i = 0; i < accessors.size(); ++i) {
            Accessor accessor = accessors.get(i);
            Integer componentType = accessor.getComponentType();
            Integer count = accessor.getCount();
            ElementType elementType = ElementType.forString(accessor.getType());
            DefaultAccessorModel accessorModel = new DefaultAccessorModel(componentType, count, elementType);
            this.accessorModels.add(accessorModel);
        }
    }

    private void createAnimationModels() {
        List<Animation> animations = Optionals.of(this.gltf.getAnimations());
        for (int i = 0; i < animations.size(); ++i) {
            this.animationModels.add(new DefaultAnimationModel());
        }
    }

    private void createBufferModels() {
        List<Buffer> buffers = Optionals.of(this.gltf.getBuffers());
        for (int i = 0; i < buffers.size(); ++i) {
            Buffer buffer = buffers.get(i);
            DefaultBufferModel bufferModel = new DefaultBufferModel();
            bufferModel.setUri(buffer.getUri());
            this.bufferModels.add(bufferModel);
        }
    }

    private void createBufferViewModels() {
        List<BufferView> bufferViews = Optionals.of(this.gltf.getBufferViews());
        for (int i = 0; i < bufferViews.size(); ++i) {
            BufferView bufferView = bufferViews.get(i);
            DefaultBufferViewModel bufferViewModel = GltfModelV2.createBufferViewModel(bufferView);
            this.bufferViewModels.add(bufferViewModel);
        }
    }

    private static DefaultBufferViewModel createBufferViewModel(BufferView bufferView) {
        int byteOffset = Optionals.of(bufferView.getByteOffset(), 0);
        int byteLength = bufferView.getByteLength();
        Integer byteStride = bufferView.getByteStride();
        Integer target = bufferView.getTarget();
        DefaultBufferViewModel bufferViewModel = new DefaultBufferViewModel(target);
        bufferViewModel.setByteOffset(byteOffset);
        bufferViewModel.setByteLength(byteLength);
        bufferViewModel.setByteStride(byteStride);
        return bufferViewModel;
    }

    private void createImageModels() {
        List<Image> images = Optionals.of(this.gltf.getImages());
        for (int i = 0; i < images.size(); ++i) {
            Image image = images.get(i);
            String mimeType = image.getMimeType();
            DefaultImageModel imageModel = new DefaultImageModel(mimeType, null);
            String uri = image.getUri();
            imageModel.setUri(uri);
            this.imageModels.add(imageModel);
        }
    }

    private void createMeshModels() {
        List<Mesh> meshes = Optionals.of(this.gltf.getMeshes());
        for (int i = 0; i < meshes.size(); ++i) {
            this.meshModels.add(new DefaultMeshModel());
        }
    }

    private void createNodeModels() {
        List<Node> nodes = Optionals.of(this.gltf.getNodes());
        for (int i = 0; i < nodes.size(); ++i) {
            this.nodeModels.add(new DefaultNodeModel());
        }
    }

    private void createSceneModels() {
        List<Scene> scenes = Optionals.of(this.gltf.getScenes());
        for (int i = 0; i < scenes.size(); ++i) {
            this.sceneModels.add(new DefaultSceneModel());
        }
    }

    private void createSkinModels() {
        List<Skin> skins = Optionals.of(this.gltf.getSkins());
        for (int i = 0; i < skins.size(); ++i) {
            this.skinModels.add(new DefaultSkinModel(null));
        }
    }

    private void createTextureModels() {
        List<Texture> textures = Optionals.of(this.gltf.getTextures());
        List<Sampler> samplers = Optionals.of(this.gltf.getSamplers());
        for (int i = 0; i < textures.size(); ++i) {
            Texture texture = textures.get(i);
            Integer samplerIndex = texture.getSampler();
            Integer magFilter = 9729;
            Integer minFilter = 9729;
            int wrapS = 10497;
            int wrapT = 10497;
            if (samplerIndex != null) {
                Sampler sampler = samplers.get(samplerIndex);
                magFilter = sampler.getMagFilter();
                minFilter = sampler.getMinFilter();
                wrapS = Optionals.of(sampler.getWrapS(), sampler.defaultWrapS());
                wrapT = Optionals.of(sampler.getWrapT(), sampler.defaultWrapT());
            }
            this.textureModels.add(new DefaultTextureModel(magFilter, minFilter, wrapS, wrapT));
        }
    }

    private void initAccessorModels() {
        List<Accessor> accessors = Optionals.of(this.gltf.getAccessors());
        for (int i = 0; i < accessors.size(); ++i) {
            Accessor accessor = accessors.get(i);
            DefaultAccessorModel accessorModel = this.accessorModels.get(i);
            int byteOffset = Optionals.of(accessor.getByteOffset(), 0);
            accessorModel.setByteOffset(byteOffset);
            AccessorSparse accessorSparse = accessor.getSparse();
            if (accessorSparse == null) {
                this.initDenseAccessorModel(i, accessor, accessorModel);
                continue;
            }
            this.initSparseAccessorModel(i, accessor, accessorModel);
        }
    }

    private void initDenseAccessorModel(int accessorIndex, Accessor accessor, DefaultAccessorModel accessorModel) {
        BufferViewModel bufferViewModel;
        Integer bufferViewIndex = accessor.getBufferView();
        if (bufferViewIndex != null) {
            bufferViewModel = this.bufferViewModels.get(bufferViewIndex);
            accessorModel.setBufferViewModel(bufferViewModel);
        } else {
            int count = accessorModel.getCount();
            int elementSizeInBytes = accessorModel.getElementSizeInBytes();
            int byteLength = elementSizeInBytes * count;
            ByteBuffer bufferData = Buffers.create(byteLength);
            String uriString = "buffer_for_accessor" + accessorIndex + ".bin";
            DefaultBufferViewModel bufferViewModel2 = GltfModelV2.createBufferViewModel(uriString, bufferData);
            accessorModel.setBufferViewModel(bufferViewModel2);
        }
        bufferViewModel = accessorModel.getBufferViewModel();
        Integer byteStride = bufferViewModel.getByteStride();
        if (byteStride == null) {
            accessorModel.setByteStride(accessorModel.getElementSizeInBytes());
        } else {
            accessorModel.setByteStride(byteStride);
        }
    }

    private void initSparseAccessorModel(int accessorIndex, Accessor accessor, DefaultAccessorModel accessorModel) {
        int count = accessorModel.getCount();
        int elementSizeInBytes = accessorModel.getElementSizeInBytes();
        int byteLength = elementSizeInBytes * count;
        ByteBuffer bufferData = Buffers.create(byteLength);
        String uriString = "buffer_for_accessor" + accessorIndex + ".bin";
        DefaultBufferViewModel denseBufferViewModel = GltfModelV2.createBufferViewModel(uriString, bufferData);
        accessorModel.setBufferViewModel(denseBufferViewModel);
        accessorModel.setByteOffset(0);
        Integer bufferViewIndex = accessor.getBufferView();
        if (bufferViewIndex != null) {
            Consumer<ByteBuffer> sparseSubstitutionCallback = denseByteBuffer -> {
                logger.fine("Substituting sparse accessor data, based on existing buffer view");
                DefaultBufferViewModel baseBufferViewModel = this.bufferViewModels.get(bufferViewIndex);
                ByteBuffer baseBufferViewData = baseBufferViewModel.getBufferViewData();
                AccessorData baseAccessorData = AccessorDatas.create(accessorModel, baseBufferViewData);
                AccessorData denseAccessorData = AccessorDatas.create(accessorModel, bufferData);
                this.substituteSparseAccessorData(accessor, accessorModel, denseAccessorData, baseAccessorData);
            };
            denseBufferViewModel.setSparseSubstitutionCallback(sparseSubstitutionCallback);
        } else {
            Consumer<ByteBuffer> sparseSubstitutionCallback = denseByteBuffer -> {
                logger.fine("Substituting sparse accessor data, without an existing buffer view");
                AccessorData denseAccessorData = AccessorDatas.create(accessorModel, bufferData);
                this.substituteSparseAccessorData(accessor, accessorModel, denseAccessorData, null);
            };
            denseBufferViewModel.setSparseSubstitutionCallback(sparseSubstitutionCallback);
        }
    }

    private static DefaultBufferViewModel createBufferViewModel(String uriString, ByteBuffer bufferData) {
        DefaultBufferModel bufferModel = new DefaultBufferModel();
        bufferModel.setUri(uriString);
        bufferModel.setBufferData(bufferData);
        DefaultBufferViewModel bufferViewModel = new DefaultBufferViewModel(null);
        bufferViewModel.setByteOffset(0);
        bufferViewModel.setByteLength(bufferData.capacity());
        bufferViewModel.setBufferModel(bufferModel);
        return bufferViewModel;
    }

    private void substituteSparseAccessorData(Accessor accessor, AccessorModel accessorModel, AccessorData denseAccessorData, AccessorData baseAccessorData) {
        AccessorSparse accessorSparse = accessor.getSparse();
        int count = accessorSparse.getCount();
        AccessorSparseIndices accessorSparseIndices = accessorSparse.getIndices();
        AccessorData sparseIndicesAccessorData = this.createSparseIndicesAccessorData(accessorSparseIndices, count);
        AccessorSparseValues accessorSparseValues = accessorSparse.getValues();
        ElementType elementType = accessorModel.getElementType();
        AccessorData sparseValuesAccessorData = this.createSparseValuesAccessorData(accessorSparseValues, accessorModel.getComponentType(), elementType.getNumComponents(), count);
        AccessorSparseUtils.substituteAccessorData(denseAccessorData, baseAccessorData, sparseIndicesAccessorData, sparseValuesAccessorData);
    }

    private AccessorData createSparseIndicesAccessorData(AccessorSparseIndices accessorSparseIndices, int count) {
        Integer componentType = accessorSparseIndices.getComponentType();
        Integer bufferViewIndex = accessorSparseIndices.getBufferView();
        BufferViewModel bufferViewModel = this.bufferViewModels.get(bufferViewIndex);
        ByteBuffer bufferViewData = bufferViewModel.getBufferViewData();
        int byteOffset = Optionals.of(accessorSparseIndices.getByteOffset(), 0);
        return AccessorDatas.create(componentType, bufferViewData, byteOffset, count, 1, null);
    }

    private AccessorData createSparseValuesAccessorData(AccessorSparseValues accessorSparseValues, int componentType, int numComponentsPerElement, int count) {
        Integer bufferViewIndex = accessorSparseValues.getBufferView();
        BufferViewModel bufferViewModel = this.bufferViewModels.get(bufferViewIndex);
        ByteBuffer bufferViewData = bufferViewModel.getBufferViewData();
        int byteOffset = Optionals.of(accessorSparseValues.getByteOffset(), 0);
        return AccessorDatas.create(componentType, bufferViewData, byteOffset, count, numComponentsPerElement, null);
    }

    private void initAnimationModels() {
        List<Animation> animations = Optionals.of(this.gltf.getAnimations());
        for (int i = 0; i < animations.size(); ++i) {
            Animation animation = animations.get(i);
            DefaultAnimationModel animationModel = this.animationModels.get(i);
            animationModel.setName(animation.getName());
            List<AnimationChannel> channels = Optionals.of(animation.getChannels());
            for (AnimationChannel animationChannel : channels) {
                AnimationModel.Channel channel = this.createChannel(animation, animationChannel);
                animationModel.addChannel(channel);
            }
        }
    }

    private AnimationModel.Channel createChannel(Animation animation, AnimationChannel animationChannel) {
        List<AnimationSampler> samplers = Optionals.of(animation.getSamplers());
        int samplerIndex = animationChannel.getSampler();
        AnimationSampler animationSampler = samplers.get(samplerIndex);
        int inputAccessorIndex = animationSampler.getInput();
        DefaultAccessorModel inputAccessorModel = this.accessorModels.get(inputAccessorIndex);
        int outputAccessorIndex = animationSampler.getOutput();
        DefaultAccessorModel outputAccessorModel = this.accessorModels.get(outputAccessorIndex);
        String interpolationString = animationSampler.getInterpolation();
        AnimationModel.Interpolation interpolation = interpolationString == null ? AnimationModel.Interpolation.LINEAR : AnimationModel.Interpolation.valueOf(interpolationString);
        DefaultAnimationModel.DefaultSampler sampler = new DefaultAnimationModel.DefaultSampler(inputAccessorModel, interpolation, outputAccessorModel);
        AnimationChannelTarget animationChannelTarget = animationChannel.getTarget();
        Integer nodeIndex = animationChannelTarget.getNode();
        NodeModel nodeModel = null;
        if (nodeIndex == null) {
            logger.warning("No node index given for animation channel target");
        } else {
            nodeModel = this.nodeModels.get(nodeIndex);
        }
        String path = animationChannelTarget.getPath();
        DefaultAnimationModel.DefaultChannel channel = new DefaultAnimationModel.DefaultChannel(sampler, nodeModel, path);
        return channel;
    }

    private void initBufferModels() {
        List<Buffer> buffers = Optionals.of(this.gltf.getBuffers());
        if (buffers.isEmpty() && this.binaryData != null) {
            logger.warning("Binary data was given, but no buffers");
            return;
        }
        for (int i = 0; i < buffers.size(); ++i) {
            Buffer buffer = buffers.get(i);
            DefaultBufferModel bufferModel = this.bufferModels.get(i);
            bufferModel.setName(buffer.getName());
            if (i == 0 && this.binaryData != null) {
                bufferModel.setBufferData(this.binaryData);
                continue;
            }
            String uri = buffer.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer bufferData = Buffers.create(data);
                bufferModel.setBufferData(bufferData);
                continue;
            }
            if (uri == null) {
                logger.warning("Buffer " + i + " does not have a uri. Binary chunks that are not the main GLB buffer are not supported.");
                continue;
            }
            ByteBuffer bufferData = this.gltfAsset.getReferenceData(uri);
            bufferModel.setBufferData(bufferData);
        }
    }

    private void initBufferViewModels() {
        List<BufferView> bufferViews = Optionals.of(this.gltf.getBufferViews());
        for (int i = 0; i < bufferViews.size(); ++i) {
            BufferView bufferView = bufferViews.get(i);
            DefaultBufferViewModel bufferViewModel = this.bufferViewModels.get(i);
            bufferViewModel.setName(bufferView.getName());
            int bufferIndex = bufferView.getBuffer();
            BufferModel bufferModel = this.bufferModels.get(bufferIndex);
            bufferViewModel.setBufferModel(bufferModel);
        }
    }

    private void initMeshModels() {
        List<Mesh> meshes = Optionals.of(this.gltf.getMeshes());
        for (int i = 0; i < meshes.size(); ++i) {
            Mesh mesh = meshes.get(i);
            DefaultMeshModel meshModel = this.meshModels.get(i);
            meshModel.setName(mesh.getName());
            List<MeshPrimitive> primitives = Optionals.of(mesh.getPrimitives());
            for (MeshPrimitive meshPrimitive : primitives) {
                DefaultMeshPrimitiveModel meshPrimitiveModel = this.createMeshPrimitiveModel(meshPrimitive);
                meshModel.addMeshPrimitiveModel(meshPrimitiveModel);
            }
        }
    }

    private DefaultMeshPrimitiveModel createMeshPrimitiveModel(MeshPrimitive meshPrimitive) {
        Integer mode = Optionals.of(meshPrimitive.getMode(), meshPrimitive.defaultMode());
        DefaultMeshPrimitiveModel meshPrimitiveModel = new DefaultMeshPrimitiveModel(mode);
        Integer indicesIndex = meshPrimitive.getIndices();
        if (indicesIndex != null) {
            AccessorModel indices = this.accessorModels.get(indicesIndex);
            meshPrimitiveModel.setIndices(indices);
        }
        Map<String, Integer> attributes = Optionals.of(meshPrimitive.getAttributes());
        for (Map.Entry<String, Integer> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            int attributeIndex = entry.getValue();
            AccessorModel attribute = this.accessorModels.get(attributeIndex);
            meshPrimitiveModel.putAttribute(attributeName, attribute);
        }
        List<Map<String, Integer>> morphTargets = Optionals.of(meshPrimitive.getTargets());
        for (Map<String, Integer> morphTarget : morphTargets) {
            LinkedHashMap<String, DefaultAccessorModel> morphTargetModel = new LinkedHashMap<String, DefaultAccessorModel>();
            for (Map.Entry<String, Integer> entry : morphTarget.entrySet()) {
                String attribute = entry.getKey();
                Integer accessorIndex = entry.getValue();
                DefaultAccessorModel accessorModel = this.accessorModels.get(accessorIndex);
                morphTargetModel.put(attribute, accessorModel);
            }
            meshPrimitiveModel.addTarget(Collections.unmodifiableMap(morphTargetModel));
        }
        return meshPrimitiveModel;
    }

    private void initNodeModels() {
        List<Node> nodes = Optionals.of(this.gltf.getNodes());
        for (int i = 0; i < nodes.size(); ++i) {
            Integer skinIndex;
            Node node = nodes.get(i);
            DefaultNodeModel nodeModel = this.nodeModels.get(i);
            nodeModel.setName(node.getName());
            List<Integer> childIndices = Optionals.of(node.getChildren());
            for (Integer childIndex : childIndices) {
                DefaultNodeModel child = this.nodeModels.get(childIndex);
                nodeModel.addChild(child);
            }
            Integer meshIndex = node.getMesh();
            if (meshIndex != null) {
                MeshModel meshModel = this.meshModels.get(meshIndex);
                nodeModel.addMeshModel(meshModel);
            }
            if ((skinIndex = node.getSkin()) != null) {
                SkinModel skinModel = this.skinModels.get(skinIndex);
                nodeModel.setSkinModel(skinModel);
            }
            float[] matrix = node.getMatrix();
            float[] translation = node.getTranslation();
            float[] rotation = node.getRotation();
            float[] scale = node.getScale();
            nodeModel.setMatrix(Optionals.clone(matrix));
            nodeModel.setTranslation(Optionals.clone(translation));
            nodeModel.setRotation(Optionals.clone(rotation));
            nodeModel.setScale(Optionals.clone(scale));
            List<Float> weights = node.getWeights();
            if (weights == null) continue;
            float[] weightsArray = new float[weights.size()];
            for (int j = 0; j < weights.size(); ++j) {
                weightsArray[j] = weights.get(j).floatValue();
            }
            nodeModel.setWeights(weightsArray);
        }
    }

    private void initSceneModels() {
        List<Scene> scenes = Optionals.of(this.gltf.getScenes());
        for (int i = 0; i < scenes.size(); ++i) {
            Scene scene = scenes.get(i);
            DefaultSceneModel sceneModel = this.sceneModels.get(i);
            sceneModel.setName(scene.getName());
            List<Integer> nodeIndices = Optionals.of(scene.getNodes());
            for (Integer nodeIndex : nodeIndices) {
                NodeModel nodeModel = this.nodeModels.get(nodeIndex);
                sceneModel.addNode(nodeModel);
            }
        }
    }

    private void initSkinModels() {
        List<Skin> skins = Optionals.of(this.gltf.getSkins());
        for (int i = 0; i < skins.size(); ++i) {
            Skin skin = skins.get(i);
            DefaultSkinModel skinModel = this.skinModels.get(i);
            skinModel.setName(skin.getName());
            List<Integer> jointIndices = skin.getJoints();
            for (Integer jointIndex : jointIndices) {
                NodeModel jointNodeModel = this.nodeModels.get(jointIndex);
                skinModel.addJoint(jointNodeModel);
            }
            Integer inverseBindMatricesIndex = skin.getInverseBindMatrices();
            DefaultAccessorModel inverseBindMatrices = this.accessorModels.get(inverseBindMatricesIndex);
            skinModel.setInverseBindMatrices(inverseBindMatrices);
        }
    }

    private void initTextureModels() {
        List<Texture> textures = Optionals.of(this.gltf.getTextures());
        for (int i = 0; i < textures.size(); ++i) {
            Texture texture = textures.get(i);
            DefaultTextureModel textureModel = this.textureModels.get(i);
            textureModel.setName(texture.getName());
            Integer imageIndex = texture.getSource();
            DefaultImageModel imageModel = this.imageModels.get(imageIndex);
            textureModel.setImageModel(imageModel);
        }
    }

    private void initImageModels() {
        List<Image> images = Optionals.of(this.gltf.getImages());
        for (int i = 0; i < images.size(); ++i) {
            Image image = images.get(i);
            DefaultImageModel imageModel = this.imageModels.get(i);
            imageModel.setName(image.getName());
            Integer bufferViewIndex = image.getBufferView();
            if (bufferViewIndex != null) {
                BufferViewModel bufferViewModel = this.bufferViewModels.get(bufferViewIndex);
                imageModel.setBufferViewModel(bufferViewModel);
                continue;
            }
            String uri = image.getUri();
            if (IO.isDataUriString(uri)) {
                byte[] data = IO.readDataUri(uri);
                ByteBuffer imageData = Buffers.create(data);
                imageModel.setImageData(imageData);
                continue;
            }
            ByteBuffer imageData = this.gltfAsset.getReferenceData(uri);
            imageModel.setImageData(imageData);
        }
    }

    private void instantiateCameraModels() {
        List<Node> nodes = Optionals.of(this.gltf.getNodes());
        List<Camera> cameras = Optionals.of(this.gltf.getCameras());
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            Integer cameraIndex = node.getCamera();
            if (cameraIndex == null) continue;
            Camera camera = cameras.get(cameraIndex);
            NodeModel nodeModel = this.nodeModels.get(i);
            Function<float[], float[]> viewMatrixComputer = result -> {
                float[] localResult = Utils.validate(result, 16);
                nodeModel.computeGlobalTransform(localResult);
                MathUtils.invert4x4(localResult, localResult);
                return localResult;
            };
            BiFunction<float[], Float, float[]> projectionMatrixComputer = (result, aspectRatio) -> {
                float[] localResult = Utils.validate(result, 16);
                CamerasV2.computeProjectionMatrix(camera, aspectRatio, localResult);
                return localResult;
            };
            DefaultCameraModel cameraModel = new DefaultCameraModel(viewMatrixComputer, projectionMatrixComputer);
            cameraModel.setName(camera.getName());
            cameraModel.setNodeModel(nodeModel);
            String nodeName = Optionals.of(node.getName(), "node" + i);
            String cameraName = Optionals.of(camera.getName(), "camera" + cameraIndex);
            String instanceName = nodeName + "." + cameraName;
            cameraModel.setInstanceName(instanceName);
            this.cameraModels.add(cameraModel);
        }
    }

    private void instantiateMaterialModels() {
        List<Node> nodes = Optionals.of(this.gltf.getNodes());
        List<Mesh> meshes = Optionals.of(this.gltf.getMeshes());
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            Integer meshIndex = node.getMesh();
            if (meshIndex == null) continue;
            MeshModel meshModel = this.meshModels.get(meshIndex);
            int numJoints = 0;
            Integer skinIndex = node.getSkin();
            if (skinIndex != null) {
                SkinModel skinModel = this.skinModels.get(skinIndex);
                numJoints = skinModel.getJoints().size();
            }
            Mesh mesh = meshes.get(meshIndex);
            this.instantiateMaterialModels(mesh, meshModel, numJoints);
        }
    }

    private void instantiateMaterialModels(Mesh mesh, MeshModel meshModel, int numJoints) {
        List<MeshPrimitive> meshPrimitives = mesh.getPrimitives();
        List<MeshPrimitiveModel> meshPrimitiveModels = meshModel.getMeshPrimitiveModels();
        for (int i = 0; i < meshPrimitives.size(); ++i) {
            MeshPrimitive meshPrimitive = meshPrimitives.get(i);
            DefaultMeshPrimitiveModel meshPrimitiveModel = (DefaultMeshPrimitiveModel)meshPrimitiveModels.get(i);
            Material material = null;
            Integer materialIndex = meshPrimitive.getMaterial();
            material = materialIndex == null ? Materials.createDefaultMaterial() : this.gltf.getMaterials().get(materialIndex);
            DefaultMaterialModel materialModel = this.materialModelHandler.createMaterialModel(material, numJoints);
            materialModel.setName(material.getName());
            meshPrimitiveModel.setMaterialModel(materialModel);
            this.materialModels.add(materialModel);
        }
    }

    @Override
    public List<AccessorModel> getAccessorModels() {
        return Collections.unmodifiableList(this.accessorModels);
    }

    @Override
    public List<AnimationModel> getAnimationModels() {
        return Collections.unmodifiableList(this.animationModels);
    }

    @Override
    public List<BufferModel> getBufferModels() {
        return Collections.unmodifiableList(this.bufferModels);
    }

    @Override
    public List<BufferViewModel> getBufferViewModels() {
        return Collections.unmodifiableList(this.bufferViewModels);
    }

    @Override
    public List<CameraModel> getCameraModels() {
        return Collections.unmodifiableList(this.cameraModels);
    }

    @Override
    public List<ImageModel> getImageModels() {
        return Collections.unmodifiableList(this.imageModels);
    }

    @Override
    public List<MaterialModel> getMaterialModels() {
        return Collections.unmodifiableList(this.materialModels);
    }

    @Override
    public List<NodeModel> getNodeModels() {
        return Collections.unmodifiableList(this.nodeModels);
    }

    @Override
    public List<SceneModel> getSceneModels() {
        return Collections.unmodifiableList(this.sceneModels);
    }

    @Override
    public List<TextureModel> getTextureModels() {
        return Collections.unmodifiableList(this.textureModels);
    }

    public GlTF getGltf() {
        return this.gltf;
    }
}

