/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.impl.creation;

import de.javagl.jgltf.impl.v2.Accessor;
import de.javagl.jgltf.impl.v2.Buffer;
import de.javagl.jgltf.impl.v2.BufferView;
import de.javagl.jgltf.model.AccessorData;
import de.javagl.jgltf.model.AccessorDatas;
import de.javagl.jgltf.model.AccessorModel;
import de.javagl.jgltf.model.BufferModel;
import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.impl.creation.BufferStructure;
import java.util.ArrayList;
import java.util.List;

public class BufferStructureGltfV2 {
    public static List<Accessor> createAccessors(BufferStructure bufferStructure) {
        List<BufferViewModel> bufferViewModels = bufferStructure.getBufferViewModels();
        List<AccessorModel> accessorModels = bufferStructure.getAccessorModels();
        ArrayList<Accessor> accessors = new ArrayList<Accessor>();
        for (AccessorModel accessorModel : accessorModels) {
            BufferViewModel bufferViewModel = accessorModel.getBufferViewModel();
            int bufferViewIndex = bufferViewModels.indexOf(bufferViewModel);
            accessors.add(BufferStructureGltfV2.createAccessor(accessorModel, bufferViewIndex));
        }
        return accessors;
    }

    private static Accessor createAccessor(AccessorModel accessorModel, int bufferViewIndex) {
        Accessor accessor = new Accessor();
        accessor.setBufferView(bufferViewIndex);
        accessor.setByteOffset(accessorModel.getByteOffset());
        accessor.setComponentType(accessorModel.getComponentType());
        accessor.setCount(accessorModel.getCount());
        accessor.setType(accessorModel.getElementType().toString());
        AccessorData accessorData = accessorModel.getAccessorData();
        accessor.setMax(AccessorDatas.computeMax(accessorData));
        accessor.setMin(AccessorDatas.computeMin(accessorData));
        return accessor;
    }

    public static List<BufferView> createBufferViews(BufferStructure bufferStructure) {
        List<BufferModel> bufferModels = bufferStructure.getBufferModels();
        List<BufferViewModel> bufferViewModels = bufferStructure.getBufferViewModels();
        ArrayList<BufferView> bufferViews = new ArrayList<BufferView>();
        for (BufferViewModel bufferViewModel : bufferViewModels) {
            BufferModel bufferModel = bufferViewModel.getBufferModel();
            int bufferIndex = bufferModels.indexOf(bufferModel);
            bufferViews.add(BufferStructureGltfV2.createBufferView(bufferViewModel, bufferIndex));
        }
        return bufferViews;
    }

    private static BufferView createBufferView(BufferViewModel bufferViewModel, int bufferIndex) {
        BufferView bufferView = new BufferView();
        bufferView.setBuffer(bufferIndex);
        bufferView.setByteOffset(bufferViewModel.getByteOffset());
        bufferView.setByteLength(bufferViewModel.getByteLength());
        bufferView.setByteStride(bufferViewModel.getByteStride());
        bufferView.setTarget(bufferViewModel.getTarget());
        return bufferView;
    }

    public static List<Buffer> createBuffers(BufferStructure bufferStructure) {
        List<BufferModel> bufferModels = bufferStructure.getBufferModels();
        ArrayList<Buffer> buffers = new ArrayList<Buffer>();
        for (BufferModel bufferModel : bufferModels) {
            buffers.add(BufferStructureGltfV2.createBuffer(bufferModel));
        }
        return buffers;
    }

    private static Buffer createBuffer(BufferModel bufferModel) {
        Buffer buffer = new Buffer();
        buffer.setUri(bufferModel.getUri());
        buffer.setByteLength(bufferModel.getByteLength());
        return buffer;
    }

    private BufferStructureGltfV2() {
    }
}

