/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.util;

import com.tac.guns.GunMod;
import com.tac.guns.common.Rig;
import com.tac.guns.entity.ProjectileEntity;
import com.tac.guns.inventory.gear.GearSlotsHandler;
import com.tac.guns.inventory.gear.InventoryListener;
import com.tac.guns.item.TransitionalTypes.wearables.ArmorRigItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageGunSound;
import com.tac.guns.util.RigEnchantmentHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;

public class WearableHelper {
    @Nullable
    public static ItemStack PlayerWornRig(PlayerEntity player) {
        if (GunMod.curiosLoaded) {
            AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
            LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
            optional.ifPresent(itemHandler -> {
                Optional stacksOptional = itemHandler.getStacksHandler(GunMod.curiosRigSlotId);
                stacksOptional.ifPresent(stacksHandler -> {
                    ItemStack stack = stacksHandler.getStacks().getStackInSlot(0);
                    if (stack.func_77973_b() instanceof ArmorRigItem) {
                        backpack.set(stack);
                    }
                });
            });
            if (backpack.get() != ItemStack.field_190927_a) {
                return backpack.get();
            }
            return null;
        }
        GearSlotsHandler ammoItemHandler = (GearSlotsHandler)player.getCapability(InventoryListener.ITEM_HANDLER_CAPABILITY).resolve().get();
        for (ItemStack stack : ammoItemHandler.getStacks()) {
            if (!(stack.func_77973_b() instanceof ArmorRigItem)) continue;
            return stack;
        }
        return null;
    }

    public static void FillDefaults(ItemStack item, Rig rig) {
        item.func_77978_p().func_74776_a("RigDurability", RigEnchantmentHelper.getModifiedDurability(item, rig));
    }

    public static boolean isFullDurability(ItemStack rig) {
        Rig modifiedRig = ((ArmorRigItem)rig.func_77973_b()).getModifiedRig(rig);
        float max = RigEnchantmentHelper.getModifiedDurability(rig, modifiedRig);
        return rig.func_77978_p().func_74760_g("RigDurability") >= max;
    }

    public static boolean tickFromCurrentDurability(PlayerEntity player, ProjectileEntity proj) {
        ItemStack rig = WearableHelper.PlayerWornRig(player);
        float og = rig.func_77978_p().func_74760_g("RigDurability");
        rig.func_77978_p().func_82580_o("RigDurability");
        if (og == 0.0f) {
            return true;
        }
        if (og - proj.getDamage() > 0.0f) {
            rig.func_77978_p().func_74776_a("RigDurability", og - proj.getDamage());
        } else if (og - proj.getDamage() < 0.0f) {
            ResourceLocation brokenSound = ((ArmorRigItem)rig.func_77973_b()).getRig().getSounds().getBroken();
            if (brokenSound != null) {
                MessageGunSound messageSound = new MessageGunSound(brokenSound, SoundCategory.PLAYERS, (float)player.func_226277_ct_(), (float)(player.func_226278_cu_() + 1.0), (float)player.func_226281_cx_(), 1.5f, 1.0f, player.func_145782_y(), false, false);
                PacketHandler.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)messageSound);
            }
            rig.func_77978_p().func_74776_a("RigDurability", 0.0f);
            return false;
        }
        return false;
    }

    public static float currentDurabilityPercentage(ItemStack rig) {
        return rig.func_77978_p().func_74760_g("RigDurability") / ((ArmorRigItem)rig.func_77973_b()).getRig().getRepair().getDurability();
    }

    public static boolean tickRepairCurrentDurability(ItemStack rig) {
        Rig modifiedRig = ((ArmorRigItem)rig.func_77973_b()).getModifiedRig(rig);
        float og = rig.func_77978_p().func_74760_g("RigDurability");
        float max = RigEnchantmentHelper.getModifiedDurability(rig, modifiedRig);
        float ofDurability = modifiedRig.getRepair().getQuickRepairability();
        rig.func_77978_p().func_82580_o("RigDurability");
        float totalAfterRepair = og + max * ofDurability;
        if (!(totalAfterRepair >= max)) {
            rig.func_77978_p().func_74776_a("RigDurability", totalAfterRepair);
            return true;
        }
        rig.func_77978_p().func_74776_a("RigDurability", max);
        return false;
    }

    public static boolean tickRepairCurrentDurability(ItemStack rig, float repair) {
        Rig modifiedRig = ((ArmorRigItem)rig.func_77973_b()).getModifiedRig(rig);
        float og = rig.func_77978_p().func_74760_g("RigDurability");
        float max = RigEnchantmentHelper.getModifiedDurability(rig, modifiedRig);
        float ofDurability = repair;
        rig.func_77978_p().func_82580_o("RigDurability");
        float totalAfterRepair = og + max * ofDurability;
        if (!(og >= max)) {
            rig.func_77978_p().func_74776_a("RigDurability", totalAfterRepair);
            return true;
        }
        rig.func_77978_p().func_74776_a("RigDurability", max);
        return false;
    }

    public static float GetCurrentDurability(ItemStack item) {
        return item.func_77978_p().func_74760_g("RigDurability");
    }
}

