/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.util;

import com.tac.guns.common.Gun;
import com.tac.guns.interfaces.IGunModifier;
import com.tac.guns.item.TransitionalTypes.TimelessGunItem;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.item.attachment.impl.Attachment;
import com.tac.guns.util.GunEnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class GunModifierHelper {
    private static final IGunModifier[] EMPTY = new IGunModifier[0];

    private static IGunModifier[] getModifiers(ItemStack weapon, IAttachment.Type type) {
        ItemStack stack = Gun.getAttachment(type, weapon);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IAttachment) {
            IAttachment attachment = (IAttachment)stack.func_77973_b();
            return ((Attachment)attachment.getProperties()).getModifiers();
        }
        return EMPTY;
    }

    private static IGunModifier[] getModifiers(ItemStack weapon) {
        if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof TimelessGunItem) {
            TimelessGunItem gunItem = (TimelessGunItem)weapon.func_77973_b();
            return gunItem.getModifiers();
        }
        return EMPTY;
    }

    public static int getModifiedProjectileLife(ItemStack weapon, int life) {
        IGunModifier[] modifiers;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                life = modifier.modifyProjectileLife(life);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            life = modifier.modifyProjectileLife(life);
        }
        return life;
    }

    public static double getModifiedProjectileGravity(ItemStack weapon, double gravity) {
        IGunModifier[] modifierD;
        IGunModifier[] modifiersD;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            IGunModifier[] iGunModifierArray = modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                gravity = modifier.modifyProjectileGravity(gravity);
            }
        }
        for (IGunModifier modifier : modifiersD = GunModifierHelper.getModifiers(weapon)) {
            gravity = modifier.modifyProjectileGravity(gravity);
        }
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                gravity += modifier.additionalProjectileGravity();
            }
        }
        for (IGunModifier modifier : modifierD = GunModifierHelper.getModifiers(weapon)) {
            gravity += modifier.additionalProjectileGravity();
        }
        return gravity;
    }

    public static float getModifiedSpread(ItemStack weapon, float spread) {
        IGunModifier[] modifiers;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                spread = modifier.modifyProjectileSpread(spread);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            spread = modifier.modifyProjectileSpread(spread);
        }
        return spread;
    }

    public static float getModifiedFirstShotSpread(ItemStack weapon, float spread) {
        IGunModifier[] modifiers;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                spread = modifier.modifyFirstShotSpread(spread);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            spread = modifier.modifyFirstShotSpread(spread);
        }
        return spread;
    }

    public static float getModifiedHipFireSpread(ItemStack weapon, float spread) {
        IGunModifier[] modifiers;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                spread = modifier.modifyHipFireSpread(spread);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            spread = modifier.modifyHipFireSpread(spread);
        }
        return spread;
    }

    public static double getModifiedProjectileSpeed(ItemStack weapon, double speed) {
        IGunModifier[] modifiers;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                speed = modifier.modifyProjectileSpeed(speed);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            speed = modifier.modifyProjectileSpeed(speed);
        }
        return speed;
    }

    public static float getFireSoundVolume(ItemStack weapon) {
        IGunModifier[] modifiers;
        float volume = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                volume = modifier.modifyFireSoundVolume(volume);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            volume = modifier.modifyFireSoundVolume(volume);
        }
        return MathHelper.func_76131_a((float)volume, (float)0.0f, (float)16.0f);
    }

    public static double getMuzzleFlashSize(ItemStack weapon, double size) {
        IGunModifier[] modifiers;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                size = modifier.modifyMuzzleFlashSize(size);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            size = modifier.modifyMuzzleFlashSize(size);
        }
        return size;
    }

    public static float getKickReduction(ItemStack weapon) {
        IGunModifier[] modifiers;
        float kickReduction = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                kickReduction *= MathHelper.func_76131_a((float)modifier.kickModifier(), (float)0.0f, (float)1.0f);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            kickReduction *= MathHelper.func_76131_a((float)modifier.kickModifier(), (float)0.0f, (float)1.0f);
        }
        return 1.0f - kickReduction;
    }

    public static float getRecoilSmootheningTime(ItemStack weapon) {
        IGunModifier[] modifiers;
        float recoilTime = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                recoilTime *= MathHelper.func_76131_a((float)modifier.modifyRecoilSmoothening(), (float)1.0f, (float)2.0f);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            recoilTime *= MathHelper.func_76131_a((float)modifier.modifyRecoilSmoothening(), (float)1.0f, (float)2.0f);
        }
        return recoilTime;
    }

    public static float getRecoilModifier(ItemStack weapon) {
        IGunModifier[] modifiers;
        float recoilReduction = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                recoilReduction *= MathHelper.func_76131_a((float)modifier.recoilModifier(), (float)0.0f, (float)1.0f);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            recoilReduction *= MathHelper.func_76131_a((float)modifier.recoilModifier(), (float)0.0f, (float)1.0f);
        }
        return 1.0f - recoilReduction;
    }

    public static float getHorizontalRecoilModifier(ItemStack weapon) {
        IGunModifier[] modifiers;
        float reduction = 1.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                reduction *= MathHelper.func_76131_a((float)modifier.horizontalRecoilModifier(), (float)0.0f, (float)1.0f);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            reduction *= MathHelper.func_76131_a((float)modifier.horizontalRecoilModifier(), (float)0.0f, (float)1.0f);
        }
        return 1.0f - reduction;
    }

    public static boolean isSilencedFire(ItemStack weapon) {
        IGunModifier[] modifiers;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                if (!modifier.silencedFire()) continue;
                return true;
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            if (!modifier.silencedFire()) continue;
            return true;
        }
        return false;
    }

    public static double getModifiedFireSoundRadius(ItemStack weapon, double radius) {
        IGunModifier[] modifiers;
        double minRadius = radius;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                double newRadius = modifier.modifyFireSoundRadius(radius);
                if (!(newRadius < minRadius)) continue;
                minRadius = newRadius;
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            double newRadius = modifier.modifyFireSoundRadius(radius);
            if (!(newRadius < minRadius)) continue;
            minRadius = newRadius;
        }
        return MathHelper.func_151237_a((double)minRadius, (double)0.0, (double)Double.MAX_VALUE);
    }

    public static float getAdditionalDamage(ItemStack weapon) {
        IGunModifier[] modifiers;
        float additionalDamage = 0.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                additionalDamage += modifier.additionalDamage();
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            additionalDamage += modifier.additionalDamage();
        }
        return additionalDamage;
    }

    public static float getAdditionalHeadshotDamage(ItemStack weapon) {
        IGunModifier[] modifiers;
        float additionalDamage = 0.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                additionalDamage += modifier.additionalHeadshotDamage();
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            additionalDamage += modifier.additionalHeadshotDamage();
        }
        return additionalDamage;
    }

    public static float getModifiedProjectileDamage(ItemStack weapon, float damage) {
        IGunModifier[] modifiers;
        float finalDamage = damage;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                finalDamage = modifier.modifyProjectileDamage(finalDamage);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            finalDamage = modifier.modifyProjectileDamage(finalDamage);
        }
        return finalDamage;
    }

    public static float getModifiedDamage(ItemStack weapon, Gun modifiedGun, float damage) {
        IGunModifier[] modifiersD2;
        IGunModifier[] modifiersD1;
        float finalDamage = damage;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            IGunModifier[] iGunModifierArray = modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                finalDamage = modifier.modifyProjectileDamage(finalDamage);
            }
        }
        for (IGunModifier modifier : modifiersD1 = GunModifierHelper.getModifiers(weapon)) {
            finalDamage = modifier.modifyProjectileDamage(finalDamage);
        }
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers;
            for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i])) {
                finalDamage += modifier.additionalDamage();
            }
        }
        for (IGunModifier modifier : modifiersD2 = GunModifierHelper.getModifiers(weapon)) {
            finalDamage += modifier.additionalDamage();
        }
        return finalDamage;
    }

    public static double getModifiedAimDownSightSpeed(ItemStack weapon, double speed) {
        IGunModifier[] modifiers;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                speed = modifier.modifyAimDownSightSpeed(speed);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            speed = modifier.modifyAimDownSightSpeed(speed);
        }
        return MathHelper.func_151237_a((double)speed, (double)0.01, (double)Double.MAX_VALUE);
    }

    public static int getModifiedRate(ItemStack weapon, int rate) {
        IGunModifier[] modifiers;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                rate = modifier.modifyFireRate(rate);
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            rate = modifier.modifyFireRate(rate);
        }
        return MathHelper.func_76125_a((int)rate, (int)0, (int)Integer.MAX_VALUE);
    }

    public static float getCriticalChance(ItemStack weapon) {
        IGunModifier[] modifiers;
        float chance = 0.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                chance += modifier.criticalChance();
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            chance += modifier.criticalChance();
        }
        return MathHelper.func_76131_a((float)(chance += GunEnchantmentHelper.getPuncturingChance(weapon)), (float)0.0f, (float)1.0f);
    }

    public static float getAdditionalWeaponWeight(ItemStack weapon) {
        IGunModifier[] modifiers;
        float additionalWeight = 0.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                additionalWeight += modifier.additionalWeaponWeight();
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            additionalWeight += modifier.additionalWeaponWeight();
        }
        return additionalWeight;
    }

    public static float getModifierOfWeaponWeight(ItemStack weapon) {
        IGunModifier[] modifiers;
        float modifierWeight = 0.0f;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                modifierWeight += modifier.modifyWeaponWeight();
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            modifierWeight += modifier.modifyWeaponWeight();
        }
        return modifierWeight;
    }

    public static int getAmmoCapacity(ItemStack weapon, Gun modifiedGun) {
        int capacity = modifiedGun.getReloads().isOpenBolt() ? modifiedGun.getReloads().getMaxAmmo() : modifiedGun.getReloads().getMaxAmmo() + 1;
        int level = GunModifierHelper.getAmmoCapacity(weapon);
        if (level > -1 && level < modifiedGun.getReloads().getMaxAdditionalAmmoPerOC().length) {
            capacity += modifiedGun.getReloads().getMaxAdditionalAmmoPerOC()[level];
        } else if (level > -1) {
            capacity += capacity / 2 * level - 3;
        }
        return capacity;
    }

    public static int getAmmoCapacity(ItemStack weapon) {
        IGunModifier[] modifiers;
        int modifierWeight = -1;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            IGunModifier[] modifiers2;
            IGunModifier[] iGunModifierArray = modifiers2 = GunModifierHelper.getModifiers(weapon, IAttachment.Type.values()[i]);
            int n = iGunModifierArray.length;
            for (int j = 0; j < n; ++j) {
                IGunModifier modifier = iGunModifierArray[j];
                modifierWeight = modifier.additionalAmmunition() > modifierWeight ? modifier.additionalAmmunition() : modifierWeight;
            }
        }
        for (IGunModifier modifier : modifiers = GunModifierHelper.getModifiers(weapon)) {
            modifierWeight = modifier.additionalAmmunition() > modifierWeight ? modifier.additionalAmmunition() : modifierWeight;
        }
        return modifierWeight;
    }
}

