/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.network.message;

import com.google.common.collect.ImmutableMap;
import com.tac.guns.client.network.ClientPlayHandler;
import com.tac.guns.common.CustomRig;
import com.tac.guns.common.CustomRigLoader;
import com.tac.guns.common.NetworkRigManager;
import com.tac.guns.common.Rig;
import com.tac.guns.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class MessageUpdateRigs
implements IMessage,
NetworkRigManager.IRigProvider {
    private ImmutableMap<ResourceLocation, Rig> registeredRigs;
    private ImmutableMap<ResourceLocation, CustomRig> customRigs;

    @Override
    public void encode(PacketBuffer buffer) {
        Validate.notNull((Object)((Object)NetworkRigManager.get()));
        Validate.notNull((Object)((Object)CustomRigLoader.get()));
        NetworkRigManager.get().writeRegisteredRigs(buffer);
        CustomRigLoader.get().writeCustomRigs(buffer);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.registeredRigs = NetworkRigManager.readRegisteredRigs(buffer);
        this.customRigs = CustomRigLoader.readCustomRigs(buffer);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ClientPlayHandler.handleUpdateRigs(this));
        supplier.get().setPacketHandled(true);
    }

    @Override
    public ImmutableMap<ResourceLocation, Rig> getRegisteredRigs() {
        return this.registeredRigs;
    }

    @Override
    public ImmutableMap<ResourceLocation, CustomRig> getCustomRigs() {
        return this.customRigs;
    }
}

