/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.network;

import com.google.common.collect.ImmutableMap;
import com.tac.guns.common.CustomGun;
import com.tac.guns.common.CustomGunLoader;
import com.tac.guns.common.CustomRig;
import com.tac.guns.common.CustomRigLoader;
import com.tac.guns.common.Gun;
import com.tac.guns.common.NetworkGunManager;
import com.tac.guns.common.NetworkRigManager;
import com.tac.guns.common.Rig;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class HandshakeMessages {

    public static class S2CUpdateRigs
    extends LoginIndexedMessage
    implements NetworkRigManager.IRigProvider {
        private ImmutableMap<ResourceLocation, Rig> registeredRigs;
        private ImmutableMap<ResourceLocation, CustomRig> customRigs;

        void encode(PacketBuffer buffer) {
            Validate.notNull((Object)((Object)NetworkRigManager.get()));
            NetworkRigManager.get().writeRegisteredRigs(buffer);
            Validate.notNull((Object)((Object)CustomRigLoader.get()));
            CustomRigLoader.get().writeCustomRigs(buffer);
        }

        static S2CUpdateRigs decode(PacketBuffer buffer) {
            S2CUpdateRigs message = new S2CUpdateRigs();
            message.registeredRigs = NetworkRigManager.readRegisteredRigs(buffer);
            message.customRigs = CustomRigLoader.readCustomRigs(buffer);
            return message;
        }

        @Override
        @Nullable
        public ImmutableMap<ResourceLocation, Rig> getRegisteredRigs() {
            return this.registeredRigs;
        }

        @Override
        @Nullable
        public ImmutableMap<ResourceLocation, CustomRig> getCustomRigs() {
            return this.customRigs;
        }
    }

    public static class S2CUpdateGuns
    extends LoginIndexedMessage
    implements NetworkGunManager.IGunProvider {
        private ImmutableMap<ResourceLocation, Gun> registeredGuns;
        private ImmutableMap<ResourceLocation, CustomGun> customGuns;

        void encode(PacketBuffer buffer) {
            Validate.notNull((Object)((Object)NetworkGunManager.get()));
            NetworkGunManager.get().writeRegisteredGuns(buffer);
            Validate.notNull((Object)((Object)CustomGunLoader.get()));
            CustomGunLoader.get().writeCustomGuns(buffer);
        }

        static S2CUpdateGuns decode(PacketBuffer buffer) {
            S2CUpdateGuns message = new S2CUpdateGuns();
            message.registeredGuns = NetworkGunManager.readRegisteredGuns(buffer);
            message.customGuns = CustomGunLoader.readCustomGuns(buffer);
            return message;
        }

        @Override
        @Nullable
        public ImmutableMap<ResourceLocation, Gun> getRegisteredGuns() {
            return this.registeredGuns;
        }

        @Override
        @Nullable
        public ImmutableMap<ResourceLocation, CustomGun> getCustomGuns() {
            return this.customGuns;
        }
    }

    static class C2SAcknowledge
    extends LoginIndexedMessage {
        C2SAcknowledge() {
        }

        void encode(PacketBuffer buf) {
        }

        static C2SAcknowledge decode(PacketBuffer buf) {
            return new C2SAcknowledge();
        }
    }

    static class LoginIndexedMessage
    implements IntSupplier {
        private int loginIndex;

        LoginIndexedMessage() {
        }

        void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }

        int getLoginIndex() {
            return this.loginIndex;
        }

        @Override
        public int getAsInt() {
            return this.getLoginIndex();
        }
    }
}

