/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item.TransitionalTypes.wearables;

import com.tac.guns.GunMod;
import com.tac.guns.common.NetworkRigManager;
import com.tac.guns.common.Rig;
import com.tac.guns.inventory.gear.armor.ArmorRigCapabilityProvider;
import com.tac.guns.inventory.gear.armor.ArmorRigContainerProvider;
import com.tac.guns.inventory.gear.armor.ArmorRigInventoryCapability;
import com.tac.guns.inventory.gear.armor.RigSlotsHandler;
import com.tac.guns.item.TransitionalTypes.wearables.IArmoredRigItem;
import com.tac.guns.util.RigEnchantmentHelper;
import com.tac.guns.util.WearableHelper;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkHooks;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

@Mod.EventBusSubscriber(modid="tac")
public class ArmorRigItem
extends Item
implements IArmoredRigItem {
    private final int numOfRows;
    private ArmorRigContainerProvider containerProvider;
    private WeakHashMap<CompoundNBT, Rig> modifiedRigCache = new WeakHashMap();
    private Rig rig = new Rig();

    public ArmorRigItem(Item.Properties properties) {
        super(properties);
        this.numOfRows = 1;
    }

    public int getNumOfRows() {
        return this.numOfRows;
    }

    public ArmorRigItem(int rows, Item.Properties properties) {
        super(properties);
        this.numOfRows = rows;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.field_72995_K) {
            return super.func_77659_a(world, player, hand);
        }
        if (hand != Hand.MAIN_HAND) {
            return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
        }
        this.containerProvider = new ArmorRigContainerProvider(player.func_184586_b(hand));
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.containerProvider);
        super.func_77659_a(world, player, hand);
        return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (GunMod.curiosLoaded) {
            return ArmorRigItem.createBackpackProvider(stack);
        }
        return new ArmorRigInventoryCapability();
    }

    public static ICapabilityProvider createBackpackProvider(final ItemStack stack) {
        return CurioItemCapability.createProvider((ICurio)new ICurio(){

            @Nonnull
            public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
                return new ICurio.SoundInfo(SoundEvents.field_187713_n, 1.0f, 1.0f);
            }

            public boolean canUnequip(String identifier, LivingEntity livingEntity) {
                CompoundNBT tag = stack.func_77978_p();
                return tag == null || tag.func_150295_c("Items", 10).isEmpty();
            }

            @Nonnull
            public ICurio.DropRule getDropRule(LivingEntity livingEntity) {
                return ICurio.DropRule.DEFAULT;
            }

            @Nullable
            public CompoundNBT writeSyncData() {
                return stack.getShareTag();
            }
        });
    }

    public void setRig(NetworkRigManager.Supplier supplier) {
        this.rig = supplier.getRig();
    }

    public Rig getRig() {
        return this.rig;
    }

    public boolean func_77651_p() {
        return true;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        stack.func_196082_o();
        CompoundNBT nbt = super.getShareTag(stack);
        if (stack.func_77973_b() instanceof ArmorRigItem) {
            RigSlotsHandler itemHandler = (RigSlotsHandler)stack.getCapability(ArmorRigCapabilityProvider.capability).resolve().get();
            nbt.func_218657_a("storage", (INBT)itemHandler.serializeNBT());
        }
        return nbt;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            stack.func_196082_o();
            WearableHelper.FillDefaults(stack, this.rig);
            stacks.add((Object)stack);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        stack.func_196082_o();
        Rig modifiedRig = this.getModifiedRig(stack);
        return 1.0 - (double)WearableHelper.GetCurrentDurability(stack) / (double)RigEnchantmentHelper.getModifiedDurability(stack, modifiedRig);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Objects.requireNonNull(TextFormatting.AQUA.func_211163_e());
    }

    public Rig getModifiedRig(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("Rig", 10)) {
            return this.modifiedRigCache.computeIfAbsent(tagCompound, item -> {
                if (tagCompound.func_74767_n("Custom")) {
                    return Rig.create(tagCompound.func_74775_l("Rig"));
                }
                Rig gunCopy = this.rig.copy();
                gunCopy.deserializeNBT(tagCompound.func_74775_l("Rig"));
                return gunCopy;
            });
        }
        return this.rig;
    }
}

