/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item;

import com.tac.guns.common.DiscardOffhand;
import com.tac.guns.common.Gun;
import com.tac.guns.common.NetworkGunManager;
import com.tac.guns.init.ModItems;
import com.tac.guns.item.IColored;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class GunItem
extends Item
implements IColored {
    private WeakHashMap<CompoundNBT, Gun> modifiedGunCache = new WeakHashMap();
    private Gun gun = new Gun();

    public GunItem(Item.Properties properties) {
        super(properties);
    }

    public void setGun(NetworkGunManager.Supplier supplier) {
        this.gun = supplier.getGun();
    }

    public Gun getGun() {
        return this.gun;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Gun modifiedGun = this.getModifiedGun(stack);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
        if (ammo != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.ammo_type", new Object[]{new TranslationTextComponent(ammo.func_77658_a()).func_240699_a_(TextFormatting.WHITE)}).func_240699_a_(TextFormatting.GRAY));
        }
        String additionalDamageText = "";
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("AdditionalDamage", 99)) {
            float additionalDamage = tagCompound.func_74760_g("AdditionalDamage");
            if ((additionalDamage += GunModifierHelper.getAdditionalDamage(stack)) > 0.0f) {
                additionalDamageText = TextFormatting.GREEN + " +" + ItemStack.field_111284_a.format(additionalDamage);
            } else if (additionalDamage < 0.0f) {
                additionalDamageText = TextFormatting.RED + " " + ItemStack.field_111284_a.format(additionalDamage);
            }
        }
        float damage = modifiedGun.getProjectile().getDamage();
        damage = GunModifierHelper.getModifiedProjectileDamage(stack, damage);
        damage = GunEnchantmentHelper.getAcceleratorDamage(stack, damage);
        tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.damage", new Object[]{TextFormatting.WHITE + ItemStack.field_111284_a.format(damage) + additionalDamageText}).func_240699_a_(TextFormatting.GRAY));
        if (tagCompound != null) {
            if (tagCompound.func_74767_n("IgnoreAmmo")) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.ignore_ammo").func_240699_a_(TextFormatting.AQUA));
            } else {
                int ammoCount = tagCompound.func_74762_e("AmmoCount");
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.ammo", new Object[]{TextFormatting.WHITE.toString() + ammoCount + "/" + GunModifierHelper.getAmmoCapacity(stack, modifiedGun)}).func_240699_a_(TextFormatting.GRAY));
            }
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.attachment_help", new Object[]{new KeybindTextComponent("key.tac.attachments").getString().toUpperCase(Locale.ENGLISH)}).func_240699_a_(TextFormatting.YELLOW));
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            stack.func_196082_o().func_74768_a("AmmoCount", this.gun.getReloads().getMaxAmmo());
            stacks.add((Object)stack);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        Gun modifiedGun = this.getModifiedGun(stack);
        return !tagCompound.func_74767_n("IgnoreAmmo") && tagCompound.func_74762_e("AmmoCount") != GunModifierHelper.getAmmoCapacity(stack, modifiedGun);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_196082_o();
        Gun modifiedGun = this.getModifiedGun(stack);
        return 1.0 - (double)tagCompound.func_74762_e("AmmoCount") / (double)GunModifierHelper.getAmmoCapacity(stack, modifiedGun);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Objects.requireNonNull(TextFormatting.AQUA.func_211163_e());
    }

    public Gun getModifiedGun(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("Gun", 10)) {
            return this.modifiedGunCache.computeIfAbsent(tagCompound, item -> {
                if (tagCompound.func_74767_n("Custom")) {
                    return Gun.create(tagCompound.func_74775_l("Gun"));
                }
                Gun gunCopy = this.gun.copy();
                gunCopy.deserializeNBT(tagCompound.func_74775_l("Gun"));
                return gunCopy;
            });
        }
        return this.gun;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (isSelected && !worldIn.field_72995_K && entityIn instanceof PlayerEntity) {
            ItemStack offHand;
            PlayerEntity playerEntity = (PlayerEntity)entityIn;
            if (!(GunItem.isSingleHanded(stack) || DiscardOffhand.isSafeTime(playerEntity) || (offHand = playerEntity.func_184592_cb()).func_77973_b() instanceof GunItem || offHand.func_190926_b())) {
                ItemEntity entity = playerEntity.func_71019_a(offHand, false);
                playerEntity.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
                if (entity != null) {
                    entity.func_174868_q();
                }
            }
        }
    }

    public static boolean isSingleHanded(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == ModItems.M1911.get() || item == ModItems.MICRO_UZI.get() || item == ModItems.CZ75.get() || item == ModItems.MK23.get();
    }
}

