/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.tac.guns.common.Gun;
import com.tac.guns.item.GunItem;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="tac")
public class SpreadTracker {
    private static final Map<PlayerEntity, SpreadTracker> TRACKER_MAP = new WeakHashMap<PlayerEntity, SpreadTracker>();
    private final Map<GunItem, Pair<MutableLong, MutableInt>> SPREAD_TRACKER_MAP = new HashMap<GunItem, Pair<MutableLong, MutableInt>>();

    public void update(PlayerEntity player, GunItem item) {
        Pair entry = this.SPREAD_TRACKER_MAP.computeIfAbsent(item, gun -> Pair.of((Object)new MutableLong(-1L), (Object)new MutableInt()));
        MutableLong lastFire = (MutableLong)entry.getLeft();
        Gun gun2 = item.getGun();
        if (lastFire.getValue() != -1L) {
            MutableInt spreadCount = (MutableInt)entry.getRight();
            long deltaTime = System.currentTimeMillis() - lastFire.getValue();
            if (deltaTime < (long)gun2.getGeneral().getMsToAccuracyReset()) {
                if (spreadCount.getValue() < gun2.getGeneral().getProjCountAccuracy()) {
                    spreadCount.increment();
                }
            } else {
                spreadCount.setValue(0);
            }
        }
        lastFire.setValue(System.currentTimeMillis());
    }

    public float getSpread(GunItem item) {
        Pair<MutableLong, MutableInt> entry = this.SPREAD_TRACKER_MAP.get(item);
        Gun gun = item.getGun();
        if (entry != null) {
            if (((MutableInt)entry.getRight()).getValue() == 1) {
                return 0.0f;
            }
            return (float)((MutableInt)entry.getRight()).getValue().intValue() / (float)gun.getGeneral().getProjCountAccuracy();
        }
        return 0.0f;
    }

    public static SpreadTracker get(PlayerEntity player) {
        return TRACKER_MAP.computeIfAbsent(player, player1 -> new SpreadTracker());
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getPlayer().func_184102_h();
        if (server != null) {
            server.execute(() -> TRACKER_MAP.remove(event.getPlayer()));
        }
    }
}

