/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.tac.guns.common.Gun;
import com.tac.guns.common.network.ServerPlayHandler;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.inventory.gear.armor.ArmorRigCapabilityProvider;
import com.tac.guns.inventory.gear.armor.RigSlotsHandler;
import com.tac.guns.item.GunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageGunSound;
import com.tac.guns.network.message.MessageRigInvToClient;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.WearableHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="tac")
public class ReloadTracker {
    private static final Map<PlayerEntity, ReloadTracker> RELOAD_TRACKER_MAP = new WeakHashMap<PlayerEntity, ReloadTracker>();
    private final int startTick;
    private final int slot;
    private final ItemStack stack;
    private final Gun gun;

    private ReloadTracker(PlayerEntity player) {
        this.startTick = player.field_70173_aa;
        this.slot = player.field_71071_by.field_70461_c;
        this.stack = player.field_71071_by.func_70448_g();
        this.gun = ((GunItem)this.stack.func_77973_b()).getModifiedGun(this.stack);
    }

    private boolean isSameWeapon(PlayerEntity player) {
        return !this.stack.func_190926_b() && player.field_71071_by.field_70461_c == this.slot && player.field_71071_by.func_70448_g() == this.stack;
    }

    private boolean isWeaponFull() {
        CompoundNBT tag = this.stack.func_196082_o();
        return tag.func_74762_e("AmmoCount") >= GunModifierHelper.getAmmoCapacity(this.stack, this.gun);
    }

    private boolean isWeaponEmpty() {
        CompoundNBT tag = this.stack.func_196082_o();
        return tag.func_74762_e("AmmoCount") == 0;
    }

    private boolean hasNoAmmo(PlayerEntity player) {
        return Gun.findAmmo(player, this.gun.getProjectile().getItem()).length == 0 ? true : Gun.findAmmo(player, this.gun.getProjectile().getItem())[0].func_190926_b();
    }

    private boolean canReload(PlayerEntity player) {
        boolean reload;
        Gun gun = ((GunItem)this.stack.func_77973_b()).getGun();
        ItemStack rig = WearableHelper.PlayerWornRig(player);
        if (rig != null) {
            PacketHandler.getPlayChannel().sendTo((Object)new MessageRigInvToClient(rig, gun.getProjectile().getItem()), ((ServerPlayerEntity)player).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
        if (gun.getReloads().isMagFed()) {
            int interval;
            int deltaTicks;
            reload = this.isWeaponEmpty() ? (deltaTicks = player.field_70173_aa - this.startTick) > (interval = gun.getReloads().getReloadMagTimer() + gun.getReloads().getAdditionalReloadEmptyMagTimer() + this.gun.getReloads().getPreReloadPauseTicks()) : (deltaTicks = player.field_70173_aa - this.startTick) > (interval = gun.getReloads().getReloadMagTimer() + this.gun.getReloads().getPreReloadPauseTicks());
        } else {
            int deltaTicks = player.field_70173_aa - this.startTick;
            int interval = GunEnchantmentHelper.getReloadInterval(this.stack);
            reload = deltaTicks > 0 && deltaTicks % interval == 0;
        }
        return reload;
    }

    private void increaseAmmo(PlayerEntity player) {
        ResourceLocation reloadSound;
        ItemStack ammo = Gun.findAmmo(player, this.gun.getProjectile().getItem())[0];
        if (!ammo.func_190926_b()) {
            CompoundNBT tag = this.stack.func_77978_p();
            int amount = Math.min(ammo.func_190916_E(), this.gun.getReloads().getReloadAmount());
            if (tag != null) {
                int maxAmmo = GunModifierHelper.getAmmoCapacity(this.stack, this.gun);
                amount = Math.min(amount, maxAmmo - tag.func_74762_e("AmmoCount"));
                tag.func_74768_a("AmmoCount", tag.func_74762_e("AmmoCount") + amount);
            }
            this.shrinkFromAmmoPool(new ItemStack[]{ammo}, player, amount);
        }
        if ((reloadSound = this.gun.getSounds().getReload()) != null) {
            MessageGunSound message = new MessageGunSound(reloadSound, SoundCategory.PLAYERS, (float)player.func_226277_ct_(), (float)player.func_226278_cu_() + 1.0f, (float)player.func_226281_cx_(), 1.0f, 1.0f, player.func_145782_y(), false, true);
            PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), 16.0, player.field_70170_p.func_234923_W_())), (Object)message);
        }
    }

    public static int calcMaxReserveAmmo(ItemStack[] ammoStacks) {
        int result = 0;
        for (ItemStack x : ammoStacks) {
            result += x.func_190916_E();
        }
        return result;
    }

    private void shrinkFromAmmoPool(ItemStack[] ammoStacks, PlayerEntity player, int shrinkAmount) {
        int shrinkAmt = shrinkAmount;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemStack rig = WearableHelper.PlayerWornRig(player);
        if (rig != null) {
            RigSlotsHandler itemHandler = (RigSlotsHandler)rig.getCapability(ArmorRigCapabilityProvider.capability).resolve().get();
            for (ItemStack x : itemHandler.getStacks()) {
                if (!Gun.isAmmo(x, this.gun.getProjectile().getItem())) continue;
                stacks.add(x);
            }
            for (ItemStack x : stacks) {
                if (!x.func_190926_b()) {
                    int max = shrinkAmt > x.func_190916_E() ? x.func_190916_E() : shrinkAmt;
                    x.func_190918_g(max);
                    shrinkAmt -= max;
                }
                if (shrinkAmt != 0) continue;
                return;
            }
        }
        for (ItemStack x : ammoStacks) {
            if (!x.func_190926_b()) {
                int max = shrinkAmt > x.func_190916_E() ? x.func_190916_E() : shrinkAmt;
                x.func_190918_g(max);
                shrinkAmt -= max;
            }
            if (shrinkAmt != 0) continue;
            return;
        }
    }

    private void increaseMagAmmo(PlayerEntity player) {
        ResourceLocation reloadSound;
        ItemStack[] ammoStacks = Gun.findAmmo(player, this.gun.getProjectile().getItem());
        boolean stackItor = false;
        if (ammoStacks.length > 0) {
            CompoundNBT tag = this.stack.func_77978_p();
            int ammoAmount = Math.min(ReloadTracker.calcMaxReserveAmmo(ammoStacks), GunModifierHelper.getAmmoCapacity(this.stack, this.gun));
            if (tag != null) {
                int currentAmmo = tag.func_74762_e("AmmoCount");
                int maxAmmo = GunModifierHelper.getAmmoCapacity(this.stack, this.gun);
                int amount = maxAmmo - currentAmmo;
                if (currentAmmo == 0 && !this.gun.getReloads().isOpenBolt()) {
                    if (ammoAmount < amount) {
                        tag.func_74768_a("AmmoCount", currentAmmo + ammoAmount);
                        this.shrinkFromAmmoPool(ammoStacks, player, ammoAmount);
                    } else {
                        tag.func_74768_a("AmmoCount", maxAmmo - 1);
                        this.shrinkFromAmmoPool(ammoStacks, player, amount - 1);
                    }
                } else if (ammoAmount < amount) {
                    tag.func_74768_a("AmmoCount", currentAmmo + ammoAmount);
                    this.shrinkFromAmmoPool(ammoStacks, player, ammoAmount);
                } else {
                    tag.func_74768_a("AmmoCount", maxAmmo);
                    this.shrinkFromAmmoPool(ammoStacks, player, amount);
                }
            }
        }
        if ((reloadSound = this.gun.getSounds().getReload()) != null) {
            MessageGunSound message = new MessageGunSound(reloadSound, SoundCategory.PLAYERS, (float)player.func_226277_ct_(), (float)player.func_226278_cu_() + 1.0f, (float)player.func_226281_cx_(), 1.0f, 1.0f, player.func_145782_y(), false, true);
            PacketHandler.getPlayChannel().send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), 16.0, player.field_70170_p.func_234923_W_())), (Object)message);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.field_72995_K) {
            PlayerEntity player = event.player;
            if (((Boolean)SyncedPlayerData.instance().get(player, ModSyncedDataKeys.RELOADING)).booleanValue()) {
                ReloadTracker tracker;
                if (!RELOAD_TRACKER_MAP.containsKey(player)) {
                    if (!(player.field_71071_by.func_70448_g().func_77973_b() instanceof GunItem)) {
                        SyncedPlayerData.instance().set(player, ModSyncedDataKeys.RELOADING, (Object)false);
                        SyncedPlayerData.instance().set(player, ModSyncedDataKeys.STOP_ANIMA, (Object)false);
                        return;
                    }
                    RELOAD_TRACKER_MAP.put(player, new ReloadTracker(player));
                }
                if (!(tracker = RELOAD_TRACKER_MAP.get(player)).isSameWeapon(player) || tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                    RELOAD_TRACKER_MAP.remove(player);
                    SyncedPlayerData.instance().set(player, ModSyncedDataKeys.RELOADING, (Object)false);
                    SyncedPlayerData.instance().set(player, ModSyncedDataKeys.STOP_ANIMA, (Object)true);
                    return;
                }
                if (tracker.canReload(player)) {
                    PlayerEntity finalPlayer = player;
                    Gun gun = tracker.gun;
                    if (gun.getReloads().isMagFed()) {
                        tracker.increaseMagAmmo(player);
                        ServerPlayHandler.handleRigAmmoCount((ServerPlayerEntity)player, gun.getProjectile().getItem());
                        RELOAD_TRACKER_MAP.remove(player);
                        SyncedPlayerData.instance().set(player, ModSyncedDataKeys.RELOADING, (Object)false);
                        SyncedPlayerData.instance().set(player, ModSyncedDataKeys.STOP_ANIMA, (Object)false);
                    } else {
                        tracker.increaseAmmo(player);
                        ServerPlayHandler.handleRigAmmoCount((ServerPlayerEntity)player, gun.getProjectile().getItem());
                        if (tracker.isWeaponFull() || tracker.hasNoAmmo(player)) {
                            RELOAD_TRACKER_MAP.remove(player);
                            SyncedPlayerData.instance().set(player, ModSyncedDataKeys.RELOADING, (Object)false);
                            SyncedPlayerData.instance().set(player, ModSyncedDataKeys.STOP_ANIMA, (Object)false);
                        }
                    }
                }
            } else if (RELOAD_TRACKER_MAP.containsKey(player)) {
                RELOAD_TRACKER_MAP.remove(player);
            }
        }
    }

    public static boolean isPlayerReload(PlayerEntity player) {
        return RELOAD_TRACKER_MAP.containsKey(player);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getPlayer().func_184102_h();
        if (server != null) {
            server.execute(() -> RELOAD_TRACKER_MAP.remove(event.getPlayer()));
        }
    }
}

