/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tac.guns.GunMod;
import com.tac.guns.annotation.Validator;
import com.tac.guns.common.CustomRig;
import com.tac.guns.common.JsonDeserializers;
import com.tac.guns.common.Rig;
import com.tac.guns.item.TransitionalTypes.wearables.ArmorRigItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(modid="tac")
public class NetworkRigManager
extends ReloadListener<Map<ArmorRigItem, Rig>> {
    private static final Gson GSON_INSTANCE = (Gson)Util.func_199748_a(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ResourceLocation.class, JsonDeserializers.RESOURCE_LOCATION);
        return builder.create();
    });
    private static List<ArmorRigItem> clientRegisteredrigs = new ArrayList<ArmorRigItem>();
    private static NetworkRigManager instance;
    private Map<ResourceLocation, Rig> registeredRigs = new HashMap<ResourceLocation, Rig>();
    public HashSet<UUID> Ids = new HashSet();

    protected Map<ArmorRigItem, Rig> prepare(IResourceManager resourceManager, IProfiler profiler) {
        HashMap map = Maps.newHashMap();
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof ArmorRigItem).forEach(item -> {
            ResourceLocation id = item.getRegistryName();
            if (id != null) {
                ResourceLocation resourceLocation = new ResourceLocation(String.format("%s:rigs/%s.json", id.func_110624_b(), id.func_110623_a()));
                try (IResource resource = resourceManager.func_199002_a(resourceLocation);
                     InputStream is = resource.func_199027_b();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    Rig rig = (Rig)JSONUtils.func_193839_a((Gson)GSON_INSTANCE, (Reader)reader, Rig.class);
                    if (rig != null && Validator.isValidObject(rig)) {
                        map.put((ArmorRigItem)item, rig);
                    } else {
                        GunMod.LOGGER.error("Couldn't load data file {} as it is missing or malformed. Using default rig data", (Object)resourceLocation);
                        map.put((ArmorRigItem)item, new Rig());
                    }
                }
                catch (InvalidObjectException e) {
                    GunMod.LOGGER.error("Missing required properties for {}", (Object)resourceLocation);
                    e.printStackTrace();
                }
                catch (IOException e) {
                    GunMod.LOGGER.error("Couldn't parse data file {}", (Object)resourceLocation);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
        return map;
    }

    protected void apply(Map<ArmorRigItem, Rig> objects, IResourceManager resourceManager, IProfiler profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        objects.forEach((item, rig) -> {
            Validate.notNull((Object)item.getRegistryName());
            builder.put((Object)item.getRegistryName(), rig);
            item.setRig(new Supplier((Rig)rig));
        });
        this.registeredRigs = builder.build();
    }

    public void writeRegisteredRigs(PacketBuffer buffer) {
        buffer.func_150787_b(this.registeredRigs.size());
        this.registeredRigs.forEach((id, rig) -> {
            buffer.func_192572_a(id);
            buffer.func_150786_a(rig.serializeNBT());
        });
    }

    public static ImmutableMap<ResourceLocation, Rig> readRegisteredRigs(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        if (size > 0) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = buffer.func_192575_l();
                Rig rig = Rig.create(buffer.func_150793_b());
                builder.put((Object)id, (Object)rig);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean updateRegisteredRigs(IRigProvider message) {
        clientRegisteredrigs.clear();
        ImmutableMap<ResourceLocation, Rig> registeredrigs = message.getRegisteredRigs();
        if (registeredrigs != null) {
            for (Map.Entry entry : registeredrigs.entrySet()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)entry.getKey());
                if (!(item instanceof ArmorRigItem)) {
                    return false;
                }
                ((ArmorRigItem)item).setRig(new Supplier((Rig)entry.getValue()));
                clientRegisteredrigs.add((ArmorRigItem)item);
            }
            return true;
        }
        return false;
    }

    public Map<ResourceLocation, Rig> getRegisteredRigs() {
        return this.registeredRigs;
    }

    public static List<ArmorRigItem> getClientRegisteredRigs() {
        return ImmutableList.copyOf(clientRegisteredrigs);
    }

    @SubscribeEvent
    public static void onServerStopped(FMLServerStoppedEvent event) {
        instance = null;
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        NetworkRigManager networkRigManager = new NetworkRigManager();
        event.addListener((IFutureReloadListener)networkRigManager);
        instance = networkRigManager;
    }

    @Nullable
    public static NetworkRigManager get() {
        return instance;
    }

    public static class Supplier {
        private Rig rig;

        private Supplier(Rig rig) {
            this.rig = rig;
        }

        public Rig getRig() {
            return this.rig;
        }
    }

    public static interface IRigProvider {
        public ImmutableMap<ResourceLocation, Rig> getRegisteredRigs();

        public ImmutableMap<ResourceLocation, CustomRig> getCustomRigs();
    }
}

