/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.crosshair;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tac.guns.client.handler.AimingHandler;
import com.tac.guns.client.render.crosshair.IDynamicScalable;
import com.tac.guns.client.render.crosshair.TexturedCrosshair;
import com.tac.guns.item.TransitionalTypes.TimelessGunItem;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class DynamicScalingTexturedCrosshair
extends TexturedCrosshair
implements IDynamicScalable {
    private final float initial = 0.95f;
    private final float horizontal = 1.2f;
    private final float vertical = 1.6f;
    private float scale = 0.95f;
    private float prevScale = 0.95f;
    private int fractal = 4;

    public DynamicScalingTexturedCrosshair(ResourceLocation id) {
        super(id);
    }

    public DynamicScalingTexturedCrosshair(ResourceLocation id, boolean blend) {
        super(id, blend);
    }

    @Override
    public void scale(float value) {
        this.prevScale = this.scale;
        this.scale = value;
    }

    @Override
    public float getInitialScale() {
        return 0.95f;
    }

    @Override
    public float getHorizontalMovementScale() {
        return 1.2f;
    }

    @Override
    public float getVerticalMovementScale() {
        return 1.6f;
    }

    public int getFractal() {
        return this.fractal;
    }

    public void setFractal(int value) {
        if (value > 0) {
            this.fractal = value;
        }
    }

    @Override
    public void render(Minecraft mc, MatrixStack stack, int windowWidth, int windowHeight, float partialTicks) {
        TimelessGunItem gunItem;
        ClientPlayerEntity playerEntity = mc.field_71439_g;
        if (playerEntity == null) {
            return;
        }
        if (playerEntity.func_184614_ca().func_77973_b() == null || playerEntity.func_184614_ca().func_77973_b() == Items.field_190931_a) {
            return;
        }
        if (playerEntity.func_184614_ca().func_77973_b() instanceof TimelessGunItem && (gunItem = (TimelessGunItem)playerEntity.func_184614_ca().func_77973_b()).getGun().getDisplay().isDynamicHipfire()) {
            float alpha = 1.0f - (float)AimingHandler.get().getNormalisedAdsProgress();
            float size = 8.0f;
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            stack.func_227860_a_();
            stack.func_227861_a_((double)((float)windowWidth / 2.0f), (double)((float)windowHeight / 2.0f), 0.0);
            float scale = 1.0f + MathHelper.func_219799_g((float)partialTicks, (float)this.prevScale, (float)this.scale);
            mc.func_110434_K().func_110577_a(this.texture);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            for (int f = 0; f < this.getFractal(); ++f) {
                stack.func_227860_a_();
                stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(360.0f * (float)f / (float)this.getFractal()));
                stack.func_227861_a_((double)(-size * scale / 2.0f), (double)(-size / 2.0f), 0.0);
                Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
                buffer.func_227888_a_(matrix, 0.0f, size, 0.0f).func_225583_a_(0.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                buffer.func_227888_a_(matrix, size, size, 0.0f).func_225583_a_(1.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                buffer.func_227888_a_(matrix, size, 0.0f, 0.0f).func_225583_a_(1.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                buffer.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225583_a_(0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
                stack.func_227865_b_();
            }
            buffer.func_178977_d();
            RenderSystem.enableAlphaTest();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
            stack.func_227865_b_();
        }
    }

    @Override
    public void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity playerEntity = mc.field_71439_g;
        if (playerEntity == null) {
            return;
        }
        float scale = this.getInitialScale();
        if (playerEntity.func_184614_ca().func_77973_b() instanceof TimelessGunItem) {
            TimelessGunItem gunItem = (TimelessGunItem)playerEntity.func_184614_ca().func_77973_b();
            if (playerEntity.func_226277_ct_() != playerEntity.field_70169_q || playerEntity.func_226281_cx_() != playerEntity.field_70166_s) {
                scale += this.getHorizontalMovementScale() * gunItem.getGun().getDisplay().getHipfireMoveScale();
            }
            if (playerEntity.func_226278_cu_() != playerEntity.field_70167_r) {
                scale += this.getVerticalMovementScale() * gunItem.getGun().getDisplay().getHipfireMoveScale();
            }
            this.scale(scale * gunItem.getGun().getGeneral().getHipFireInaccuracy() * gunItem.getGun().getDisplay().getHipfireScale() * (GunModifierHelper.getModifiedSpread(playerEntity.func_184614_ca(), gunItem.getGun().getGeneral().getSpread() / 2.0f) * GunEnchantmentHelper.getSpreadModifier(playerEntity.func_184614_ca())));
        }
    }

    @Override
    public void onGunFired() {
        this.scale *= 1.25f;
    }
}

