/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.armor.VestLayer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.render.armor.VestLayer.ArmorBase;
import com.tac.guns.client.render.armor.models.ModernArmor;
import com.tac.guns.util.WearableHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;

@OnlyIn(value=Dist.CLIENT)
public class VestLayerRender<T extends PlayerEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static final Map<Item, ArmorBase> MODELS = new HashMap<Item, ArmorBase>();

    public VestLayerRender(IEntityRenderer<T, M> renderer) {
        super(renderer);
    }

    public static synchronized <T extends ArmorBase> void registerModel(Item item, T model) {
        MODELS.putIfAbsent(item, model);
    }

    public static boolean isBackpackVisible(PlayerEntity player) {
        AtomicReference<Boolean> visible = new AtomicReference<Boolean>(true);
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(itemHandler -> {
            Optional stacksOptional = itemHandler.getStacksHandler(GunMod.curiosRigSlotId);
            stacksOptional.ifPresent(stacksHandler -> visible.set((Boolean)stacksHandler.getRenders().get(0)));
        });
        return visible.get();
    }

    public void render(MatrixStack stack, IRenderTypeBuffer renderTypeBuffer, int p_225628_3_, T player, float p_225628_5_, float p_225628_6_, float partialTick, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        if (GunMod.curiosLoaded && !VestLayerRender.isBackpackVisible(player)) {
            return;
        }
        if (WearableHelper.PlayerWornRig(player) != null && ((Boolean)Config.COMMON.gameplay.renderTaCArmor.get()).booleanValue()) {
            ItemStack armor = WearableHelper.PlayerWornRig(player);
            stack.func_227860_a_();
            Item modelName = armor.func_77973_b();
            ArmorBase model = MODELS.get(modelName);
            if (model == null) {
                model = new ModernArmor();
            }
            model.rotateToPlayerBody(((BipedModel)this.func_215332_c()).field_78115_e);
            if (((BipedModel)this.func_215332_c()).field_228270_o_) {
                stack.func_227861_a_(0.0, -0.15, 0.7475);
            }
            IVertexBuilder builder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)model.func_228282_a_(model.getTexture()), (boolean)false, (boolean)false);
            model.func_225598_a_(stack, builder, p_225628_3_, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            stack.func_227865_b_();
        }
    }
}

