/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.animation.module;

import com.tac.guns.client.render.animation.module.AnimationSoundMeta;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import com.tac.guns.common.Gun;
import com.tac.guns.item.GunItem;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class PumpShotgunAnimationController
extends GunAnimationController {
    private boolean empty = false;

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    @Override
    protected AnimationSoundMeta getSoundFromLabel(Item item, GunAnimationController.AnimationLabel label) {
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            Gun.Sounds sounds = gunItem.getGun().getSounds();
            switch (label) {
                case PUMP: {
                    return new AnimationSoundMeta(sounds.getPump());
                }
                case RELOAD_INTRO: {
                    return new AnimationSoundMeta(sounds.getReloadIntro());
                }
                case RELOAD_LOOP: {
                    return new AnimationSoundMeta(sounds.getReloadLoop());
                }
                case RELOAD_NORMAL_END: {
                    return new AnimationSoundMeta(sounds.getReloadEnd());
                }
                case RELOAD_EMPTY_END: {
                    return new AnimationSoundMeta(sounds.getReloadEndEmpty());
                }
            }
            return super.getSoundFromLabel(item, label);
        }
        return null;
    }

    @Override
    public void runAnimation(GunAnimationController.AnimationLabel label) {
        switch (label) {
            case RELOAD_EMPTY: 
            case RELOAD_NORMAL: {
                super.runAnimation(GunAnimationController.AnimationLabel.RELOAD_INTRO, () -> {
                    if (!this.isAnimationRunning()) {
                        super.runAnimation(GunAnimationController.AnimationLabel.RELOAD_LOOP);
                    }
                });
            }
        }
        super.runAnimation(label);
    }

    @Override
    public void runAnimation(GunAnimationController.AnimationLabel label, Runnable callback) {
        switch (label) {
            case RELOAD_EMPTY: 
            case RELOAD_NORMAL: {
                super.runAnimation(GunAnimationController.AnimationLabel.RELOAD_INTRO, () -> {
                    if (!this.isAnimationRunning()) {
                        super.runAnimation(GunAnimationController.AnimationLabel.RELOAD_LOOP, callback);
                    }
                });
            }
        }
        super.runAnimation(label, callback);
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

