/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.animation.module;

import com.tac.guns.client.render.animation.module.AnimationMeta;
import com.tac.guns.client.render.animation.module.AnimationSoundMeta;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.EntityTickableSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum AnimationSoundManager {
    INSTANCE;

    private final Map<UUID, Map<ResourceLocation, ISound>> soundsMap = new HashMap<UUID, Map<ResourceLocation, ISound>>();

    public void playerSound(PlayerEntity player, AnimationMeta animationMeta, AnimationSoundMeta soundMeta) {
        EntityTickableSound entityTickableSound;
        Map map = this.soundsMap.computeIfAbsent(player.func_110124_au(), k -> new HashMap());
        ISound sound = (ISound)map.get(animationMeta.getResourceLocation());
        if (sound == null) {
            SoundEvent soundEvent = new SoundEvent(soundMeta.getResourceLocation());
            sound = new EntityTickableSound(soundEvent, SoundCategory.PLAYERS, (Entity)player);
        }
        if (sound instanceof EntityTickableSound && (entityTickableSound = (EntityTickableSound)sound).func_147667_k()) {
            SoundEvent soundEvent = new SoundEvent(soundMeta.getResourceLocation());
            sound = new EntityTickableSound(soundEvent, SoundCategory.PLAYERS, (Entity)player);
        }
        if (Minecraft.func_71410_x().func_147118_V().func_215294_c(sound)) {
            return;
        }
        Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
        map.put(animationMeta.getResourceLocation(), sound);
    }

    public void onPlayerDeath(PlayerEntity player) {
        Map map = this.soundsMap.computeIfAbsent(player.func_110124_au(), k -> new HashMap());
        for (ISound sound : map.values()) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(sound);
        }
        this.soundsMap.remove(player.func_110124_au());
    }

    public void interruptSound(PlayerEntity player, AnimationMeta animationMeta) {
        Map<ResourceLocation, ISound> map = this.soundsMap.get(player.func_110124_au());
        if (map != null) {
            ISound sound = map.get(animationMeta.getResourceLocation());
            if (sound != null) {
                Minecraft.func_71410_x().func_147118_V().func_147683_b(sound);
            }
            map.remove(animationMeta.getResourceLocation());
        }
    }
}

