/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.animation;

import com.tac.guns.GunMod;
import com.tac.guns.client.render.animation.module.AnimationMeta;
import com.tac.guns.client.render.animation.module.AnimationSoundMeta;
import com.tac.guns.client.render.animation.module.Animations;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import com.tac.guns.client.render.animation.module.MachineGunAnimationController;
import com.tac.guns.common.Gun;
import com.tac.guns.init.ModItems;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class M60AnimationController
extends MachineGunAnimationController {
    public static int INDEX_BODY = 4;
    public static int INDEX_LEFT_HAND = 8;
    public static int INDEX_RIGHT_HAND = 5;
    public static int INDEX_MAGAZINE = 1;
    public static int INDEX_CHAIN = 0;
    public static int INDEX_CAPS = 2;
    public static int INDEX_HANDLE = 3;
    public static final AnimationMeta STATIC = new AnimationMeta(new ResourceLocation("tac", "animations/m60_static.gltf"));
    public static final AnimationMeta RELOAD_NORM = new AnimationMeta(new ResourceLocation("tac", "animations/m60_reload_norm.gltf"));
    public static final AnimationMeta RELOAD_EMPTY = new AnimationMeta(new ResourceLocation("tac", "animations/m60_reload_empty.gltf"));
    public static final AnimationMeta RELOAD_NORM_SCOPE = new AnimationMeta(new ResourceLocation("tac", "animations/m60_reload_norm_scope.gltf"));
    public static final AnimationMeta RELOAD_EMPTY_SCOPE = new AnimationMeta(new ResourceLocation("tac", "animations/m60_reload_empty_scope.gltf"));
    public static final AnimationMeta DRAW = new AnimationMeta(new ResourceLocation("tac", "animations/m60_draw.gltf"));
    public static final AnimationMeta INSPECT = new AnimationMeta(new ResourceLocation("tac", "animations/m60_inspect.gltf"));
    public static final AnimationMeta INSPECT_EMPTY = new AnimationMeta(new ResourceLocation("tac", "animations/m60_inspect.gltf"));
    private static final M60AnimationController instance = new M60AnimationController();

    private M60AnimationController() {
        try {
            Animations.load(RELOAD_NORM);
            Animations.load(RELOAD_EMPTY);
            Animations.load(RELOAD_NORM_SCOPE);
            Animations.load(RELOAD_EMPTY_SCOPE);
            Animations.load(DRAW);
            Animations.load(INSPECT);
            Animations.load(INSPECT_EMPTY);
            Animations.load(STATIC);
        }
        catch (IOException e) {
            GunMod.LOGGER.fatal((Object)e.getStackTrace());
        }
        this.enableStaticState();
        GunAnimationController.setAnimationControllerMap(ModItems.M60.getId(), this);
    }

    public static M60AnimationController getInstance() {
        return instance;
    }

    @Override
    public AnimationMeta getAnimationFromLabel(GunAnimationController.AnimationLabel label) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        switch (label) {
            case RELOAD_EMPTY: {
                if (player != null) {
                    ItemStack stack = player.func_184614_ca();
                    if (Gun.getScope(stack) == null) {
                        return RELOAD_EMPTY;
                    }
                    return RELOAD_EMPTY_SCOPE;
                }
                return RELOAD_EMPTY;
            }
            case RELOAD_NORMAL: {
                if (player != null) {
                    ItemStack stack = player.func_184614_ca();
                    if (Gun.getScope(stack) == null) {
                        return RELOAD_NORM;
                    }
                    return RELOAD_NORM_SCOPE;
                }
                return RELOAD_NORM;
            }
            case DRAW: {
                return DRAW;
            }
            case INSPECT: {
                return INSPECT;
            }
            case INSPECT_EMPTY: {
                return INSPECT_EMPTY;
            }
            case STATIC: {
                return STATIC;
            }
        }
        return null;
    }

    @Override
    protected void enableStaticState() {
        try {
            Animations.specifyInitialModel(RELOAD_NORM_SCOPE, STATIC);
            Animations.specifyInitialModel(RELOAD_EMPTY_SCOPE, STATIC);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.enableStaticState();
    }

    @Override
    public AnimationSoundMeta getSoundFromLabel(GunAnimationController.AnimationLabel label) {
        return super.getSoundFromLabel((Item)ModItems.M60.get(), label);
    }

    @Override
    protected int getAttachmentsNodeIndex() {
        return INDEX_CAPS;
    }

    @Override
    protected int getRightHandNodeIndex() {
        return INDEX_RIGHT_HAND;
    }

    @Override
    protected int getLeftHandNodeIndex() {
        return INDEX_LEFT_HAND;
    }
}

