/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL43;

@Mod.EventBusSubscriber(modid="tac", value={Dist.CLIENT})
public class ScreenTextureState
extends RenderState.TexturingState {
    private static ScreenTextureState instance = null;
    private int textureId;
    private int lastWindowWidth;
    private int lastWindowHeight;

    public static ScreenTextureState instance() {
        return instance == null ? (instance = new ScreenTextureState()) : instance;
    }

    private ScreenTextureState() {
        super("screen_texture", () -> {
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableTexture();
            RenderSystem.bindTexture((int)ScreenTextureState.instance().getTextureId());
        }, () -> {
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
        });
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::onRenderWorldLast);
    }

    private int getTextureId() {
        if (this.textureId == 0) {
            this.textureId = TextureUtil.func_225678_a_();
            RenderSystem.bindTexture((int)this.textureId);
            GL43.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL43.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        return this.textureId;
    }

    private void onRenderWorldLast(RenderWorldLastEvent event) {
        MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
        if (mainWindow.func_198105_m() <= 0 || mainWindow.func_198083_n() <= 0) {
            return;
        }
        RenderSystem.bindTexture((int)this.getTextureId());
        if (mainWindow.func_198105_m() != this.lastWindowWidth || mainWindow.func_198083_n() != this.lastWindowHeight) {
            this.lastWindowWidth = mainWindow.func_198105_m();
            this.lastWindowHeight = mainWindow.func_198083_n();
            GL43.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)0, (int)0, (int)mainWindow.func_198109_k(), (int)mainWindow.func_198091_l(), (int)0);
        } else {
            GL43.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)mainWindow.func_198109_k(), (int)mainWindow.func_198091_l());
        }
    }

    public void SetImageFromOptifine() {
        MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
        if (mainWindow.func_198105_m() <= 0 || mainWindow.func_198083_n() <= 0) {
            return;
        }
        RenderSystem.bindTexture((int)this.getTextureId());
        if (mainWindow.func_198105_m() != this.lastWindowWidth || mainWindow.func_198083_n() != this.lastWindowHeight) {
            this.lastWindowWidth = mainWindow.func_198105_m();
            this.lastWindowHeight = mainWindow.func_198083_n();
            GL43.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)0, (int)0, (int)mainWindow.func_198109_k(), (int)mainWindow.func_198091_l(), (int)0);
        } else {
            GL43.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)mainWindow.func_198109_k(), (int)mainWindow.func_198091_l());
        }
    }
}

