/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler.command;

import com.google.gson.GsonBuilder;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.InputHandler;
import com.tac.guns.client.handler.command.data.ScopeData;
import com.tac.guns.common.Gun;
import com.tac.guns.common.tooling.CommandsHandler;
import com.tac.guns.item.TransitionalTypes.TimelessGunItem;
import com.tac.guns.item.attachment.impl.Scope;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="tac", value={Dist.CLIENT})
public class ScopeEditor {
    private static ScopeEditor instance;
    public HashMap<String, ScopeData> map = new HashMap();
    private ScopeData scopeData;

    public static ScopeEditor get() {
        if (instance == null) {
            instance = new ScopeEditor();
        }
        return instance;
    }

    private ScopeEditor() {
    }

    public ScopeData getScopeData() {
        return this.scopeData;
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (!((Boolean)Config.COMMON.development.enableTDev.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        CommandsHandler ch = CommandsHandler.get();
        if (ch == null || ch.getCatCurrentIndex() != 2) {
            return;
        }
        if (mc.field_71439_g.func_184614_ca() == null || mc.field_71439_g.func_184614_ca() == ItemStack.field_190927_a || !(mc.field_71439_g.func_184614_ca().func_77973_b() instanceof TimelessGunItem)) {
            return;
        }
        if (((TimelessGunItem)mc.field_71439_g.func_184614_ca().func_77973_b()).isIntegratedOptic().booleanValue()) {
            if (!this.map.containsKey(mc.field_71439_g.func_184614_ca().func_77973_b().func_77658_a())) {
                this.map.put(mc.field_71439_g.func_184614_ca().func_77973_b().func_77658_a(), new ScopeData(mc.field_71439_g.func_184614_ca().func_77973_b().func_77658_a()));
            }
            this.handleScopeMod(event, this.map.get(mc.field_71439_g.func_184614_ca().func_77973_b().func_77658_a()));
            this.scopeData = this.map.get(mc.field_71439_g.func_184614_ca().func_77973_b().func_77658_a());
        } else {
            Scope scopeItem = Gun.getScope(mc.field_71439_g.func_184614_ca());
            if (scopeItem == null) {
                return;
            }
            if (!this.map.containsKey(scopeItem.getTagName())) {
                this.map.put(scopeItem.getTagName(), new ScopeData(scopeItem.getTagName()));
            }
            this.handleScopeMod(event, this.map.get(scopeItem.getTagName()));
            this.scopeData = this.map.get(scopeItem.getTagName());
        }
    }

    private void handleScopeMod(InputEvent.KeyInputEvent event, ScopeData data) {
        boolean isAltDown;
        double stepModifier = 1.0;
        boolean isLeft = InputHandler.LEFT.down;
        boolean isRight = InputHandler.RIGHT.down;
        boolean isUp = InputHandler.UP.down;
        boolean isDown = InputHandler.DOWN.down;
        boolean isControlDown = InputHandler.CONTROLLY.down || InputHandler.CONTROLLYR.down;
        boolean isShiftDown = InputHandler.SHIFTY.down || InputHandler.SHIFTYR.down;
        boolean bl = isAltDown = InputHandler.ALTY.down || InputHandler.ALTYR.down;
        if (isShiftDown) {
            stepModifier *= 10.0;
        }
        if (isControlDown) {
            stepModifier /= 10.0;
        }
        boolean isPeriodDown = InputHandler.SIZE_OPT.down;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (InputHandler.P.down) {
            if (isShiftDown) {
                stepModifier *= 10.0;
            }
            if (isControlDown) {
                stepModifier /= 10.0;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("DR X: " + data.getDrXZoomMod() + " | DR Y: " + data.getDrYZoomMod() + " | DR Z: " + data.getDrZZoomMod()), true);
            if (isAltDown && isUp) {
                data.setDrZZoomMod(data.getDrZZoomMod() + 0.025 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("DR Z: " + data.getDrZZoomMod()).func_240699_a_(TextFormatting.GREEN), true);
            } else if (isAltDown && isDown) {
                data.setDrZZoomMod(data.getDrZZoomMod() - 0.025 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("DR Z: " + data.getDrZZoomMod()).func_240699_a_(TextFormatting.DARK_RED), true);
            } else if (isPeriodDown && isUp) {
                data.setDrZoomSizeMod((float)((double)data.getDrZoomSizeMod() + (double)0.0075f * (stepModifier *= 10.0)));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("DR Size: " + data.getDrZoomSizeMod()).func_240699_a_(TextFormatting.GREEN), true);
            } else if (isPeriodDown && isDown) {
                data.setDrZoomSizeMod((float)((double)data.getDrZoomSizeMod() - (double)0.0075f * (stepModifier *= 10.0)));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("DR Size: " + data.getDrZoomSizeMod()).func_240699_a_(TextFormatting.DARK_RED), true);
            } else if (isUp) {
                data.setDrYZoomMod(data.getDrYZoomMod() + 0.025 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("DR Y: " + data.getDrYZoomMod()).func_240699_a_(TextFormatting.GREEN), true);
            } else if (isDown) {
                data.setDrYZoomMod(data.getDrYZoomMod() - 0.025 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("DR Y: " + data.getDrYZoomMod()).func_240699_a_(TextFormatting.DARK_RED), true);
            } else if (isLeft) {
                data.setDrXZoomMod(data.getDrXZoomMod() + 0.025 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("DR X: " + data.getDrXZoomMod()).func_240699_a_(TextFormatting.GREEN), true);
            } else if (isRight) {
                data.setDrXZoomMod(data.getDrXZoomMod() - 0.025 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("DR X: " + data.getDrXZoomMod()).func_240699_a_(TextFormatting.DARK_RED), true);
            }
        } else if (InputHandler.L.down) {
            if (isShiftDown) {
                stepModifier *= 5.0;
            }
            if (isControlDown) {
                stepModifier /= 20.0;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("Reticle X: " + data.getDrXZoomMod() + " | Reticle Y: " + data.getDrYZoomMod() + " | Reticle Z: " + data.getDrZZoomMod() + " | Reticle Size: " + data.getReticleSizeMod()), true);
            if (isAltDown && isUp) {
                data.setReticleZMod(data.getReticleZMod() + 2.5E-4 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Reticle Z: " + data.getReticleZMod()).func_240699_a_(TextFormatting.GREEN), true);
            } else if (isAltDown && isDown) {
                data.setReticleZMod(data.getReticleZMod() - 2.5E-4 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Reticle Z: " + data.getReticleZMod()).func_240699_a_(TextFormatting.DARK_RED), true);
            } else if (isPeriodDown && isUp) {
                data.setReticleSizeMod((float)((double)data.getReticleSizeMod() + (double)0.0075f * stepModifier));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Reticle Size: " + data.getReticleSizeMod()).func_240699_a_(TextFormatting.GREEN), true);
            } else if (isPeriodDown && isDown) {
                data.setReticleSizeMod((float)((double)data.getReticleSizeMod() - (double)0.0075f * stepModifier));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Reticle Size: " + data.getReticleSizeMod()).func_240699_a_(TextFormatting.DARK_RED), true);
            } else if (isUp) {
                data.setReticleYMod(data.getReticleYMod() + 2.5E-4 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Reticle Y: " + data.getReticleYMod()).func_240699_a_(TextFormatting.GREEN), true);
            } else if (isDown) {
                data.setReticleYMod(data.getReticleYMod() - 2.5E-4 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Reticle Y: " + data.getReticleYMod()).func_240699_a_(TextFormatting.DARK_RED), true);
            } else if (isLeft) {
                data.setReticleXMod(data.getReticleXMod() - 2.5E-4 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Reticle X: " + data.getReticleXMod()).func_240699_a_(TextFormatting.GREEN), true);
            } else if (isRight) {
                data.setReticleXMod(data.getReticleXMod() + 2.5E-4 * stepModifier);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Reticle X: " + data.getReticleXMod()).func_240699_a_(TextFormatting.DARK_RED), true);
            }
        } else if (InputHandler.M.down) {
            if (isShiftDown) {
                stepModifier *= 10.0;
            }
            if (isControlDown) {
                stepModifier /= 10.0;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("Crop: " + data.getDrZoomCropMod() + " | FOV zoom: " + data.getAdditionalZoomMod()), true);
            if (isUp) {
                data.setDrZoomCropMod((float)((double)data.getDrZoomCropMod() + 0.025 * stepModifier));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Crop: " + data.getDrZoomCropMod()).func_240699_a_(TextFormatting.GREEN), true);
            } else if (isDown) {
                data.setDrZoomCropMod((float)((double)data.getDrZoomCropMod() - 0.025 * stepModifier));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Crop: " + data.getDrZoomCropMod()).func_240699_a_(TextFormatting.DARK_RED), true);
            } else if (isLeft) {
                data.setAdditionalZoomMod((float)((double)data.getAdditionalZoomMod() - 0.025 * stepModifier));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("FOV zoom: " + data.getAdditionalZoomMod()).func_240699_a_(TextFormatting.GREEN), true);
            } else if (isRight) {
                data.setAdditionalZoomMod((float)((double)data.getAdditionalZoomMod() + 0.025 * stepModifier));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("FOV zoom: " + data.getAdditionalZoomMod()).func_240699_a_(TextFormatting.DARK_RED), true);
            }
        }
    }

    public void resetData() {
    }

    public void exportData() {
        this.map.forEach((name, scope) -> {
            if (this.map.get(name) == null) {
                GunMod.LOGGER.log(Level.ERROR, "SCOPE EDITOR FAILED TO EXPORT THIS BROKEN DATA. CONTACT CLUMSYALIEN.");
                return;
            }
            GsonBuilder gsonB = new GsonBuilder().setLenient().addSerializationExclusionStrategy(Gun.strategy).setPrettyPrinting();
            String jsonString = gsonB.create().toJson(scope);
            this.writeExport(jsonString, (String)name);
        });
    }

    private void writeExport(String jsonString, String name) {
        try {
            File dir = new File((String)Config.COMMON.development.TDevPath.get() + "\\tac_export\\scope_export");
            dir.mkdir();
            FileWriter dataWriter = new FileWriter(dir.getAbsolutePath() + "\\" + name + "_export.json");
            dataWriter.write(jsonString);
            dataWriter.close();
            GunMod.LOGGER.log(Level.INFO, "SCOPE EDITOR EXPORTED FILE ( " + name + "export.txt ). BE PROUD!");
        }
        catch (IOException e) {
            GunMod.LOGGER.log(Level.ERROR, "SCOPE EDITOR FAILED TO EXPORT, NO FILE CREATED!!! NO ACCESS IN PATH?. CONTACT CLUMSYALIEN.");
        }
    }
}

