/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler.command;

import com.google.gson.GsonBuilder;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.InputHandler;
import com.tac.guns.common.Gun;
import com.tac.guns.common.tooling.CommandsHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class GuiEditor {
    private static GuiEditor instance;
    public int currElement = 0;
    private HashMap<Integer, GUI_Element> elements = new HashMap();

    public static GuiEditor get() {
        if (instance == null) {
            instance = new GuiEditor();
        }
        return instance;
    }

    private GuiEditor() {
    }

    public GUI_Element GetFromElements(int index) {
        return this.elements.get(index);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onKeyPressed(GuiScreenEvent.KeyboardKeyEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (!((Boolean)Config.COMMON.development.enableTDev.get()).booleanValue() && CommandsHandler.get().getCatCurrentIndex() == 3) {
            return;
        }
        if (event.getKeyCode() == 49) {
            this.currElement = 1;
            event.setCanceled(true);
            return;
        }
        if (event.getKeyCode() == 50) {
            this.currElement = 2;
            event.setCanceled(true);
            return;
        }
        if (event.getKeyCode() == 51) {
            this.currElement = 3;
            event.setCanceled(true);
            return;
        }
        if (event.getKeyCode() == 52) {
            this.currElement = 4;
            event.setCanceled(true);
            return;
        }
        if (event.getKeyCode() == 53) {
            this.currElement = 5;
            event.setCanceled(true);
            return;
        }
        if (event.getKeyCode() == 54) {
            this.currElement = 6;
            event.setCanceled(true);
            return;
        }
        if (event.getKeyCode() == 55) {
            this.currElement = 7;
            event.setCanceled(true);
            return;
        }
        if (event.getKeyCode() == 56) {
            this.currElement = 8;
            event.setCanceled(true);
            return;
        }
        if (event.getKeyCode() == 57) {
            this.currElement = 9;
            event.setCanceled(true);
            return;
        }
        boolean isLeft = event.getKeyCode() == 263;
        boolean isRight = event.getKeyCode() == 262;
        boolean isUp = event.getKeyCode() == 265;
        boolean isDown = event.getKeyCode() == 264;
        boolean isShiftDown = InputHandler.SHIFTY.down;
        boolean isPeriodDown = InputHandler.SIZE_OPT.down;
        GUI_Element element = this.elements.size() == 0 || !this.elements.containsKey(this.currElement) ? new GUI_Element(0.0, 0.0, 0.0, 0.0) : this.elements.get(this.currElement);
        double xMod = element.xMod;
        double yMod = element.yMod;
        double sizeXMod = element.sizeXMod;
        double sizeYMod = element.sizeYMod;
        if (isPeriodDown && isUp) {
            sizeYMod += isPeriodDown ? 2.5 : 0.5;
        } else if (isPeriodDown && isDown) {
            sizeYMod -= isPeriodDown ? 2.5 : 0.5;
        } else if (isPeriodDown && isRight) {
            sizeXMod += isPeriodDown ? 2.5 : 0.5;
        } else if (isPeriodDown && isLeft) {
            sizeXMod -= isPeriodDown ? 2.5 : 0.5;
        } else if (isLeft) {
            xMod -= isShiftDown ? 2.5 : 0.5;
        } else if (isRight) {
            xMod += isShiftDown ? 2.5 : 0.5;
        } else if (isUp) {
            yMod -= isShiftDown ? 2.5 : 0.5;
        } else if (isDown) {
            yMod += isShiftDown ? 2.5 : 0.5;
        }
        this.elements.put(this.currElement, new GUI_Element(xMod, yMod, sizeXMod, sizeYMod));
    }

    public void exportData() {
        this.elements.forEach((name, data) -> {
            if (this.elements.get(name) == null) {
                GunMod.LOGGER.log(Level.ERROR, "GUI EDITOR FAILED TO EXPORT THIS BROKEN DATA. CONTACT CLUMSYALIEN.");
                return;
            }
            GsonBuilder gsonB = new GsonBuilder().setLenient().addSerializationExclusionStrategy(Gun.strategy).setPrettyPrinting();
            String jsonString = gsonB.create().toJson(data);
            this.writeExport(jsonString, "gui_" + name);
        });
    }

    private void writeExport(String jsonString, String name) {
        try {
            File dir = new File((String)Config.COMMON.development.TDevPath.get() + "\\tac_export\\");
            dir.mkdir();
            FileWriter dataWriter = new FileWriter(dir.getAbsolutePath() + "\\" + name + "_export.json");
            dataWriter.write(jsonString);
            dataWriter.close();
            GunMod.LOGGER.log(Level.INFO, "WEAPON EDITOR EXPORTED FILE ( " + name + "export.txt ). BE PROUD!");
        }
        catch (IOException e) {
            GunMod.LOGGER.log(Level.ERROR, "WEAPON EDITOR FAILED TO EXPORT, NO FILE CREATED!!! NO ACCESS IN PATH?. CONTACT CLUMSYALIEN.");
        }
    }

    public static class GUI_Element {
        private double xMod = 0.0;
        private double yMod = 0.0;
        private double sizeXMod = 0.0;
        private double sizeYMod = 0.0;

        public GUI_Element(double x, double y, double sizeX, double sizeY) {
            this.xMod = x;
            this.yMod = y;
            this.sizeXMod = sizeX;
            this.sizeYMod = sizeY;
        }

        public int getxMod() {
            return (int)this.xMod;
        }

        public int getyMod() {
            return (int)this.yMod;
        }

        public int getSizeXMod() {
            return (int)this.sizeYMod;
        }

        public int getSizeYMod() {
            return (int)this.sizeXMod;
        }
    }
}

