/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.tac.guns.Config;
import com.tac.guns.client.InputHandler;
import com.tac.guns.client.handler.AimingHandler;
import com.tac.guns.client.handler.GunRenderingHandler;
import com.tac.guns.client.handler.HUDRenderingHandler;
import com.tac.guns.client.handler.RecoilHandler;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import com.tac.guns.common.Gun;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.TransitionalTypes.TimelessGunItem;
import com.tac.guns.mixin.client.MinecraftStaticMixin;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageEmptyMag;
import com.tac.guns.network.message.MessageShoot;
import com.tac.guns.network.message.MessageShooting;
import com.tac.guns.network.message.MessageUpdateMoveInacc;
import com.tac.guns.util.GunModifierHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ShootingHandler {
    private static ShootingHandler instance;
    private boolean shooting;
    private boolean shootErr;
    private boolean clickUp = false;
    public int burstTracker = 0;
    private int burstCooldown = 0;
    private static float shootTickGapLeft;
    public static float shootMsGap;

    public static ShootingHandler get() {
        if (instance == null) {
            instance = new ShootingHandler();
        }
        return instance;
    }

    public boolean isShooting() {
        return this.shooting;
    }

    public void setShooting(boolean shooting) {
        this.shooting = shooting;
    }

    public void setShootingError(boolean shootErr) {
        this.shootErr = shootErr;
    }

    private ShootingHandler() {
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!this.isInGame()) {
            return;
        }
        this.burstTracker = 0;
        this.burstCooldown = 0;
        this.clickUp = false;
        this.shootErr = false;
    }

    private boolean isInGame() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return false;
        }
        if (mc.field_213279_p != null) {
            return false;
        }
        if (mc.field_71462_r != null) {
            return false;
        }
        if (!mc.field_71417_B.func_198035_h()) {
            return false;
        }
        return mc.func_195544_aj();
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.RawMouseEvent event) {
        if (!this.isInGame()) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof GunItem) {
            int button = event.getButton();
            if (button == 0 || button == 1 && AimingHandler.get().isLookingAtInteractableBlock()) {
                event.setCanceled(true);
            }
            if (InputHandler.PULL_TRIGGER.down) {
                if (this.magError((PlayerEntity)player, heldItem)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("info.tac.mag_error").func_240699_a_(TextFormatting.UNDERLINE).func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.RED), true);
                    PacketHandler.getPlayChannel().sendToServer((Object)new MessageEmptyMag());
                    return;
                }
                if (heldItem.func_77973_b() instanceof TimelessGunItem && heldItem.func_77978_p().func_74762_e("CurrentFireMode") == 3 && this.burstCooldown == 0) {
                    this.burstTracker = ((TimelessGunItem)heldItem.func_77973_b()).getGun().getGeneral().getBurstCount();
                    this.fire((PlayerEntity)player, heldItem);
                    this.burstCooldown = ((TimelessGunItem)heldItem.func_77973_b()).getGun().getGeneral().getBurstRate();
                } else if (this.burstCooldown == 0) {
                    this.fire((PlayerEntity)player, heldItem);
                }
                if (heldItem.func_77978_p().func_74762_e("AmmoCount") <= 0) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("info.tac.out_of_ammo").func_240699_a_(TextFormatting.UNDERLINE).func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.RED), true);
                    PacketHandler.getPlayChannel().sendToServer((Object)new MessageEmptyMag());
                }
            }
        }
    }

    public float getShootTickGapLeft() {
        return shootTickGapLeft;
    }

    public float getshootMsGap() {
        return shootMsGap;
    }

    public static float calcShootTickGap(int rpm) {
        float shootTickGap = 60.0f / (float)rpm * 20.0f;
        return shootTickGap;
    }

    private static float hitmarkerCooldownMultiplier() {
        int fps = ((MinecraftStaticMixin)Minecraft.func_71410_x()).getCurrentFPS();
        if (fps < 11) {
            return 16.0f;
        }
        if (fps < 21) {
            return 14.5f;
        }
        if (fps < 31) {
            return 4.0f;
        }
        if (fps < 61) {
            return 2.0f;
        }
        if (fps < 121) {
            return 1.0f;
        }
        if (fps < 181) {
            return 0.7f;
        }
        if (fps < 201) {
            return 0.5f;
        }
        return 0.375f;
    }

    private static float visualCooldownMultiplier() {
        int fps = ((MinecraftStaticMixin)Minecraft.func_71410_x()).getCurrentFPS();
        if (fps < 11) {
            return 8.0f;
        }
        if (fps < 21) {
            return 6.25f;
        }
        if (fps < 31) {
            return 1.25f;
        }
        if (fps < 61) {
            return 0.95f;
        }
        if (fps < 121) {
            return 0.625f;
        }
        if (fps < 181) {
            return 0.425f;
        }
        if (fps < 201) {
            return 0.35f;
        }
        return 0.25f;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderTickLow(TickEvent.RenderTickEvent evt) {
        if (!evt.type.equals((Object)TickEvent.Type.RENDER) || evt.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        HUDRenderingHandler.get().hitMarkerTracker = ((Boolean)Config.CLIENT.display.showHitMarkers.get()).booleanValue() && HUDRenderingHandler.get().hitMarkerTracker > 0.0f ? (HUDRenderingHandler.get().hitMarkerTracker -= evt.renderTickTime * ShootingHandler.hitmarkerCooldownMultiplier()) : 0.0f;
        if (shootMsGap > 0.0f) {
            shootMsGap -= evt.renderTickTime * ShootingHandler.visualCooldownMultiplier();
        } else if (shootMsGap < -0.05f) {
            shootMsGap = 0.0f;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderTick(TickEvent.RenderTickEvent evt) {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71439_g.func_70089_S() || Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof GunItem) {
            return;
        }
        GunAnimationController controller = GunAnimationController.fromItem(Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b());
        if (controller == null) {
            return;
        }
        if (controller.isAnimationRunning() && shootMsGap < 0.0f && this.burstTracker != 0) {
            if (controller.isAnimationRunning(GunAnimationController.AnimationLabel.PUMP) || controller.isAnimationRunning(GunAnimationController.AnimationLabel.PULL_BOLT)) {
                return;
            }
            if (((Boolean)Config.CLIENT.controls.burstPress.get()).booleanValue()) {
                this.burstTracker = 0;
            }
            this.clickUp = true;
        }
    }

    @SubscribeEvent
    public void onHandleShooting(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        if (!this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null) {
            shootTickGapLeft -= shootTickGapLeft > 0.0f ? 1.0f : 0.0f;
            ItemStack heldItem = player.func_184614_ca();
            if (heldItem.func_77973_b() instanceof GunItem && (Gun.hasAmmo(heldItem) || player.func_184812_l_()) && !this.magError((PlayerEntity)player, heldItem)) {
                boolean shooting;
                float dist = Math.abs(player.field_191988_bg) / 2.5f + Math.abs(player.field_70702_br) / 1.25f + (player.func_213322_ci().field_72448_b > 0.0 ? 0.5f : 0.0f);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageUpdateMoveInacc(dist));
                boolean bl = shooting = InputHandler.PULL_TRIGGER.down && GunRenderingHandler.get().sprintTransition == 0;
                if (shooting ^ this.shooting) {
                    this.shooting = shooting;
                    PacketHandler.getPlayChannel().sendToServer((Object)new MessageShooting(shooting));
                }
            } else if (this.shooting) {
                this.shooting = false;
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageShooting(false));
            }
        } else {
            this.shooting = false;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null && this.burstCooldown > 0) {
            --this.burstCooldown;
        }
    }

    @SubscribeEvent
    public void onPostClientTick(TickEvent.ClientTickEvent event) {
        ItemStack heldItem;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!this.isInGame()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null && (heldItem = player.func_184614_ca()).func_77973_b() instanceof TimelessGunItem) {
            if (heldItem.func_77978_p() == null) {
                heldItem.func_196082_o();
                return;
            }
            TimelessGunItem gunItem = (TimelessGunItem)heldItem.func_77973_b();
            if (heldItem.func_77978_p().func_74762_e("CurrentFireMode") == 3 && ((Boolean)Config.CLIENT.controls.burstPress.get()).booleanValue()) {
                if (this.burstTracker > 0) {
                    this.fire((PlayerEntity)player, heldItem);
                }
                return;
            }
            if (InputHandler.PULL_TRIGGER.down) {
                Gun gun = ((TimelessGunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
                if (gun.getGeneral().isAuto() && heldItem.func_77978_p().func_74762_e("CurrentFireMode") == 2) {
                    this.fire((PlayerEntity)player, heldItem);
                    return;
                }
                if (heldItem.func_77978_p().func_74762_e("CurrentFireMode") == 3 && !((Boolean)Config.CLIENT.controls.burstPress.get()).booleanValue() && !this.clickUp && this.burstCooldown == 0) {
                    if (this.burstTracker < gun.getGeneral().getBurstCount()) {
                        if (ShootingHandler.get().getshootMsGap() <= 0.0f) {
                            this.fire((PlayerEntity)player, heldItem);
                            if (!this.shootErr) {
                                ++this.burstTracker;
                            }
                        }
                    } else if (heldItem.func_77978_p().func_74762_e("AmmoCount") > 0 && this.burstTracker > 0) {
                        this.burstTracker = 0;
                        this.clickUp = true;
                        this.burstCooldown = gun.getGeneral().getBurstRate();
                    }
                    return;
                }
            } else if (this.clickUp) {
                if (heldItem.func_77978_p().func_74762_e("CurrentFireMode") == 3 && this.burstTracker > 0) {
                    this.burstCooldown = gunItem.getGun().getGeneral().getBurstRate();
                }
                this.burstTracker = 0;
                this.clickUp = false;
            }
        }
    }

    public void fire(PlayerEntity player, ItemStack heldItem) {
        if (this.magError(player, heldItem)) {
            return;
        }
        if (!(heldItem.func_77973_b() instanceof GunItem)) {
            return;
        }
        if (!Gun.hasAmmo(heldItem) && !player.func_184812_l_()) {
            return;
        }
        if (player.func_175149_v()) {
            return;
        }
        player.func_70031_b(false);
        if (GunRenderingHandler.get().sprintTransition != 0) {
            this.shooting = false;
            return;
        }
        if (shootTickGapLeft <= 0.0f) {
            GunItem gunItem = (GunItem)heldItem.func_77973_b();
            Gun modifiedGun = gunItem.getModifiedGun(heldItem);
            if (MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Pre(player, heldItem))) {
                return;
            }
            float rpm = modifiedGun.getGeneral().getRate();
            shootTickGapLeft += ShootingHandler.calcShootTickGap((int)rpm);
            shootMsGap = ShootingHandler.calcShootTickGap((int)rpm);
            RecoilHandler.get().lastRandPitch = RecoilHandler.get().lastRandPitch;
            RecoilHandler.get().lastRandYaw = RecoilHandler.get().lastRandYaw;
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageShoot(player.func_195046_g(1.0f), player.func_195050_f(1.0f), RecoilHandler.get().lastRandPitch, RecoilHandler.get().lastRandYaw));
            this.burstTracker = ((Boolean)Config.CLIENT.controls.burstPress.get()).booleanValue() ? --this.burstTracker : ++this.burstTracker;
            MinecraftForge.EVENT_BUS.post((Event)new GunFireEvent.Post(player, heldItem));
        }
    }

    private boolean magError(PlayerEntity player, ItemStack heldItem) {
        int[] extraAmmo = ((TimelessGunItem)heldItem.func_77973_b()).getGun().getReloads().getMaxAdditionalAmmoPerOC();
        int magMode = GunModifierHelper.getAmmoCapacity(heldItem);
        return magMode < 0 ? heldItem.func_77973_b() instanceof TimelessGunItem && heldItem.func_77978_p().func_74762_e("AmmoCount") - 1 > ((TimelessGunItem)heldItem.func_77973_b()).getGun().getReloads().getMaxAmmo() : heldItem.func_77973_b() instanceof TimelessGunItem && heldItem.func_77978_p().func_74762_e("AmmoCount") - 1 > ((TimelessGunItem)heldItem.func_77973_b()).getGun().getReloads().getMaxAmmo() + extraAmmo[magMode];
    }

    static {
        shootTickGapLeft = 0.0f;
        shootMsGap = 0.0f;
    }
}

