/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.tac.guns.Config;
import com.tac.guns.client.handler.AimingHandler;
import com.tac.guns.common.Gun;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.item.GunItem;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RecoilHandler {
    private static RecoilHandler instance;
    private Random random = new Random();
    private int recoilRand;
    private double gunRecoilNormal;
    private double gunRecoilAngle;
    private double gunHorizontalRecoilAngle;
    public float cameraRecoil;
    private float progressCameraRecoil;
    public float horizontalCameraRecoil;
    private float horizontalProgressCameraRecoil;
    private int timer;
    private long prevTime = System.currentTimeMillis();
    private final int recoilDuration = 200;
    private static Random rand;
    public float lastRandPitch = 0.0f;
    public float lastRandYaw = 0.0f;

    public static RecoilHandler get() {
        if (instance == null) {
            instance = new RecoilHandler();
        }
        return instance;
    }

    private RecoilHandler() {
    }

    @SubscribeEvent
    public void preShoot(GunFireEvent.Pre event) {
        if (!(event.getStack().func_77973_b() instanceof GunItem)) {
            return;
        }
        this.recoilRand = this.random.nextInt(2);
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        if (!((Boolean)Config.SERVER.enableCameraRecoil.get()).booleanValue()) {
            return;
        }
        ItemStack heldItem = event.getStack();
        GunItem gunItem = (GunItem)heldItem.func_77973_b();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        float verticalRandomAmount = this.random.nextFloat() * 0.47000003f + 0.75f;
        float recoilModifier = 1.0f - GunModifierHelper.getRecoilModifier(heldItem);
        recoilModifier = (float)((double)recoilModifier * this.getAdsRecoilReduction(modifiedGun));
        recoilModifier *= GunEnchantmentHelper.getBufferedRecoil(heldItem);
        this.cameraRecoil = modifiedGun.getGeneral().getRecoilAngle() * (recoilModifier *= verticalRandomAmount);
        this.progressCameraRecoil = 0.0f;
        this.lastRandPitch = this.random.nextFloat();
        this.lastRandYaw = this.random.nextFloat();
        float horizontalRandomAmount = this.random.nextFloat() * 0.47000003f + 0.75f;
        float horizontalRecoilModifier = 1.0f - GunModifierHelper.getHorizontalRecoilModifier(heldItem);
        horizontalRecoilModifier = (float)((double)horizontalRecoilModifier * this.getAdsRecoilReduction(modifiedGun));
        horizontalRecoilModifier *= GunEnchantmentHelper.getBufferedRecoil(heldItem);
        this.horizontalCameraRecoil = modifiedGun.getGeneral().getHorizontalRecoilAngle() * (horizontalRecoilModifier *= horizontalRandomAmount) * 0.75f;
        this.horizontalProgressCameraRecoil = 0.0f;
        this.timer = 200;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        float progressForward;
        if (this.timer > 0) {
            this.timer = (int)((long)this.timer - (System.currentTimeMillis() - this.prevTime));
        }
        this.prevTime = System.currentTimeMillis();
        if (this.timer < 0) {
            this.timer = 0;
        }
        if (!((Boolean)Config.SERVER.enableCameraRecoil.get()).booleanValue()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END || this.cameraRecoil <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        float cameraRecoilModifer = mc.field_71439_g.func_184614_ca().func_77973_b() instanceof GunItem ? ((GunItem)mc.field_71439_g.func_184614_ca().func_77973_b()).getGun().getGeneral().getCameraRecoilModifier() : 1.0f;
        float recoilAmount = this.cameraRecoil * mc.func_193989_ak() * 0.2f;
        float HorizontalRecoilAmount = this.horizontalCameraRecoil * mc.func_193989_ak() * 0.1f;
        float startProgress = this.progressCameraRecoil / this.cameraRecoil;
        float endProgress = (this.progressCameraRecoil + recoilAmount) / this.cameraRecoil;
        float f = progressForward = mc.field_71439_g.func_184614_ca().func_77973_b() instanceof GunItem ? ((GunItem)mc.field_71439_g.func_184614_ca().func_77973_b()).getGun().getGeneral().getRecoilDuration() * GunModifierHelper.getRecoilSmootheningTime(mc.field_71439_g.func_184614_ca()) : 0.25f;
        if (startProgress < progressForward) {
            mc.field_71439_g.field_70125_A -= (endProgress - startProgress) / progressForward * this.cameraRecoil / cameraRecoilModifer;
            mc.field_71439_g.field_70177_z = this.recoilRand == 1 ? (mc.field_71439_g.field_70177_z -= (endProgress - startProgress) / progressForward * this.horizontalCameraRecoil / cameraRecoilModifer) : (mc.field_71439_g.field_70177_z -= (endProgress - startProgress) / progressForward * -this.horizontalCameraRecoil / cameraRecoilModifer);
        } else if (startProgress > progressForward) {
            mc.field_71439_g.field_70125_A = (float)((double)mc.field_71439_g.field_70125_A + (double)((endProgress - startProgress) / (1.0f - progressForward) * this.cameraRecoil) / ((double)cameraRecoilModifer * 1.025));
            mc.field_71439_g.field_70177_z = this.recoilRand == 1 ? (float)((double)mc.field_71439_g.field_70177_z - (double)((endProgress - startProgress) / (1.0f - progressForward) * -this.horizontalCameraRecoil) / ((double)cameraRecoilModifer * 1.025)) : (float)((double)mc.field_71439_g.field_70177_z - (double)((endProgress - startProgress) / (1.0f - progressForward) * this.horizontalCameraRecoil) / ((double)cameraRecoilModifer * 1.025));
        }
        this.progressCameraRecoil += recoilAmount;
        if (this.progressCameraRecoil >= this.cameraRecoil) {
            this.cameraRecoil = 0.0f;
            this.progressCameraRecoil = 0.0f;
        }
        this.horizontalProgressCameraRecoil += HorizontalRecoilAmount;
        if (this.horizontalProgressCameraRecoil >= this.horizontalCameraRecoil) {
            this.horizontalCameraRecoil = 0.0f;
            this.horizontalProgressCameraRecoil = 0.0f;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderOverlay(RenderHandEvent event) {
        if (event.getHand() != Hand.MAIN_HAND) {
            return;
        }
        ItemStack heldItem = event.getItemStack();
        if (!(heldItem.func_77973_b() instanceof GunItem)) {
            return;
        }
        float cooldown = (float)this.timer / 200.0f;
        GunItem gunItem = (GunItem)heldItem.func_77973_b();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        float recoilTimeOffset = modifiedGun.getGeneral().getWeaponRecoilOffset();
        if (cooldown >= recoilTimeOffset) {
            float amount = 1.0f * ((1.0f - cooldown) / (1.0f - modifiedGun.getGeneral().getWeaponRecoilOffset()));
            this.gunRecoilNormal = 1.0f - (amount -= 1.0f);
        } else {
            float amount = cooldown / modifiedGun.getGeneral().getWeaponRecoilOffset();
            this.gunRecoilNormal = (double)amount < 0.5 ? (double)(2.0f * amount * amount) : (double)(-1.0f + (4.0f - 2.0f * amount) * amount);
        }
        this.gunRecoilAngle = modifiedGun.getGeneral().getRecoilAngle();
        this.gunHorizontalRecoilAngle = modifiedGun.getGeneral().getHorizontalRecoilAngle();
    }

    public double getAdsRecoilReduction(Gun gun) {
        return 1.0 - (double)gun.getGeneral().getRecoilAdsReduction() * AimingHandler.get().getNormalisedAdsProgress();
    }

    public double getGunRecoilNormal() {
        return this.gunRecoilNormal;
    }

    public double getGunRecoilAngle() {
        return this.gunRecoilAngle;
    }

    public double getGunHorizontalRecoilAngle() {
        return this.gunHorizontalRecoilAngle;
    }

    public double getRecoilProgress() {
        return (double)this.timer / 200.0;
    }

    private static Vector3d getVectorFromRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vector3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    static {
        rand = new Random();
    }
}

