/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.tac.guns.client.InputHandler;
import com.tac.guns.client.handler.CrosshairHandler;
import com.tac.guns.client.render.crosshair.Crosshair;
import com.tac.guns.common.Rig;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.TransitionalTypes.wearables.ArmorRigItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageArmorRepair;
import com.tac.guns.util.WearableHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ArmorInteractionHandler {
    private static ArmorInteractionHandler instance;
    private static final double MAX_AIM_PROGRESS = 4.0;
    private double normalisedRepairProgress;
    private boolean repairing = false;
    private int repairTime = -1;
    private int prevRepairTime = 0;

    public static ArmorInteractionHandler get() {
        if (instance == null) {
            instance = new ArmorInteractionHandler();
        }
        return instance;
    }

    private ArmorInteractionHandler() {
        InputHandler.ARMOR_REPAIRING.addPressCallback(() -> {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && WearableHelper.PlayerWornRig((PlayerEntity)mc.field_71439_g) != null && !WearableHelper.isFullDurability(WearableHelper.PlayerWornRig((PlayerEntity)mc.field_71439_g))) {
                this.repairing = true;
                this.repairTime = ((ArmorRigItem)WearableHelper.PlayerWornRig((PlayerEntity)mc.field_71439_g).func_77973_b()).getRig().getRepair().getTicksToRepair();
            }
        });
    }

    public float getRepairProgress(float partialTicks, PlayerEntity player) {
        return this.repairTime != 0 ? ((float)this.prevRepairTime + (float)(this.repairTime - this.prevRepairTime) * partialTicks) / (float)((ArmorRigItem)WearableHelper.PlayerWornRig(player).func_77973_b()).getRig().getRepair().getTicksToRepair() : 1.0f;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        this.prevRepairTime = this.repairTime;
        if (InputHandler.ARMOR_REPAIRING.down && this.repairTime > 0) {
            --this.repairTime;
        } else if (this.repairTime == 0) {
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageArmorRepair(true, true));
            this.repairTime = -1;
            return;
        }
        if (InputHandler.AIM_HOLD.down) {
            if (!this.repairing) {
                SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.QREPAIRING, (Object)true);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageArmorRepair(true, false));
                this.repairing = true;
            }
        } else if (this.repairing && !InputHandler.AIM_HOLD.down) {
            SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.QREPAIRING, (Object)false);
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageArmorRepair(false, false));
            this.repairing = false;
        }
    }

    public void onRenderOverlay(RenderGameOverlayEvent event) {
        Crosshair crosshair = CrosshairHandler.get().getCurrentCrosshair();
        if (this.repairing && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && (crosshair == null || crosshair.isDefault())) {
            event.setCanceled(true);
        }
    }

    public boolean isRepairing() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return false;
        }
        if (mc.field_71439_g.func_175149_v()) {
            return false;
        }
        if (mc.field_71462_r != null) {
            return false;
        }
        if (WearableHelper.PlayerWornRig((PlayerEntity)mc.field_71439_g) == null) {
            return false;
        }
        Rig rig = ((ArmorRigItem)WearableHelper.PlayerWornRig((PlayerEntity)mc.field_71439_g).func_77973_b()).getRig();
        return this.repairTime != 0 && mc.field_71439_g.func_184614_ca().func_77973_b().getRegistryName().equals((Object)rig.getRepair().getItem()) && !WearableHelper.isFullDurability(WearableHelper.PlayerWornRig((PlayerEntity)mc.field_71439_g));
    }

    public double getNormalisedRepairProgress() {
        return this.normalisedRepairProgress;
    }
}

