/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.KeyBind;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="tac", value={Dist.CLIENT})
public final class InputHandler {
    public static final KeyBind PULL_TRIGGER = new KeyBind("key.tac.pull_trigger", 0, InputMappings.Type.MOUSE);
    public static final KeyBind AIM_HOLD = new KeyBind("key.tac.aim_hold", 1, InputMappings.Type.MOUSE);
    public static final KeyBind AIM_TOGGLE = new KeyBind("key.tac.aim_toggle", InputMappings.field_197958_a.func_197937_c(), new InputMappings.Type[0]);
    public static final KeyBind ARMOR_REPAIRING = new KeyBind("key.tac.armor_repairing", 1, InputMappings.Type.MOUSE);
    public static final KeyBind RELOAD = new KeyBind("key.tac.reload", 82, new InputMappings.Type[0]);
    public static final KeyBind UNLOAD = new KeyBind("key.tac.unload", InputMappings.field_197958_a.func_197937_c(), new InputMappings.Type[0]);
    public static final KeyBind ATTACHMENTS = new KeyBind("key.tac.attachments", 90, new InputMappings.Type[0]);
    public static final KeyBind FIRE_SELECT = new KeyBind("key.tac.fireSelect", 71, new InputMappings.Type[0]);
    public static final KeyBind INSPECT = new KeyBind("key.tac.inspect", 72, new InputMappings.Type[0]);
    public static final KeyBind SIGHT_SWITCH = new KeyBind("key.tac.sight_switch", 86, new InputMappings.Type[0]);
    public static final KeyBind ACTIVATE_SIDE_RAIL = new KeyBind("key.tac.activateSideRail", 66, new InputMappings.Type[0]);
    public static final KeyBind MORE_INFO_HOLD = new KeyBind("key.tac.moreInfoHold", 340, new InputMappings.Type[0]);
    public static final KeyBind CO = new KeyBind("key.tac.co", 342, new InputMappings.Type[0]);
    public static final KeyBind CO_UNLOAD = new KeyBind("key.tac.co_unload", 82, new InputMappings.Type[0]);
    public static final KeyBind CO_INSPECT = new KeyBind("key.tac.co_inspect", -1, new InputMappings.Type[0]);
    public static final KeyBind SHIFTY = new KeyBind("key.tac.ss", 340, new InputMappings.Type[0]);
    public static final KeyBind CONTROLLY = new KeyBind("key.tac.cc", 341, new InputMappings.Type[0]);
    public static final KeyBind ALTY = new KeyBind("key.tac.aa", 342, new InputMappings.Type[0]);
    public static final KeyBind SHIFTYR = new KeyBind("key.tac.ssr", 344, new InputMappings.Type[0]);
    public static final KeyBind CONTROLLYR = new KeyBind("key.tac.ccr", 345, new InputMappings.Type[0]);
    public static final KeyBind ALTYR = new KeyBind("key.tac.aar", 346, new InputMappings.Type[0]);
    public static final KeyBind SIZE_OPT = new KeyBind("key.tac.sizer", 46, new InputMappings.Type[0]);
    public static final KeyBind P = new KeyBind("key.tac.p", 80, new InputMappings.Type[0]);
    public static final KeyBind L = new KeyBind("key.tac.l", 76, new InputMappings.Type[0]);
    public static final KeyBind O = new KeyBind("key.tac.o", 79, new InputMappings.Type[0]);
    public static final KeyBind K = new KeyBind("key.tac.k", 75, new InputMappings.Type[0]);
    public static final KeyBind M = new KeyBind("key.tac.m", 77, new InputMappings.Type[0]);
    public static final KeyBind I = new KeyBind("key.tac.i", 73, new InputMappings.Type[0]);
    public static final KeyBind J = new KeyBind("key.tac.j", 74, new InputMappings.Type[0]);
    public static final KeyBind N = new KeyBind("key.tac.n", 78, new InputMappings.Type[0]);
    public static final KeyBind UP = new KeyBind("key.tac.bbb", 265, new InputMappings.Type[0]);
    public static final KeyBind RIGHT = new KeyBind("key.tac.vvv", 262, new InputMappings.Type[0]);
    public static final KeyBind LEFT = new KeyBind("key.tac.ccc", 263, new InputMappings.Type[0]);
    public static final KeyBind DOWN = new KeyBind("key.tac.zzz", 264, new InputMappings.Type[0]);
    private static final ArrayList<KeyBind> GLOBAL_KEYS = new ArrayList();
    private static final ArrayList<KeyBind> INCO_KEYS = new ArrayList();
    private static final ArrayList<KeyBind> CO_KEYS = new ArrayList();
    private static final HashMultimap<InputMappings.Input, KeyBind> GLOBAL_MAPPER = HashMultimap.create();
    private static final HashMultimap<InputMappings.Input, KeyBind> INCO_MAPPER = HashMultimap.create();
    private static final HashMultimap<InputMappings.Input, KeyBind> CO_MAPPER = HashMultimap.create();
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static KeyBind oriAimKey;

    public static void initKeys() {
        InputHandler.regisAll(GLOBAL_KEYS, PULL_TRIGGER, AIM_HOLD, AIM_TOGGLE, CO, ARMOR_REPAIRING);
        InputHandler.regisAll(INCO_KEYS, RELOAD, UNLOAD, ATTACHMENTS, FIRE_SELECT, INSPECT, SIGHT_SWITCH, ACTIVATE_SIDE_RAIL, MORE_INFO_HOLD);
        InputHandler.regisAll(CO_KEYS, CO_UNLOAD, CO_INSPECT);
        if (((Boolean)Config.COMMON.development.enableTDev.get()).booleanValue()) {
            InputHandler.regisAll(GLOBAL_KEYS, SHIFTY, CONTROLLY, ALTY, SHIFTYR, CONTROLLYR, ALTYR, SIZE_OPT, P, L, O, K, M, I, J, N, UP, RIGHT, LEFT, DOWN);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onMouseInput(InputEvent.RawMouseEvent evt) {
        InputMappings.Input button = InputMappings.Type.MOUSE.func_197944_a(evt.getButton());
        boolean down = evt.getAction() == 1;
        GLOBAL_MAPPER.get((Object)button).forEach(kb -> kb.update(down));
        (InputHandler.CO.down ? CO_MAPPER : INCO_MAPPER).get((Object)button).forEach(kb -> kb.update(down));
        (InputHandler.CO.down ? INCO_MAPPER : CO_MAPPER).get((Object)button).forEach(kb -> kb.inactiveUpdate(down));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onKeyInput(InputEvent.KeyInputEvent evt) {
        InputMappings.Input key = InputMappings.Type.KEYSYM.func_197944_a(evt.getKey());
        boolean down = evt.getAction() != 0;
        GLOBAL_MAPPER.get((Object)key).forEach(kb -> kb.update(down));
        (InputHandler.CO.down ? CO_MAPPER : INCO_MAPPER).get((Object)key).forEach(kb -> kb.update(down));
        (InputHandler.CO.down ? INCO_MAPPER : CO_MAPPER).get((Object)key).forEach(kb -> kb.inactiveUpdate(down));
    }

    static void restoreKeyBinds() {
        oriAimKey = AIM_HOLD.keyCode() != InputMappings.field_197958_a ? AIM_HOLD : AIM_TOGGLE;
        KeyBind.REGISTRY.values().forEach(KeyBind::restoreKeyBind);
    }

    static void clearKeyBinds(File file) {
        boolean flag = false;
        for (KeyBind key : KeyBind.REGISTRY.values()) {
            flag |= key.clearKeyBind();
        }
        InputMappings.Input none = InputMappings.field_197958_a;
        if (AIM_HOLD.keyCode() != none && AIM_TOGGLE.keyCode() != none) {
            oriAimKey.setKeyCode(none);
            flag = true;
        }
        KeyBinding.func_74508_b();
        if (flag) {
            InputHandler.updateMappers();
            InputHandler.saveTo(file);
        }
    }

    static void saveTo(File file) {
        try (FileWriter out = new FileWriter(file);){
            HashMap mapper = new HashMap();
            KeyBind.REGISTRY.values().forEach(kb -> mapper.put(kb.name(), "" + kb.keyCode()));
            out.write(GSON.toJson(mapper));
        }
        catch (IOException e) {
            GunMod.LOGGER.error("Fail write key bindings", (Throwable)e);
        }
    }

    static void readFrom(File file) {
        try (FileReader in = new FileReader(file);){
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)in, JsonObject.class);
            obj.entrySet().forEach(e -> {
                try {
                    KeyBind keyBind = KeyBind.REGISTRY.get(e.getKey());
                    InputMappings.Input input = InputMappings.func_197955_a((String)((JsonElement)e.getValue()).getAsString());
                    keyBind.setKeyCode(input);
                }
                catch (NullPointerException ee) {
                    GunMod.LOGGER.error("Key bind " + (String)e.getKey() + " do not exist");
                }
                catch (IllegalArgumentException ee) {
                    GunMod.LOGGER.error("Bad key code: " + e);
                }
            });
        }
        catch (IOException e2) {
            GunMod.LOGGER.error("Fail read key bind", (Throwable)e2);
        }
        InputHandler.updateMappers();
    }

    public static void updateMappers() {
        InputHandler.updateMapper(GLOBAL_KEYS, GLOBAL_MAPPER);
        InputHandler.updateMapper(CO_KEYS, CO_MAPPER);
        InputHandler.updateMapper(INCO_KEYS, INCO_MAPPER);
    }

    private static void updateMapper(Collection<KeyBind> group, Multimap<InputMappings.Input, KeyBind> mapper) {
        mapper.clear();
        group.forEach(kb -> {
            InputMappings.Input code = kb.keyCode();
            if (code != InputMappings.field_197958_a) {
                mapper.put((Object)code, kb);
            }
        });
    }

    private static void regisAll(Collection<KeyBind> updateGroup, KeyBind ... keys) {
        List<KeyBind> keyList = Arrays.asList(keys);
        keyList.forEach(KeyBind::regis);
        updateGroup.addAll(keyList);
    }
}

