/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.network;

import com.google.common.collect.ImmutableMap;
import com.tac.guns.common.CustomGun;
import com.tac.guns.common.CustomGunLoader;
import com.tac.guns.common.Gun;
import com.tac.guns.common.NetworkGunManager;
import com.tac.guns.common.attachments.CustomModifierData;
import com.tac.guns.common.attachments.NetworkModifierManager;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class HandshakeMessages {

    public static class S2CUpdateGuns
    extends LoginIndexedMessage
    implements NetworkGunManager.IGunProvider,
    NetworkModifierManager.ICustomModifiersProvider {
        private ImmutableMap<ResourceLocation, Gun> registeredGuns;
        private ImmutableMap<ResourceLocation, CustomGun> customGuns;
        private ImmutableMap<ResourceLocation, CustomModifierData> customAttachments;

        void encode(PacketBuffer buffer) {
            Validate.notNull((Object)((Object)NetworkGunManager.get()));
            NetworkGunManager.get().writeRegisteredGuns(buffer);
            Validate.notNull((Object)((Object)CustomGunLoader.get()));
            CustomGunLoader.get().writeCustomGuns(buffer);
            NetworkModifierManager.getInstance().writeAttachments(buffer);
        }

        static S2CUpdateGuns decode(PacketBuffer buffer) {
            S2CUpdateGuns message = new S2CUpdateGuns();
            message.registeredGuns = NetworkGunManager.readRegisteredGuns(buffer);
            message.customGuns = CustomGunLoader.readCustomGuns(buffer);
            message.customAttachments = NetworkModifierManager.readModifiers(buffer);
            return message;
        }

        @Override
        @Nullable
        public ImmutableMap<ResourceLocation, Gun> getRegisteredGuns() {
            return this.registeredGuns;
        }

        @Override
        @Nullable
        public ImmutableMap<ResourceLocation, CustomGun> getCustomGuns() {
            return this.customGuns;
        }

        @Override
        @Nullable
        public ImmutableMap<ResourceLocation, CustomModifierData> getCustomModifiers() {
            return this.customAttachments;
        }
    }

    static class C2SAcknowledge
    extends LoginIndexedMessage {
        C2SAcknowledge() {
        }

        void encode(PacketBuffer buf) {
        }

        static C2SAcknowledge decode(PacketBuffer buf) {
            return new C2SAcknowledge();
        }
    }

    static class LoginIndexedMessage
    implements IntSupplier {
        private int loginIndex;

        LoginIndexedMessage() {
        }

        void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }

        int getLoginIndex() {
            return this.loginIndex;
        }

        @Override
        public int getAsInt() {
            return this.getLoginIndex();
        }
    }
}

