/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item.transition;

import com.tac.guns.Config;
import com.tac.guns.GunMod;
import com.tac.guns.client.Keys;
import com.tac.guns.common.Gun;
import com.tac.guns.common.network.ServerPlayHandler;
import com.tac.guns.interfaces.IGunModifier;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.util.GunEnchantmentHelper;
import com.tac.guns.util.GunModifierHelper;
import com.tac.guns.util.Process;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class TimelessGunItem
extends GunItem {
    private final IGunModifier[] modifiers;
    private Boolean integratedOptic = false;

    public TimelessGunItem(Process<Item.Properties> properties, IGunModifier ... modifiers) {
        super(properties.process(new Item.Properties().func_200917_a(1).func_200916_a(GunMod.GROUP)));
        this.modifiers = modifiers;
    }

    public TimelessGunItem(Process<Item.Properties> properties, Boolean integratedOptic, IGunModifier ... modifiers) {
        super(properties.process(new Item.Properties().func_200917_a(1).func_200916_a(GunMod.GROUP)));
        this.modifiers = modifiers;
        this.integratedOptic = integratedOptic;
    }

    public TimelessGunItem() {
        this((Item.Properties properties) -> properties, new IGunModifier[0]);
    }

    public Boolean isIntegratedOptic() {
        return this.integratedOptic;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flag) {
        boolean isShift;
        Gun modifiedGun = this.getModifiedGun(stack);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
        if (ammo != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.ammo_type", new Object[]{new TranslationTextComponent(ammo.func_77658_a()).func_240699_a_(TextFormatting.GOLD)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        String additionalDamageText = "";
        CompoundNBT tagCompound = stack.func_77978_p();
        float additionalDamage = GunModifierHelper.getAdditionalDamage(stack);
        if (additionalDamage > 0.0f) {
            additionalDamageText = TextFormatting.GREEN + " +" + ItemStack.field_111284_a.format(additionalDamage);
        } else if (additionalDamage < 0.0f) {
            additionalDamageText = TextFormatting.RED + " " + ItemStack.field_111284_a.format(additionalDamage);
        }
        additionalDamage = modifiedGun.getProjectile().getDamage();
        additionalDamage = GunModifierHelper.getModifiedProjectileDamage(stack, additionalDamage);
        additionalDamage = GunEnchantmentHelper.getAcceleratorDamage(stack, additionalDamage);
        tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.damage", new Object[]{TextFormatting.GOLD + ItemStack.field_111284_a.format(additionalDamage) + additionalDamageText}).func_240699_a_(TextFormatting.DARK_GRAY));
        if (tagCompound != null) {
            if (tagCompound.func_74767_n("IgnoreAmmo")) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.ignore_ammo").func_240699_a_(TextFormatting.AQUA));
            } else {
                int ammoCount = tagCompound.func_74762_e("AmmoCount");
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.ammo", new Object[]{TextFormatting.GOLD.toString() + ammoCount + "/" + GunModifierHelper.getAmmoCapacity(stack, modifiedGun)}).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
        if (!(isShift = Keys.MORE_INFO_HOLD.func_151470_d())) {
            String text = new KeybindTextComponent("key.tac.more_info_hold").getString().toUpperCase(Locale.ENGLISH);
            tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.more_info_gunitem", new Object[]{text}).func_240699_a_(TextFormatting.YELLOW));
        }
        if (isShift) {
            GunItem gun = (GunItem)stack.func_77973_b();
            if (tagCompound != null) {
                float armorPen = GunModifierHelper.getModifiedProjectileArmorIgnore(stack, (float)((Double)Config.COMMON.gameplay.percentDamageIgnoresStandardArmor.get() * (double)gun.getGun().getProjectile().getGunArmorIgnore())) >= 0.0f ? Math.min(GunModifierHelper.getModifiedProjectileArmorIgnore(stack, (float)((Double)Config.COMMON.gameplay.percentDamageIgnoresStandardArmor.get() * (double)gun.getGun().getProjectile().getGunArmorIgnore() * 100.0)), 100.0f) : 0.0f;
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.armorPen", new Object[]{new TranslationTextComponent(String.format("%.1f", Float.valueOf(armorPen)) + "%").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_AQUA));
                float headDamgeModifier = GunModifierHelper.getModifiedProjectileHeadDamage(stack, (float)((Double)Config.COMMON.gameplay.headShotDamageMultiplier.get() * (double)gun.getGun().getProjectile().getGunHeadDamage())) >= 0.0f ? GunModifierHelper.getModifiedProjectileHeadDamage(stack, (float)((Double)Config.COMMON.gameplay.headShotDamageMultiplier.get() * (double)gun.getGun().getProjectile().getGunHeadDamage())) * 100.0f : 0.0f;
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.headDamageModifier", new Object[]{new TranslationTextComponent(String.format("%.1f", Float.valueOf(headDamgeModifier)) + "%").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_AQUA));
                float speed = ServerPlayHandler.calceldGunWeightSpeed(gun.getGun(), stack);
                speed = Math.max(Math.min(speed, 0.1f), 0.075f);
                if (speed > 0.094f) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.lightWeightGun", new Object[]{new TranslationTextComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_AQUA));
                } else if ((double)speed < 0.095 && (double)speed > 0.0875) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.standardWeightGun", new Object[]{new TranslationTextComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_GREEN));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.heavyWeightGun", new Object[]{new TranslationTextComponent(-((int)((0.1 - (double)speed) * 1000.0)) + "%").func_240699_a_(TextFormatting.RED)}).func_240699_a_(TextFormatting.DARK_RED));
                }
                float percentageToNextLevel = tagCompound.func_74760_g("levelDmg") * 100.0f / (modifiedGun.getGeneral().getLevelReq() * ((float)tagCompound.func_74762_e("level") * 3.0f));
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.current_level").func_230529_a_((ITextComponent)new TranslationTextComponent(" " + tagCompound.func_74762_e("level") + " : " + String.format("%.2f", Float.valueOf(percentageToNextLevel)) + "%")).func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.BOLD));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.attachment_help", new Object[]{Keys.ATTACHMENTS.func_238171_j_().getString().toUpperCase(Locale.ENGLISH)}).func_240699_a_(TextFormatting.YELLOW));
            if (gun.getGun().canAttachType(IAttachment.Type.PISTOL_SCOPE)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.pistolScope", new Object[]{new TranslationTextComponent("MiniScope").func_240699_a_(TextFormatting.BOLD)}).func_240699_a_(TextFormatting.LIGHT_PURPLE));
            }
            if (gun.getGun().canAttachType(IAttachment.Type.IR_DEVICE)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.tac.irLaserEquip", new Object[]{new TranslationTextComponent("IrLaser").func_240699_a_(TextFormatting.BOLD)}).func_240699_a_(TextFormatting.AQUA));
            }
        }
    }

    public IGunModifier[] getModifiers() {
        return this.modifiers;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Objects.requireNonNull(TextFormatting.GOLD.func_211163_e());
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        if (((Boolean)Config.CLIENT.display.weaponAmmoBar.get()).booleanValue()) {
            CompoundNBT tagCompound = stack.func_196082_o();
            Gun modifiedGun = this.getModifiedGun(stack);
            return !tagCompound.func_74767_n("IgnoreAmmo") && tagCompound.func_74762_e("AmmoCount") != GunModifierHelper.getAmmoCapacity(stack, modifiedGun);
        }
        return false;
    }

    public boolean func_77636_d(ItemStack gunItem) {
        return false;
    }
}

