/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.item.attachment.impl;

import com.tac.guns.client.handler.AimingHandler;
import com.tac.guns.interfaces.IGunModifier;
import com.tac.guns.item.attachment.impl.Attachment;
import com.tac.guns.item.attachment.impl.ScopeZoomData;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Scope
extends Attachment {
    private double centerOffset;
    private boolean stable = false;
    private boolean needSqueeze = false;
    private double stabilityOffset = 0.0;
    private double viewFinderOffset;
    private double viewFinderOffsetSpecial;
    private double viewFinderOffsetDR;
    private double viewFinderOffsetSpecialDR;
    private ScopeZoomData[] zoomData;
    private String tagName;

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    private Scope(ScopeZoomData[] additionalZoom, double centerOffset, double stabilityOffset, String tagName, IGunModifier ... modifier) {
        super(modifier);
        this.zoomData = additionalZoom;
        this.centerOffset = centerOffset;
        this.stabilityOffset = stabilityOffset;
        this.tagName = tagName;
    }

    private Scope(ScopeZoomData[] additionalZoom, double centerOffset, double stabilityOffset, String tagName, ResourceLocation modifier) {
        super(modifier);
        this.zoomData = additionalZoom;
        this.centerOffset = centerOffset;
        this.stabilityOffset = stabilityOffset;
        this.tagName = tagName;
    }

    public void stabilise() {
        this.stable = true;
    }

    public Scope viewFinderOffset(double offset) {
        this.viewFinderOffset = offset;
        return this;
    }

    public Scope viewFinderOffsetSpecial(double offset) {
        this.viewFinderOffsetSpecial = offset;
        return this;
    }

    public boolean isNeedSqueeze() {
        return this.needSqueeze;
    }

    public Scope viewFinderOffsetDR(double offset) {
        this.viewFinderOffsetDR = offset;
        return this;
    }

    public Scope viewFinderOffsetSpecialDR(double offset) {
        this.viewFinderOffsetSpecialDR = offset;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScopeZoomData getAdditionalZoom() {
        if (this.zoomData == null || AimingHandler.get() == null) {
            return new ScopeZoomData(1.0f, 0.0f);
        }
        if (this.zoomData.length <= AimingHandler.get().getCurrentScopeZoomIndex()) {
            AimingHandler.get().resetCurrentScopeZoomIndex();
            return this.zoomData[AimingHandler.get().getCurrentScopeZoomIndex()];
        }
        return this.zoomData[AimingHandler.get().getCurrentScopeZoomIndex()];
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getCenterOffset() {
        return this.centerOffset + 0.225;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isStable() {
        return this.stable;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getViewFinderOffset() {
        return this.viewFinderOffset;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getViewFinderOffsetSpecial() {
        return this.viewFinderOffsetSpecial;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getViewFinderOffsetDR() {
        return this.viewFinderOffsetDR;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getViewFinderOffsetSpecialDR() {
        return this.viewFinderOffsetSpecialDR;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getStabilityOffset() {
        return this.stabilityOffset;
    }

    public static Scope create(ScopeZoomData[] additionalZoom, double centerOffset, double stabilityOffset, String tagName, IGunModifier ... modifiers) {
        return new Scope(additionalZoom, centerOffset, stabilityOffset, tagName, modifiers);
    }

    public static Scope create(ScopeZoomData[] additionalZoom, double centerOffset, double stabilityOffset, String tagName, ResourceLocation modifier) {
        return new Scope(additionalZoom, centerOffset, stabilityOffset, tagName, modifier);
    }

    public static Scope create(ScopeZoomData[] additionalZoom, double centerOffset, double stabilityOffset, String tagName, boolean needSqueeze, IGunModifier ... modifiers) {
        Scope scope = new Scope(additionalZoom, centerOffset, stabilityOffset, tagName, modifiers);
        scope.needSqueeze = needSqueeze;
        return scope;
    }

    public static Scope create(ScopeZoomData[] additionalZoom, double centerOffset, double stabilityOffset, String tagName, boolean needSqueeze, ResourceLocation modifier) {
        Scope scope = new Scope(additionalZoom, centerOffset, stabilityOffset, tagName, modifier);
        scope.needSqueeze = needSqueeze;
        return scope;
    }
}

