/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.entity;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class ThrowableItemEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    private ItemStack item = ItemStack.field_190927_a;
    private boolean shouldBounce;
    private float gravityVelocity = 0.03f;
    private int maxLife = 200;

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> entityType, World world, LivingEntity player) {
        super(entityType, player, world);
    }

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> entityType, World world, double x, double y, double z) {
        super(entityType, x, y, z, world);
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    protected void setShouldBounce(boolean shouldBounce) {
        this.shouldBounce = shouldBounce;
    }

    protected void setGravityVelocity(float gravity) {
        this.gravityVelocity = gravity;
    }

    protected float func_70185_h() {
        return this.gravityVelocity;
    }

    public void setMaxLife(int maxLife) {
        this.maxLife = maxLife;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.shouldBounce && this.field_70173_aa >= this.maxLife) {
            this.func_70106_y();
            this.onDeath();
        }
    }

    public void onDeath() {
    }

    protected void func_70227_a(RayTraceResult result) {
        switch (result.func_216346_c()) {
            case BLOCK: {
                BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
                if (this.shouldBounce) {
                    BlockPos resultPos = blockResult.func_216350_a();
                    BlockState state = this.field_70170_p.func_180495_p(resultPos);
                    SoundEvent event = state.func_177230_c().getSoundType(state, (IWorldReader)this.field_70170_p, resultPos, (Entity)this).func_185844_d();
                    double speed = this.func_213322_ci().func_72433_c();
                    if (speed > 0.1) {
                        this.field_70170_p.func_184148_a(null, result.func_216347_e().field_72450_a, result.func_216347_e().field_72448_b, result.func_216347_e().field_72449_c, event, SoundCategory.AMBIENT, 1.0f, 1.0f);
                    }
                    Direction direction = blockResult.func_216354_b();
                    switch (direction.func_176740_k()) {
                        case X: {
                            this.func_213317_d(this.func_213322_ci().func_216372_d(-0.5, 0.75, 0.75));
                            break;
                        }
                        case Y: {
                            this.func_213317_d(this.func_213322_ci().func_216372_d(0.75, -0.25, 0.75));
                            if (!(this.func_213322_ci().func_82617_b() < (double)this.func_70185_h())) break;
                            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                            break;
                        }
                        case Z: {
                            this.func_213317_d(this.func_213322_ci().func_216372_d(0.75, 0.75, -0.5));
                        }
                    }
                    break;
                }
                this.func_70106_y();
                this.onDeath();
                break;
            }
            case ENTITY: {
                EntityRayTraceResult entityResult = (EntityRayTraceResult)result;
                Entity entity = entityResult.func_216348_a();
                if (entity == null) break;
                break;
            }
        }
    }

    public boolean func_189652_ae() {
        return false;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeBoolean(this.shouldBounce);
        buffer.writeFloat(this.gravityVelocity);
        buffer.func_150788_a(this.item);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.shouldBounce = buffer.readBoolean();
        this.gravityVelocity = buffer.readFloat();
        this.item = buffer.func_150791_c();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

